/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.tools.install.config;

import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mx.config.ConfigServerUtility;
import com.sonicsw.mx.config.ConfigServiceException;

public class XQPluginConfig {
    private static final String DEFAULT_URL = "localhost";
    private static final String DEFAULT_USER = "Administrator";
    private static final String DEFAULT_PASSWORD = "Administrator";
    private static final String DEFAULT_DOMAIN = "Domain1";
    private String m_url = "localhost";
    private String m_user = "Administrator";
    private String m_password = null;
    private String m_domain = "Domain1";
    private String m_pluginName = null;
    private String m_pluginFactoryClassName = null;
    private String m_serviceTypeName = null;
    private ConfigServerUtility m_csu = null;
    private IDirectoryAdminService m_dsAdmin = null;

    public XQPluginConfig(String[] args) throws Exception {
        try {
            this.parseArgs(args);
            this.m_csu = new ConfigServerUtility();
            this.m_csu.connect(this.m_domain, this.m_url, this.m_user, this.m_password, true);
            this.m_dsAdmin = (IDirectoryAdminService)this.m_csu.getDirectoryService();
            this.configurePlugin(this.m_pluginName, this.m_pluginFactoryClassName, this.m_serviceTypeName);
        }
        catch (Exception e) {
            System.out.println("*Error*: " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
        finally {
            if (this.m_csu != null) {
                try {
                    this.m_csu.disconnect();
                }
                catch (ConfigServiceException configServiceException) {}
                this.m_csu = null;
                this.m_dsAdmin = null;
            }
        }
    }

    private void configurePlugin(String pluginName, String pluginFactoryClassName, String serviceTypeName) throws Exception {
        String path = "/_MFLibrary/plugins/" + pluginName;
        IDirElement element = this.m_dsAdmin.getElement(path, true);
        if (element == null) {
            throw new Exception("ConfigElement '" + path + "' not found");
        }
        IAttributeSet root = element.getAttributes();
        IAttributeList list = (IAttributeList)root.getAttribute("SERVICES");
        if (list == null) {
            list = root.createAttributeList("SERVICES");
        }
        IAttributeSet set = list.addNewAttributeSetItem();
        set.setStringAttribute("CLASS", pluginFactoryClassName);
        set.setStringAttribute("TYPE", serviceTypeName);
        this.m_dsAdmin.setElement(element.doneUpdate(), null);
    }

    private void parseArgs(String[] args) throws Exception {
        int i = 0;
        if (args.length < 6) {
            XQPluginConfig.printUsage();
            System.exit(1);
        }
        while (i < args.length) {
            if ("-url".equals(args[i])) {
                this.m_url = args[++i];
            } else if ("-user".equals(args[i])) {
                this.m_user = args[++i];
            } else if ("-password".equals(args[i])) {
                this.m_password = args[++i];
            } else if ("-domain".equals(args[i])) {
                this.m_domain = args[++i];
            } else if ("-plugin".equals(args[i])) {
                this.m_pluginName = args[++i];
            } else if ("-class".equals(args[i])) {
                this.m_pluginFactoryClassName = args[++i];
            } else if ("-type".equals(args[i])) {
                this.m_serviceTypeName = args[++i];
            }
            ++i;
        }
        if (this.m_pluginName == null) {
            throw new Exception("Plugin is not specified");
        }
        if (this.m_pluginFactoryClassName == null) {
            throw new Exception("Class is not specified");
        }
        if (this.m_serviceTypeName == null) {
            throw new Exception("Type is not specified");
        }
    }

    private static void printUsage() {
        System.out.println("com.sonicsw.mx.config.tools.install.config.XQPluginConfig ");
        System.out.println("    [-url connectionURLs]  (Default = localhost)");
        System.out.println("    [-user userName]       (Default = Administrator)");
        System.out.println("    [-password password]   (Default = Administrator)");
        System.out.println("    [-domain domainName]   (Default = Domain1)");
        System.out.println("    [-plugin pluginName]");
        System.out.println("    [-class className]");
        System.out.println("    [-type typeName]");
    }

    public static void main(String[] args) throws Exception {
        new XQPluginConfig(args);
        System.exit(0);
    }
}

