/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.tools.common;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.action.ImportCopyAction;
import com.sonicsw.deploy.action.SearchAction;
import com.sonicsw.deploy.storage.DSArtifactStorage;
import com.sonicsw.deploy.storage.FileArtifactStorage;
import com.sonicsw.deploy.tools.common.AbstractHandler;
import com.sonicsw.deploy.tools.common.ExportPropertiesArtifact;
import com.sonicsw.deploy.tools.common.ImportPropertiesFile;
import com.sonicsw.deploy.traversal.TraverserFactory;
import com.sonicsw.mf.common.IDirectoryAdminService;
import java.io.File;

public class FSToDSImportHandler
extends AbstractHandler {
    protected ImportPropertiesFile m_properties = new ImportPropertiesFile();
    protected ExportPropertiesArtifact m_exportProperties = new ExportPropertiesArtifact(true);

    public IArtifactStorage open(String path) throws Exception {
        FileArtifactStorage fs = new FileArtifactStorage();
        fs.setRoot(path);
        this.setSourceStorage(fs);
        this.m_exportProperties = new ExportPropertiesArtifact(true);
        try {
            this.m_exportProperties.init(fs.getContentsAsBytes(this.m_exportProperties));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fs;
    }

    public String getPath() {
        try {
            return ((FileArtifactStorage)this.getSourceStorage()).getRoot().getAbsolutePath();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void close() throws Exception {
        if (this.getSourceStorage() != null) {
            this.setSourceStorage(null);
        }
    }

    public ExportPropertiesArtifact getExportProperties() {
        return this.m_exportProperties;
    }

    public ImportPropertiesFile newPropertiesFile() {
        this.m_properties = new ImportPropertiesFile();
        return this.m_properties;
    }

    public ImportPropertiesFile openPropertiesFile(String path) throws Exception {
        this.m_properties = new ImportPropertiesFile(new File(path));
        return this.m_properties;
    }

    public void savePropertiesFile() throws Exception {
        if (this.m_properties == null) {
            throw new Exception("Properties is not defined");
        }
        this.m_properties.writeToFile();
    }

    public void savePropertiesAs(String path) throws Exception {
        if (this.m_properties == null) {
            throw new Exception("Properties is not defined");
        }
        this.m_properties.writeToFile(new File(path));
    }

    public void closeProperties() throws Exception {
        this.m_properties = null;
    }

    public ImportPropertiesFile getProperties() {
        return this.m_properties;
    }

    public IArtifactStorage connectToDS(String domain, String url, String user, String password) throws Exception {
        DSArtifactStorage ds = (DSArtifactStorage)this.getDestinationStorage();
        if (ds != null) {
            return ds;
        }
        ds = new DSArtifactStorage();
        try {
            this.setDestinationStorage(ds);
            ds.connect(domain, url, user, password);
        }
        catch (Exception e) {
            this.setDestinationStorage(null);
            throw e;
        }
        return ds;
    }

    public IArtifactStorage connectToDS(IDirectoryAdminService dsProxy, String domain, String user) throws Exception {
        DSArtifactStorage ds = (DSArtifactStorage)this.getDestinationStorage();
        if (ds != null) {
            return ds;
        }
        ds = new DSArtifactStorage();
        try {
            this.setDestinationStorage(ds);
            ds.connect(dsProxy, domain, user);
        }
        catch (Exception e) {
            this.setDestinationStorage(null);
            throw e;
        }
        return ds;
    }

    public void disconnectFromDS() throws Exception {
        if (this.getDestinationStorage() != null) {
            ((DSArtifactStorage)this.getDestinationStorage()).disconnect();
            this.setDestinationStorage(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importToDS(String domain, String url, String user, String password) throws Exception {
        try {
            this.connectToDS(domain, url, user, password);
            this.importToDS();
        }
        finally {
            this.disconnectFromDS();
        }
    }

    public void importToDS() throws Exception {
        if (this.m_properties == null) {
            throw new Exception("Import Properties are not defined");
        }
        if (this.getSourceStorage() == null) {
            throw new Exception("Source zip archive is not defined");
        }
        if (this.getDestinationStorage() == null) {
            throw new Exception("Destination DS archive is not defined");
        }
        ImportCopyAction.copyTo(this.getSourceStorage(), this.getDestinationStorage(), this.listAllZip(), this.m_properties);
    }

    public IArtifact[] listAllZip() throws Exception {
        return SearchAction.search(this.getSourceStorage(), null, TraverserFactory.createListAllTraverser());
    }
}

