/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.mgmtapi.config.impl;

import com.sonicsw.esb.mgmtapi.ESBAPIContext;
import com.sonicsw.esb.mgmtapi.ESBAPIException;
import com.sonicsw.esb.mgmtapi.config.IServiceConfig;
import com.sonicsw.esb.mgmtapi.config.IServiceConfigAPI;
import com.sonicsw.esb.mgmtapi.config.IServiceTypeConfig;
import com.sonicsw.xqimpl.config.IConfigSPI;
import com.sonicsw.xqimpl.config.IConfiguration;
import com.sonicsw.xqimpl.config.XQConfigurationException;
import com.sonicsw.xqimpl.config.XQServiceTypeConfig;
import java.io.StringBufferInputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class ServiceConfigAPI
implements IServiceConfigAPI {
    public IConfigSPI configBackend;

    public ServiceConfigAPI(IConfigSPI m_configbackend) {
        this.configBackend = m_configbackend;
    }

    public IServiceConfig getServiceConfig(String name) {
        IServiceConfig cfg = (IServiceConfig)this.configBackend.getConfiguration(name, "service");
        return cfg;
    }

    public String[] listServiceConfigs() {
        String[] services = this.configBackend.listConfigurations("service");
        String[] processes = this.configBackend.listConfigurations("process");
        HashSet<String> r = new HashSet<String>();
        r.addAll(Arrays.asList(services));
        r.removeAll(Arrays.asList(processes));
        return r.toArray(new String[r.size()]);
    }

    public String[] listServiceTypes() {
        String[] ret = this.configBackend.listConfigurations("serviceType");
        return ret;
    }

    public IServiceTypeConfig getServiceType(String name) {
        IServiceTypeConfig cfg = (IServiceTypeConfig)this.configBackend.getConfiguration(name, "serviceType");
        return cfg;
    }

    public IServiceTypeConfig importServiceType(String serviceTypeContent, boolean overwrite) {
        IConfiguration ret = this.configBackend.importConfiguration(serviceTypeContent, "serviceType", overwrite, true);
        return (IServiceTypeConfig)ret;
    }

    public void importServiceProperties(String serviceName, String serviceProperties) {
        Properties p = new Properties();
        ESBAPIContext ctx = new ESBAPIContext("importServiceProperties");
        ctx.setObjectId(serviceName);
        ctx.setObjectType(IServiceTypeConfig.class.getName());
        IServiceTypeConfig svc = this.getServiceType(serviceName);
        if (svc == null) {
            throw new ESBAPIException((Exception)new IllegalArgumentException("service type not found"), ctx);
        }
        try {
            ctx.setDescr("loading properties");
            StringBufferInputStream is = new StringBufferInputStream(serviceProperties);
            p.load(is);
        }
        catch (Exception e) {
            throw new ESBAPIException(e, ctx);
        }
        try {
            XQServiceTypeConfig xsvc = (XQServiceTypeConfig)svc;
            ctx.setDescr("importing file");
            this.configBackend.importFile(serviceProperties, xsvc.getPropertiesFileLocation(false), true);
            ctx.setDescr("refreshing parameter config");
            xsvc.refresh();
        }
        catch (XQConfigurationException e) {
            throw new ESBAPIException((Exception)((Object)e), ctx);
        }
    }

    public IServiceConfig createServiceConfig(String name, String serviceTypeName) {
        IServiceTypeConfig srvType = (IServiceTypeConfig)this.configBackend.getConfiguration(serviceTypeName, "serviceType");
        if (srvType == null) {
            throw new ESBAPIException((Exception)new IllegalArgumentException(serviceTypeName + " does not exist"));
        }
        IServiceConfig cfg = (IServiceConfig)this.configBackend.createConfiguration(name, "service");
        cfg.setServiceTypeConfig(srvType);
        return cfg;
    }

    public void deleteServiceConfig(String name) {
        this.configBackend.deleteConfiguration(name, "service");
    }

    public void deleteServiceType(String serviceTypeName) {
        this.configBackend.deleteConfiguration(serviceTypeName, "serviceType");
    }

    public void saveService(IServiceConfig service) {
        this.configBackend.saveConfiguration((IConfiguration)service);
    }

    public void saveServiceType(IServiceTypeConfig serviceType) {
        this.configBackend.saveConfiguration((IConfiguration)serviceType);
    }

    public String exportService(String name) {
        IServiceConfig cfg = this.getServiceConfig(name);
        if (cfg == null) {
            return null;
        }
        String ret = this.configBackend.exportConfiguration((IConfiguration)cfg);
        return ret;
    }

    public String exportServiceType(String name) {
        IServiceTypeConfig svcType = this.getServiceType(name);
        String ret = this.configBackend.exportConfiguration((IConfiguration)svcType);
        return ret;
    }

    public IServiceConfig importService(String configurationContent, boolean overwrite) {
        IConfiguration imported = this.configBackend.importConfiguration(configurationContent, "service", overwrite, true);
        return (IServiceConfig)imported;
    }

    public String[] listContainersWithService(String serviceName) {
        Set qresult = this.configBackend.executePhysQueryListContains("/xqContainers", "services", serviceName, "name");
        String[] ret = qresult.toArray(new String[qresult.size()]);
        return ret;
    }

    public String[] listContainersWithServiceType(String serviceTypeName) {
        HashSet cumulative = new HashSet();
        Set serviceConfigs = this.configBackend.executePhysQuery("/xqServices", "type_ref", serviceTypeName, "name");
        for (String serviceName : serviceConfigs) {
            Set temp = this.configBackend.executePhysQueryListContains("/xqContainers", "services", serviceName, "name");
            cumulative.addAll(temp);
        }
        return cumulative.toArray(new String[cumulative.size()]);
    }

    public String[] listServiceConfigOfType(String serviceTypeName) {
        Set qresult = this.configBackend.executePhysQuery("/xqServices", "type_ref", serviceTypeName, "name");
        String[] ret = qresult.toArray(new String[0]);
        return ret;
    }
}

