/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.action;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.action.AbstractAction;
import com.sonicsw.deploy.action.SearchAction;
import com.sonicsw.deploy.artifact.SystemArtifact;
import com.sonicsw.deploy.traversal.SystemListTraverser;
import com.sonicsw.deploy.traversal.TraverserFactory;
import com.sonicsw.deploy.util.MapApplicator;
import java.io.File;

public class ApplyMapAction
extends AbstractAction {
    private File m_mapFile;
    private File m_logFile;

    public ApplyMapAction(File mapFile, File logFile) {
        this.m_mapFile = mapFile;
        this.m_logFile = logFile;
    }

    @Override
    public String getDescription() {
        return "ApplyMap";
    }

    @Override
    public void run(IArtifactStorage source, IArtifactStorage dest) throws Exception {
        int i;
        IArtifact[] nonSystemArtifacts = SearchAction.search(source, null, TraverserFactory.createListAllTraverser(), true);
        IArtifact[] systemArtifacts = SearchAction.search(source, null, new SystemListTraverser(SystemArtifact.ROOT));
        int totalArtifacts = nonSystemArtifacts.length + systemArtifacts.length;
        IArtifact[] artifacts = new IArtifact[totalArtifacts];
        int artifactArrayPos = 0;
        for (i = 0; i < nonSystemArtifacts.length; ++i) {
            artifacts[artifactArrayPos] = nonSystemArtifacts[i];
            ++artifactArrayPos;
        }
        for (i = 0; i < systemArtifacts.length; ++i) {
            artifacts[artifactArrayPos] = systemArtifacts[i];
            ++artifactArrayPos;
        }
        new MapApplicator(source).ApplyMapFile(this.m_mapFile, this.m_logFile, dest, artifacts);
    }

    public static void applyMap(IArtifactStorage source, IArtifactStorage dest, File mapFile, File logFile) throws Exception {
        source.performActionTo(dest, new ApplyMapAction(mapFile, logFile));
    }
}

