/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.tools.common;

import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.storage.ZipArtifactStorage;
import com.sonicsw.deploy.tools.common.DSToFSExportHandler;
import com.sonicsw.deploy.tools.common.ExportPropertiesArtifact;

public class DSToZipExportHandler
extends DSToFSExportHandler {
    @Override
    public IArtifactStorage open(String path, boolean create) throws Exception {
        ZipArtifactStorage zip = new ZipArtifactStorage();
        this.setDestinationStorage(zip);
        zip.openArchive(path, create);
        this.m_properties = new ExportPropertiesArtifact();
        try {
            this.m_properties.init(zip.getContentsAsBytes(this.m_properties));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return zip;
    }

    public IArtifactStorage newZip() throws Exception {
        if (this.getDestinationStorage() == null) {
            this.setDestinationStorage(new ZipArtifactStorage());
        }
        ZipArtifactStorage zip = (ZipArtifactStorage)this.getDestinationStorage();
        zip.newArchive();
        if (this.m_properties == null) {
            this.m_properties = new ExportPropertiesArtifact();
        } else {
            this.m_properties.defaultIgnoreList();
            this.m_properties.clearRootList();
        }
        return zip;
    }

    @Override
    public void save() throws Exception {
        if (this.getDestinationStorage() == null) {
            throw new Exception("Zip storage is not defined");
        }
        this.getDestinationStorage().store(this.m_properties, this.m_properties.getContent());
        ((ZipArtifactStorage)this.getDestinationStorage()).saveArchive();
    }

    public void saveZipAs(String path) throws Exception {
        if (this.getDestinationStorage() == null) {
            throw new Exception("Zip storage is not defined");
        }
        this.getDestinationStorage().store(this.m_properties, this.m_properties.getContent());
        ((ZipArtifactStorage)this.getDestinationStorage()).saveArchiveAs(path);
    }

    @Override
    public void close() throws Exception {
        if (this.getDestinationStorage() != null) {
            ((ZipArtifactStorage)this.getDestinationStorage()).closeArchive();
            this.setDestinationStorage(null);
        }
    }
}

