/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.traversal;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactTraversalContext;
import com.sonicsw.deploy.artifact.ESBArtifact;
import com.sonicsw.deploy.traversal.AbstractESBTraverser;
import com.sonicsw.deploy.traversal.ESBTraverserFactory;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ESBConnectionTraverser
extends AbstractESBTraverser {
    private static final IArtifact InheritBusConnectionArtifact = new ESBArtifact(ESBArtifact.CONNECTION, "{INHERIT_BUS_CONNECTION}");
    private static final Pattern ELExpressionPattern = Pattern.compile(".*\\Q${\\E.*");

    public static boolean isELExpression(String expression) {
        return ELExpressionPattern.matcher(expression).matches();
    }

    public ESBConnectionTraverser(IArtifact artifact) {
        super(artifact);
    }

    @Override
    public void traverse(IArtifactTraversalContext context) throws Exception {
        if (InheritBusConnectionArtifact.equals(this.m_artifact)) {
            return;
        }
        if (ESBConnectionTraverser.isELExpression(this.m_artifact.getName())) {
            this.traverseURLRefs(this.m_artifact.getName(), context);
            return;
        }
        super.traverse(context);
    }

    @Override
    public void doTraversal(IArtifactTraversalContext context) throws Exception {
        Document doc = context.getStorage().getContentsAsDom(this.m_artifact);
        Element con = doc.getDocumentElement();
        String conType = con.getAttribute("type_ref");
        ESBTraverserFactory.createConnectionTypeTraverser(conType).traverse(context);
    }
}

