/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.mgmtapi.runtime.impl;

import com.sonicsw.esb.mgmtapi.ESBAPIException;
import com.sonicsw.esb.mgmtapi.runtime.IMonitoredContainerRuntimeAPI;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.runtime.IComponentState;
import com.sonicsw.mf.common.runtime.IContainerState;
import com.sonicsw.mf.common.runtime.IIdentity;
import com.sonicsw.mf.common.runtime.IState;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.xqimpl.config.IConfigSPI;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MonitoredContainerRuntimeAPI
implements IMonitoredContainerRuntimeAPI {
    private static String DEFAULT_AUTO_LAUNCH_COMPONENT_ID = "AutoLaunchDaemon";
    private static final String[] LAUNCH_CONTAINER_SIGNATURE = new String[]{String.class.getName()};
    private IConfigSPI m_domainConnection;
    private ObjectName m_daemonRuntimeID;

    public MonitoredContainerRuntimeAPI(IConfigSPI connection) throws ESBAPIException {
        this.m_domainConnection = connection;
        try {
            this.m_daemonRuntimeID = new ObjectName(this.m_domainConnection.getDomainName() + "." + "DIRECTORY SERVICE" + ":ID=" + DEFAULT_AUTO_LAUNCH_COMPONENT_ID);
        }
        catch (MalformedObjectNameException e) {
            throw new ESBAPIException((Exception)e);
        }
    }

    public void launchMFContainer(String containerID) throws ESBAPIException {
        IConfigElement el = this.m_domainConnection.loadConfigElement(containerID);
        if (el == null) {
            throw new ESBAPIException("Cannot launch container " + containerID + " because it is not found");
        }
        try {
            String storageName = this.m_domainConnection.logicalToStorage(containerID);
            Object[] params = new Object[]{storageName};
            this.m_domainConnection.invoke(this.m_daemonRuntimeID, "launch", params, LAUNCH_CONTAINER_SIGNATURE);
        }
        catch (Exception mBeanE) {
            throw new ESBAPIException(mBeanE);
        }
    }

    public void shutdownMFContainer(String canonicalName) throws ESBAPIException {
        try {
            IContainerState state = this.getMFContainerState(canonicalName);
            if (state == null) {
                throw new ESBAPIException("Cannot shutdown container " + canonicalName + " because the container doesn't exist");
            }
            ObjectName containerID = new ObjectName(canonicalName + ":ID=" + "AGENT");
            this.m_domainConnection.invoke(containerID, "shutdown", new Object[0], new String[0]);
        }
        catch (Exception mBeanE) {
            if (mBeanE instanceof ESBAPIException) {
                throw (ESBAPIException)((Object)mBeanE);
            }
            throw new ESBAPIException(mBeanE);
        }
    }

    public void startMFComponent(String containerName, String componentName) {
        String componentRuntimeID = null;
        String containerRuntimeID = this.getRuntimeContainerObjectName(containerName);
        IContainerState containerState = this.getMFContainerState(containerRuntimeID);
        if (containerState == null) {
            throw new ESBAPIException("startMFComponent: cannot start component " + componentName + " in container " + containerName + " because the container does not exist");
        }
        if (containerState.getState() != 3) {
            throw new ESBAPIException("startMFComponent: cannot start component " + componentName + " in container " + containerName + " because the container is not online");
        }
        IComponentState[] compStates = containerState.getComponentStates();
        for (int i = 0; i < compStates.length; ++i) {
            IComponentState cState = compStates[i];
            IIdentity runtimeID = cState.getRuntimeIdentity();
            String canonicalName = runtimeID.getCanonicalName();
            if (canonicalName.equals(componentName)) {
                componentRuntimeID = canonicalName;
            }
            try {
                IElementIdentity configID;
                String storageName = this.m_domainConnection.logicalToStorage(componentName);
                if (storageName != null && (configID = runtimeID.getConfigIdentity()).getName().equals(storageName)) {
                    componentRuntimeID = canonicalName;
                }
            }
            catch (Exception storageName) {
                // empty catch block
            }
            int dotIndex = canonicalName.lastIndexOf("ID=");
            if (!canonicalName.substring(dotIndex + 3).equals(componentName)) continue;
            componentRuntimeID = canonicalName;
        }
        if (componentRuntimeID != null) {
            try {
                this.m_domainConnection.invoke(new ObjectName(componentRuntimeID), "start", new Object[0], new String[0]);
            }
            catch (Throwable thr) {
                ESBAPIException e = new ESBAPIException("startMFComponent:error while starting component " + componentRuntimeID + ": " + thr);
                e.initCause(thr);
                throw e;
            }
        } else {
            throw new ESBAPIException("startMFComponent: component " + componentName + " has not been started because it was not found in container " + containerName);
        }
    }

    public void restartMFContainer(String canonicalName) throws ESBAPIException {
        try {
            IContainerState state = this.getMFContainerState(canonicalName);
            if (state == null) {
                throw new ESBAPIException("Cannot restart container " + canonicalName + " because the container doesn't exist");
            }
            ObjectName containerID = new ObjectName(canonicalName + ":ID=" + "AGENT");
            this.m_domainConnection.invoke(containerID, "restart", new Object[0], new String[0]);
        }
        catch (Exception mBeanE) {
            if (mBeanE instanceof ESBAPIException) {
                throw (ESBAPIException)((Object)mBeanE);
            }
            throw new ESBAPIException(mBeanE);
        }
    }

    public boolean isMFComponentOnline(String containerName, String componentName) throws ESBAPIException {
        String containerRuntimeID = this.getRuntimeContainerObjectName(containerName);
        IContainerState containerState = this.getMFContainerState(containerRuntimeID);
        if (containerState == null) {
            throw new ESBAPIException("isMFComponentOnline: cannot find component " + componentName + " in container " + containerName + " because the container does not exist");
        }
        if (containerState.getState() != 3) {
            return false;
        }
        IComponentState[] compStates = containerState.getComponentStates();
        for (int i = 0; i < compStates.length; ++i) {
            IComponentState cState = compStates[i];
            IIdentity runtimeID = cState.getRuntimeIdentity();
            String canonicalName = runtimeID.getCanonicalName();
            if (canonicalName.equals(componentName)) {
                return cState.getState() == 3;
            }
            try {
                IElementIdentity configID;
                String storageName = this.m_domainConnection.logicalToStorage(componentName);
                if (storageName != null && (configID = runtimeID.getConfigIdentity()).getName().equals(storageName)) {
                    return cState.getState() == 3;
                }
            }
            catch (Exception storageName) {
                // empty catch block
            }
            int dotIndex = canonicalName.lastIndexOf("ID=");
            if (!canonicalName.substring(dotIndex + 3).equals(componentName)) continue;
            return cState.getState() == 3;
        }
        return false;
    }

    public void reloadMFComponent(String containerName, String componentName) throws ESBAPIException {
        try {
            String containerRuntimeID = this.getRuntimeContainerObjectName(containerName);
            IContainerState state = this.getMFContainerState(containerRuntimeID);
            if (state == null) {
                throw new ESBAPIException("Cannot reload from container " + containerName + " because the container doesn't exist");
            }
            if (state.getState() != 3) {
                throw new ESBAPIException("Container " + containerName + " is not online, so component " + componentName + " cannot be reloaded");
            }
            String componentRuntimeName = this.getComponentRuntimeName(containerRuntimeID, componentName);
            ObjectName componentID = new ObjectName(componentRuntimeName);
            this.m_domainConnection.invoke(componentID, "reload", new Object[0], new String[0]);
        }
        catch (Exception mBeanE) {
            if (mBeanE instanceof ESBAPIException) {
                throw (ESBAPIException)((Object)mBeanE);
            }
            throw new ESBAPIException(mBeanE);
        }
    }

    public void clearLogFiles(String containerRuntimeID) {
        try {
            IContainerState state = this.getMFContainerState(containerRuntimeID);
            if (state == null) {
                throw new ESBAPIException("Cannot clear the logs of " + containerRuntimeID + " because the container cannot be found");
            }
            if (state.getState() != 3) {
                throw new ESBAPIException("Cannot clear the logs of " + containerRuntimeID + " because it is not online");
            }
            ObjectName agentObjectName = new ObjectName(containerRuntimeID + ":ID=" + "AGENT");
            this.m_domainConnection.invoke(agentObjectName, "clearLogFile", new Object[0], new String[0]);
        }
        catch (Exception mBeanE) {
            if (mBeanE instanceof ESBAPIException) {
                throw (ESBAPIException)((Object)mBeanE);
            }
            throw new ESBAPIException(mBeanE);
        }
    }

    private String getComponentRuntimeName(String containerRuntimeID, String componentName) {
        IConfigElement mfComponent = null;
        try {
            try {
                mfComponent = this.m_domainConnection.loadConfigElement(componentName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (mfComponent != null) {
                String storageName = this.m_domainConnection.logicalToStorage(componentName);
                IContainerState containerState = this.getMFContainerState(containerRuntimeID);
                IComponentState[] compStates = containerState.getComponentStates();
                for (int i = 0; i < compStates.length; ++i) {
                    IComponentState cState = compStates[i];
                    IIdentity runtimeID = cState.getRuntimeIdentity();
                    IElementIdentity configID = runtimeID.getConfigIdentity();
                    if (!configID.getName().equals(storageName)) continue;
                    return runtimeID.getCanonicalName();
                }
                throw new ESBAPIException("Could not find the runtime ID for " + componentName + " in " + containerRuntimeID);
            }
            if (componentName.indexOf("ID=") == -1) {
                return containerRuntimeID + ":ID=" + componentName;
            }
            return componentName;
        }
        catch (ESBAPIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ESBAPIException(e);
        }
    }

    private String getRuntimeContainerObjectName(String containerName) {
        String containerNameAttrVal = null;
        try {
            IConfigElement container = this.m_domainConnection.loadConfigElement(containerName);
            if (container != null) {
                containerNameAttrVal = (String)container.getAttribute("CONTAINER_NAME");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (containerNameAttrVal == null) {
            return containerName;
        }
        return this.m_domainConnection.getDomainName() + "." + containerNameAttrVal;
    }

    public IContainerState getMFContainerState(String containerName) throws ESBAPIException {
        try {
            ObjectName id = new ObjectName(this.m_domainConnection.getDomainName() + "." + "DIRECTORY SERVICE" + ":ID=" + "AGENT MANAGER");
            Object[] arguments = new Object[]{new String[]{this.getRuntimeContainerObjectName(containerName)}};
            IState[] states = (IState[])this.m_domainConnection.invoke(id, "getCollectiveState", arguments, new String[]{String[].class.getName()});
            for (int i = 0; i < states.length; ++i) {
                if (!(states[i] instanceof IContainerState)) continue;
                return (IContainerState)states[i];
            }
            return null;
        }
        catch (MalformedObjectNameException e) {
            throw new ESBAPIException((Exception)e);
        }
    }

    public void setContainerLaunchActivationDaemon(String containerName, String daemonName) throws ESBAPIException {
        try {
            this.m_daemonRuntimeID = new ObjectName(this.m_domainConnection.getDomainName() + "." + containerName + ":ID=" + daemonName);
        }
        catch (MalformedObjectNameException e) {
            throw new ESBAPIException((Exception)e);
        }
    }
}

