/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.tools.migration;

import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.InvalidXMLException;
import com.sonicsw.mf.jmx.client.DirectoryServiceProxy;
import com.sonicsw.xqimpl.tools.migration.Constants;
import com.sonicsw.xqimpl.tools.migration.Migration;
import com.sonicsw.xqimpl.util.URLUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Element;

public class DirectoryMigration {
    private String m_stylesheet;
    private String m_directory;
    private String m_schemaPath;
    private File m_backupDirectory;
    private Migration m_parent;
    private static final TransformerFactory factory = TransformerFactory.newInstance();

    public DirectoryMigration(Element directoryMigration, Migration parent, String xqHomePath, File backupDirectory) {
        this.m_parent = parent;
        this.m_schemaPath = xqHomePath + File.separator + Constants.MF_SCHEMA_DIR_AND_FILE;
        this.m_backupDirectory = backupDirectory;
        if (!this.m_backupDirectory.exists()) {
            this.m_backupDirectory.mkdir();
        }
        this.m_directory = directoryMigration.getAttribute("directory");
        this.m_stylesheet = directoryMigration.getAttribute("stylesheet");
    }

    public String getStylesheet() {
        return this.m_stylesheet;
    }

    public String getDirectory() {
        return this.m_directory;
    }

    public void migrate(DirectoryServiceProxy proxy) throws IOException, FileNotFoundException, DirectoryServiceException, InvalidXMLException, TransformerConfigurationException, TransformerException {
        String export = proxy.exportDirectoryToXML(this.getDirectory());
        this.backup(export);
        String transform = this.transform(export);
        proxy.importFromXML(transform);
    }

    private void backup(String export) throws IOException {
        File backup = new File(this.m_backupDirectory, this.m_directory.substring(1) + ".xml");
        BufferedWriter out = new BufferedWriter(new FileWriter(backup));
        out.write(export);
        out.flush();
        out.close();
        System.out.println("Wrote backup to " + backup.getAbsoluteFile());
    }

    private String transform(String export) throws TransformerConfigurationException, TransformerException {
        InputStream in = this.m_parent.getResourceAsStream(this.m_stylesheet);
        StreamSource source = new StreamSource(in, "");
        Transformer transform = factory.newTransformer(source);
        transform.setParameter("currentTime", this.m_parent.getStartTime());
        transform.setParameter("migrationName", this.m_parent.getName());
        String schemaLoc = URLUtil.makeFileURL((String)this.m_schemaPath);
        transform.setParameter("schemaLocation", "http://www.sonicsw.com/mf " + schemaLoc);
        transform.setParameter("suiteName", this.m_parent.getSuiteName());
        StringWriter writer = new StringWriter();
        transform.transform(new StreamSource(new StringReader(export)), new StreamResult(writer));
        return writer.toString();
    }
}

