/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.traversal;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactTraversalContext;
import com.sonicsw.deploy.artifact.ESBArtifact;
import com.sonicsw.deploy.traversal.AbstractTraverser;
import com.sonicsw.deploy.traversal.ESBTraverserFactory;
import com.sonicsw.xqimpl.util.DOMUtils;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractESBTraverser
extends AbstractTraverser {
    private static final String MULTIPLE_ADDRESSES_SEPARATOR = ",";

    public AbstractESBTraverser(IArtifact artifact) {
        super(artifact);
    }

    protected void traverseEndpoints(IArtifactTraversalContext context, Element element, String endpointElementName) throws Exception {
        if (element == null) {
            return;
        }
        NodeList nl = element.getElementsByTagNameNS("http://www.sonicsw.com/sonicxq", endpointElementName);
        for (int i = 0; i < nl.getLength(); ++i) {
            Element ep = (Element)nl.item(i);
            String type = ep.getAttribute("type");
            String ep_ref = ep.getAttribute("endpoint_ref");
            if (type.equalsIgnoreCase("SERVICE")) {
                ESBTraverserFactory.createServiceTraverser(ep_ref).traverse(context);
                continue;
            }
            if (type.equalsIgnoreCase("PROCESS")) {
                ESBTraverserFactory.createProcessTraverser(ep_ref).traverse(context);
                continue;
            }
            if (!type.equalsIgnoreCase("ENDPOINT")) continue;
            ESBTraverserFactory.createEndpointTraverser(ep_ref).traverse(context);
        }
    }

    protected void traverseParameters(IArtifactTraversalContext context, Element params) throws Exception {
        if (params == null) {
            return;
        }
        NodeList children = params.getChildNodes();
        block3: for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            switch (child.getNodeType()) {
                case 1: {
                    String[] tokens;
                    String text;
                    String url = ((Element)child).getAttribute("url");
                    if (url != null && url.length() > 0) {
                        this.traverseURLRefs(url, context, true);
                        continue block3;
                    }
                    if (child.getLocalName().equals("xmlParam")) {
                        this.traverseChildNodes(child.getChildNodes(), context);
                        continue block3;
                    }
                    if (!child.getLocalName().equals("stringParam") || (text = DOMUtils.getFirstTextChildValue((Element)((Element)child))) == null || this.traverseURLRefs(text, context, true)) continue block3;
                    for (String token : tokens = text.split(MULTIPLE_ADDRESSES_SEPARATOR)) {
                        this.traverseESBAddress(token.trim(), context);
                    }
                    continue block3;
                }
            }
        }
    }

    private IArtifact traverseESBAddress(String val, IArtifactTraversalContext context) throws Exception {
        ESBArtifact artifact = null;
        if (val.endsWith(":SERVICE")) {
            artifact = new ESBArtifact(ESBArtifact.SERVICE, val.substring(0, val.lastIndexOf(58)));
        } else if (val.endsWith(":PROCESS")) {
            artifact = new ESBArtifact(ESBArtifact.PROCESS, val.substring(0, val.lastIndexOf(58)));
        } else if (val.endsWith(":ENDPOINT")) {
            artifact = new ESBArtifact(ESBArtifact.ENDPOINT, val.substring(0, val.lastIndexOf(58)));
        } else if (val.toLowerCase().startsWith("SERVICE".toLowerCase() + ':')) {
            artifact = new ESBArtifact(ESBArtifact.SERVICE, val.substring(val.indexOf(58) + 1).trim());
        } else if (val.toLowerCase().startsWith("PROCESS".toLowerCase() + ':')) {
            artifact = new ESBArtifact(ESBArtifact.PROCESS, val.substring(val.indexOf(58) + 1).trim());
        } else if (val.toLowerCase().startsWith("ENDPOINT".toLowerCase() + ':')) {
            artifact = new ESBArtifact(ESBArtifact.ENDPOINT, val.substring(val.indexOf(58) + 1).trim());
        }
        if (artifact != null) {
            ESBTraverserFactory.createTraverser(artifact).traverse(context);
        }
        return artifact;
    }

    protected void traverseFaultHandler(IArtifactTraversalContext context, Element fhElem) throws Exception {
        if (fhElem == null) {
            return;
        }
        String ep_ref = fhElem.getAttribute("endpoint_ref");
        String type = fhElem.getAttribute("type");
        if (type.equalsIgnoreCase("SERVICE")) {
            ESBTraverserFactory.createServiceTraverser(ep_ref).traverse(context);
        } else if (type.equalsIgnoreCase("PROCESS")) {
            ESBTraverserFactory.createProcessTraverser(ep_ref).traverse(context);
        } else if (type.equalsIgnoreCase("ENDPOINT")) {
            ESBTraverserFactory.createEndpointTraverser(ep_ref).traverse(context);
        }
    }

    protected void traverseClassLoading(IArtifactTraversalContext context, Element element, String typeName) throws Exception {
        Element cp;
        if (element == null) {
            return;
        }
        Element type = DOMUtils.getImmediateChildElementByName((Element)element, (String)typeName);
        if (type != null && (cp = DOMUtils.getImmediateChildElementByName((Element)type, (String)"classpath_list")) != null) {
            List list = DOMUtils.getImmediateChildElementsByName((Element)cp, (String)"classpath");
            for (int i = 0; i < list.size(); ++i) {
                this.traverseURLRefs(DOMUtils.getFirstTextChildValue((Element)((Element)list.get(i))), context);
            }
        }
    }
}

