/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.tools.admin;

import com.sonicsw.esb.mgmtapi.ESBAPI;
import com.sonicsw.esb.mgmtapi.ESBAPIException;
import com.sonicsw.esb.mgmtapi.ESBAPIFactory;
import com.sonicsw.esb.mgmtapi.runtime.IContainerRuntimeAPI;
import com.sonicsw.esb.mgmtapi.runtime.IMonitoredContainerRuntimeAPI;
import com.sonicsw.xqimpl.tools.common.DSConnectionDetails;
import com.sonicsw.xqimpl.tools.common.IESBContainerInfo;
import java.io.PrintStream;
import java.text.MessageFormat;

public class ESBContainerCommands {
    protected static final long CONNECTION_TIMEOUT = 30000L;
    private static final String SUCCESS_MASK = "The {0} container ''{1}'' was successfully {2}.";
    private static final String ALREADY_MASK = "The {0} container ''{1}'' is already {2}, nothing to do.";
    protected PrintStream m_outputStream;
    protected DSConnectionDetails m_connectionDetails;
    protected ESBAPI m_esbAPI;

    public ESBContainerCommands(DSConnectionDetails conxDetails, PrintStream outputStream) {
        this.m_connectionDetails = conxDetails;
        this.m_outputStream = outputStream;
    }

    protected void init() {
        if (this.m_esbAPI == null) {
            ESBAPIFactory factory = this.getESBAPIFactory();
            factory.setRequestTimeout(30000L);
            this.m_esbAPI = factory.createAPI(this.m_connectionDetails.getDomainName(), this.m_connectionDetails.getUrl(), this.m_connectionDetails.getUserName(), this.m_connectionDetails.getPassword());
        }
    }

    public void start(IESBContainerInfo containerInfo) {
        try {
            this.init();
            IMonitoredContainerRuntimeAPI mcr = this.getMonitoredContainerRuntimeAPI();
            if (mcr.isMFComponentOnline(containerInfo.getMFContainerCanonicalName(), containerInfo.getESBContainerName())) {
                this.printMessage(ALREADY_MASK, "ESB", containerInfo.getESBContainerName(), "online");
            } else {
                mcr.startMFComponent(containerInfo.getMFContainerCanonicalName(), containerInfo.getESBContainerName());
                this.printMessage(SUCCESS_MASK, "ESB", containerInfo.getESBContainerName(), "started");
            }
        }
        catch (Exception e) {
            this.m_outputStream.println(e);
        }
    }

    public void startMFContainer(IESBContainerInfo containerInfo) {
        try {
            this.init();
            IMonitoredContainerRuntimeAPI mcr = this.getMonitoredContainerRuntimeAPI();
            if (1 == mcr.getMFContainerState(containerInfo.getMFContainerCanonicalName()).getState()) {
                mcr.launchMFContainer(containerInfo.getMFContainerLocation());
                this.waitForMFContainerToBeOnline(mcr, containerInfo);
                this.printMessage(SUCCESS_MASK, "MF", containerInfo.getMFContainerName(), "started");
            } else {
                this.printMessage(ALREADY_MASK, "MF", containerInfo.getMFContainerName(), "online");
            }
        }
        catch (Exception e) {
            this.m_outputStream.println(e);
        }
    }

    public void abort(IESBContainerInfo containerInfo) {
        try {
            this.init();
            IMonitoredContainerRuntimeAPI mcr = this.getMonitoredContainerRuntimeAPI();
            if (mcr.isMFComponentOnline(containerInfo.getMFContainerCanonicalName(), containerInfo.getESBContainerName())) {
                this.getContainerRuntimeAPI(containerInfo).abortContainer();
                this.printMessage(SUCCESS_MASK, "ESB", containerInfo.getESBContainerName(), "aborted");
            } else {
                this.printMessage(ALREADY_MASK, "ESB", containerInfo.getESBContainerName(), "offline");
            }
        }
        catch (ESBAPIException e) {
            this.m_outputStream.println((Object)e);
        }
    }

    public void shutdownMFContainer(IESBContainerInfo containerInfo) {
        try {
            this.init();
            IMonitoredContainerRuntimeAPI mcr = this.getMonitoredContainerRuntimeAPI();
            if (3 == mcr.getMFContainerState(containerInfo.getMFContainerCanonicalName()).getState()) {
                mcr.shutdownMFContainer(containerInfo.getMFContainerCanonicalName());
                this.printMessage(SUCCESS_MASK, "MF", containerInfo.getMFContainerName(), "shutdown");
            } else {
                this.printMessage(ALREADY_MASK, "MF", containerInfo.getMFContainerName(), "offline");
            }
        }
        catch (ESBAPIException e) {
            this.m_outputStream.println((Object)e);
        }
    }

    protected void waitForMFContainerToBeOnline(IMonitoredContainerRuntimeAPI mcr, IESBContainerInfo containerInfo) throws IllegalStateException {
        try {
            long start = System.currentTimeMillis();
            boolean timeout = false;
            while (3 != mcr.getMFContainerState(containerInfo.getMFContainerCanonicalName()).getState()) {
                if (start + 30000L < System.currentTimeMillis()) {
                    timeout = true;
                    break;
                }
                Thread.sleep(2000L);
            }
            if (timeout) {
                throw new IllegalStateException("MF Container is not online...");
            }
        }
        catch (InterruptedException e) {
            this.m_outputStream.println(e);
        }
    }

    private void printMessage(String mask, String cType, String cName, String action) {
        this.m_outputStream.println(MessageFormat.format(mask, cType, cName, action));
    }

    protected IMonitoredContainerRuntimeAPI getMonitoredContainerRuntimeAPI() {
        return this.m_esbAPI.getMonitoredContainersRuntimeAPI();
    }

    protected IContainerRuntimeAPI getContainerRuntimeAPI(IESBContainerInfo containerInfo) {
        return this.m_esbAPI.getContainerRuntimeAPI(containerInfo.getMFContainerName(), containerInfo.getESBContainerName());
    }

    protected ESBAPIFactory getESBAPIFactory() {
        return ESBAPIFactory.createESBAPIFactory();
    }

    public DSConnectionDetails getConnectionDetails() {
        return this.m_connectionDetails;
    }
}

