/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.action;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactFilter;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.action.CopyAction;
import com.sonicsw.deploy.storage.AbstractArtifactStorage;
import com.sonicsw.deploy.storage.DSArtifactStorage;
import com.sonicsw.deploy.storage.FileArtifactStorage;
import com.sonicsw.deploy.tools.common.ExportPropertiesArtifact;
import com.sonicsw.deploy.tools.common.ImportPropertiesFile;

public class ImportCopyAction
extends CopyAction {
    public ImportCopyAction(IArtifact[] artifact, IArtifactFilter filter) {
        super(artifact, filter);
    }

    @Override
    public String getDescription() {
        return "ImportCopy";
    }

    @Override
    public void run(IArtifactStorage source, IArtifactStorage destination) throws Exception {
        if (source instanceof FileArtifactStorage && destination instanceof DSArtifactStorage) {
            this.addDomainReplacements((FileArtifactStorage)source, (DSArtifactStorage)destination);
        } else {
            AbstractArtifactStorage aSource = (AbstractArtifactStorage)source;
            AbstractArtifactStorage aDest = (AbstractArtifactStorage)destination;
            aSource._notifyMessage(3, "ImportCopyAction used in an unanticipated way. Source storage " + aSource.getStoreName() + " should be DS storage, destination storage " + aDest.getStoreName() + " should be file or zip storage");
        }
        super.run(source, destination);
    }

    private void addDomainReplacements(FileArtifactStorage source, DSArtifactStorage destination) {
        String exportDomain = null;
        String importDomain = null;
        try {
            importDomain = destination.getDomain();
            ExportPropertiesArtifact exportProps = new ExportPropertiesArtifact();
            exportProps.init(source.getContentsAsBytes(exportProps));
            exportDomain = exportProps.getDomain();
            if (!exportDomain.equals(importDomain)) {
                ((ImportPropertiesFile)this.m_filter).addReplacement("sonicfs://" + exportDomain, "sonicfs://" + importDomain);
                ((ImportPropertiesFile)this.m_filter).addReplacement("sonic://" + exportDomain, "sonic://" + importDomain);
            }
        }
        catch (Exception e) {
            source._notifyMessage(3, "Unable to replace export domain '" + (exportDomain != null ? exportDomain : "unknown") + "' with import domain '" + (importDomain != null ? importDomain : "unknown") + "' : " + e.getMessage());
        }
    }

    public static void copyTo(IArtifactStorage source, IArtifactStorage dest, IArtifact[] artifacts, IArtifactFilter filter) throws Exception {
        source.performActionTo(dest, new ImportCopyAction(artifacts, filter));
    }
}

