/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.traversal;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactTraversalContext;
import com.sonicsw.deploy.traversal.AbstractTraverser;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BPELProcessTraverser
extends AbstractTraverser {
    protected XPathFactory xpf;
    protected XPathExpression importsExpr;
    protected XPathExpression xsltExpr;
    protected Pattern xslTransform = Pattern.compile("doXslTransform\\(([^,]*),.*");

    public BPELProcessTraverser(IArtifact artifact) throws Exception {
        super(artifact);
        this.init();
    }

    final void init() throws XPathException {
        this.xpf = XPathFactory.newInstance();
        XPath xp = this.xpf.newXPath();
        xp.setNamespaceContext(new BPELNamespaces());
        this.importsExpr = xp.compile("/bpws:process/bpws:import[starts-with(@location,'sonic')]");
        this.xsltExpr = xp.compile("//bpws:query[contains(text(),'doXslTransform')]");
    }

    @Override
    protected void doTraversal(IArtifactTraversalContext context) throws Exception {
        Document doc = context.getStorage().getContentsAsDom(this.m_artifact);
        Element element = doc.getDocumentElement();
        this.processImports(context, element);
        this.processTransforms(context, element);
    }

    void processImports(IArtifactTraversalContext context, Element docElt) throws Exception {
        block4: {
            Object ret;
            block3: {
                ret = this.importsExpr.evaluate(docElt, XPathConstants.NODESET);
                if (ret == null) {
                    return;
                }
                if (!(ret instanceof NodeList)) break block3;
                NodeList imports = (NodeList)ret;
                for (int i = 0; i < imports.getLength(); ++i) {
                    Element importElt = (Element)imports.item(i);
                    this.traverseURLRefs(importElt.getAttribute("location"), context);
                }
                break block4;
            }
            if (!(ret instanceof List)) break block4;
            List imports = (List)ret;
            for (int i = 0; i < imports.size(); ++i) {
                Element importElt = (Element)imports.get(i);
                this.traverseURLRefs(importElt.getAttribute("location"), context);
            }
        }
    }

    void processTransforms(IArtifactTraversalContext context, Element docElt) throws Exception {
        block4: {
            Object ret;
            block3: {
                ret = this.xsltExpr.evaluate(docElt, XPathConstants.NODESET);
                if (ret == null) {
                    return;
                }
                if (!(ret instanceof NodeList)) break block3;
                NodeList xsltRefs = (NodeList)ret;
                for (int i = 0; i < xsltRefs.getLength(); ++i) {
                    Element xsltElt = (Element)xsltRefs.item(i);
                    Matcher m = this.xslTransform.matcher(xsltElt.getNodeValue());
                    if (!m.matches()) continue;
                    this.traverseURLRefs(m.group(1), context);
                }
                break block4;
            }
            if (!(ret instanceof List)) break block4;
            List xsltRefs = (List)ret;
            for (int i = 0; i < xsltRefs.size(); ++i) {
                Element xsltElt = (Element)xsltRefs.get(i);
                Matcher m = this.xslTransform.matcher(xsltElt.getNodeValue());
                if (!m.matches()) continue;
                this.traverseURLRefs(m.group(1), context);
            }
        }
    }

    public static boolean isValidExtension(String extension) {
        return "bpel".equals(extension.toLowerCase());
    }

    static class BPELNamespaces
    implements NamespaceContext {
        protected static Map bpelNamespaces = new HashMap();

        BPELNamespaces() {
        }

        @Override
        public String getNamespaceURI(String prefix) {
            String ret = (String)bpelNamespaces.get(prefix);
            return ret;
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return null;
        }

        public Iterator getPrefixes(String namespaceURI) {
            return null;
        }

        static {
            bpelNamespaces.put("bpws", "http://docs.oasis-open.org/wsbpel/2.0/process/executable");
        }
    }
}

