/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.traversal;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactTraversalContext;
import com.sonicsw.deploy.artifact.ESBArtifact;
import com.sonicsw.deploy.traversal.AbstractExtnTraverser;
import com.sonicsw.deploy.traversal.ESBEndpointTraverser;
import com.sonicsw.deploy.traversal.ESBProcessTraverser;
import com.sonicsw.deploy.traversal.ESBServiceTraverser;
import com.sonicsw.xqimpl.util.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ExtnXPRJRoutingRuleTraverser
extends AbstractExtnTraverser {
    public ExtnXPRJRoutingRuleTraverser(IArtifact artifact) {
        super(artifact);
    }

    @Override
    public void doTraversal(IArtifactTraversalContext context) throws Exception {
        if (!context.getStorage().exists(this.m_artifact)) {
            return;
        }
        Document doc = context.getStorage().getContentsAsDom(this.m_artifact);
        Element element = doc.getDocumentElement();
        if (element != null && (element = DOMUtils.getElementByTagName((Element)element, (String)"routing-rules")) != null && (element = DOMUtils.getElementByTagName((Element)element, (String)"collaboration-rules")) != null) {
            NodeList nodes = element.getElementsByTagName("rule");
            for (int i = 0; i < nodes.getLength(); ++i) {
                int index;
                String address;
                Element rhs = DOMUtils.getImmediateChildElementByName((Element)((Element)nodes.item(i)), (String)"rhs");
                if (rhs == null || (address = DOMUtils.getFirstTextChildOfChildElementByName((Element)rhs, (String)"forward-to-esb-address")) == null || (index = address.lastIndexOf(58)) == -1) continue;
                String type = address.substring(index + 1).toLowerCase();
                String name = address.substring(0, index);
                if ("service".equals(type)) {
                    new ESBServiceTraverser(new ESBArtifact(ESBArtifact.SERVICE, name)).traverse(context);
                    continue;
                }
                if ("process".equals(type)) {
                    new ESBProcessTraverser(new ESBArtifact(ESBArtifact.PROCESS, name)).traverse(context);
                    continue;
                }
                if ("endpoint".equals(type)) {
                    new ESBEndpointTraverser(new ESBArtifact(ESBArtifact.ENDPOINT, name)).traverse(context);
                    continue;
                }
                throw new Exception("Failed to create ESB traverser for " + address);
            }
        }
    }
}

