/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.mgmtapi.impl;

import com.sonicsw.esb.mgmtapi.ESBAPIException;
import com.sonicsw.esb.mgmtapi.impl.ConfigBase;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.mf.comm.IRetryCallback;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.jmx.client.DirectoryServiceProxy;
import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;
import com.sonicsw.mf.jmx.client.JMSConnectorAddress;
import com.sonicsw.mf.jmx.client.JMSConnectorClient;
import com.sonicsw.mx.config.ConfigServerFactory;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.util.SonicFSFileSystem;
import com.sonicsw.xqimpl.config.IConfigSPI;
import com.sonicsw.xqimpl.config.XQConfigManager;
import com.sonicsw.xqimpl.mgmtapi.config.XQMgmtBeanFactory;
import java.util.Hashtable;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.NamingException;

public class DSConfigSPIImpl
extends ConfigBase
implements IConfigSPI,
IRetryCallback {
    protected JMSConnectorClient m_connector = null;

    @Override
    public void connect() {
        Throwable failure = null;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("ConnectionURLs", this.url);
        env.put("DefaultUser", this.user);
        env.put("DefaultPassword", this.password);
        try {
            JMSConnectorAddress address = new JMSConnectorAddress(env);
            this.m_connector = new JMSConnectorClient();
            this.m_connector.connect(address, this.requestTimeout);
            ObjectName dsName = new ObjectName(this.domainName + "." + "DIRECTORY SERVICE:ID=DIRECTORY SERVICE");
            this.m_adminService = new DirectoryServiceProxy((IRemoteMBeanServer)this.m_connector, dsName);
            this.m_fsService = (IDirectoryFileSystemService)this.m_adminService;
            this.m_esbBeanFactory = new XQMgmtBeanFactory();
            this.m_esbBeanFactory.connect(this.m_fsService);
            this.m_configManager = new XQConfigManager(this.m_adminService, this.user);
            this.m_sfs = new SonicFSFileSystem(this.m_fsService, this.user);
            this.m_configServer = ConfigServerFactory.connectConfigServer((IDirectoryFileSystemService)this.m_fsService, (boolean)true, (boolean)true);
            this.m_configManager.setUtilityObject((Object)this);
            this.m_connector.registerRetryCallback((IRetryCallback)this);
            this.m_connector.setRequestTimeout(this.requestTimeout);
            this.m_connector.setConnectionListener(this.m_connectionListener);
            this.m_connector.setSocketConnectTimeout(this.socketConnectionTimeout);
            this.m_connector.setConnectTimeout(this.connectTimeout);
        }
        catch (MalformedObjectNameException e) {
            failure = e;
        }
        catch (NullPointerException e) {
            failure = e;
        }
        catch (MgmtException e) {
            failure = e;
        }
        catch (ConfigServiceException e) {
            failure = e;
        }
        if (failure != null) {
            try {
                this.cleanup();
            }
            catch (ESBAPIException eSBAPIException) {
                // empty catch block
            }
            throw new ESBAPIException((Exception)failure);
        }
    }

    @Override
    public void disconnect() {
        Throwable failure = null;
        try {
            if (this.m_esbBeanFactory == null) {
                return;
            }
            this.m_esbBeanFactory.disconnect();
            this.m_configManager.close();
            this.m_configServer.close();
            this.m_connector.disconnect();
        }
        catch (ConfigServiceException e) {
            failure = e;
        }
        catch (NamingException e) {
            failure = e;
        }
        finally {
            this.m_esbBeanFactory = null;
            this.m_configManager = null;
            this.m_sfs = null;
            this.m_domainName = null;
            this.m_connector = null;
            this.m_configServer = null;
        }
        if (failure != null) {
            throw new ESBAPIException((Exception)failure);
        }
    }

    void cleanup() {
        try {
            if (this.m_esbBeanFactory != null) {
                this.m_esbBeanFactory.disconnect();
                this.m_esbBeanFactory = null;
            }
            if (this.m_configManager != null) {
                this.m_configManager.close();
                this.m_configManager = null;
            }
            if (this.m_sfs != null) {
                this.m_sfs = null;
            }
            if (this.m_configServer != null) {
                this.m_configServer.close();
                this.m_configServer = null;
            }
            if (this.m_connector != null && this.m_connector.isConnected()) {
                this.m_connector.disconnect();
                this.m_connector = null;
            }
        }
        catch (Exception e) {
            throw new ESBAPIException(e);
        }
    }

    public String storageToLogical(String storageName) throws ESBAPIException {
        try {
            return this.m_configServer.storageToLogical(storageName);
        }
        catch (ConfigServiceException configE) {
            throw new ESBAPIException((Exception)((Object)configE));
        }
    }

    public String logicalToStorage(String logical) throws ESBAPIException {
        try {
            return this.m_configServer.logicalToStorage(logical);
        }
        catch (ConfigServiceException ex) {
            throw new ESBAPIException((Exception)((Object)ex));
        }
    }

    public short onRequestFailure(String failedTarget, String failedConnectionURL, Exception e, short[] allowedResponseValues) {
        return 0;
    }

    public Object getRuntimeAttribute(ObjectName objectName, String attributeName) throws ESBAPIException {
        try {
            return this.m_connector.getAttribute(objectName, attributeName);
        }
        catch (AttributeNotFoundException notFound) {
            throw new ESBAPIException((Exception)notFound);
        }
        catch (MBeanException e) {
            throw new ESBAPIException((Exception)e);
        }
        catch (ReflectionException e) {
            throw new ESBAPIException((Exception)e);
        }
        catch (InstanceNotFoundException e) {
            throw new ESBAPIException((Exception)e);
        }
    }

    public Object invoke(ObjectName objectName, String operationName, Object[] params, String[] signature) throws ESBAPIException {
        try {
            return this.m_connector.invoke(objectName, operationName, params, signature);
        }
        catch (ReflectionException e) {
            throw new ESBAPIException((Exception)e);
        }
        catch (InstanceNotFoundException e) {
            throw new ESBAPIException((Exception)e);
        }
        catch (MBeanException e) {
            throw new ESBAPIException((Exception)e);
        }
    }

    public boolean hasRuntimeConnection() {
        return this.m_connector != null && this.m_connector.isConnected();
    }
}

