/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.mgmtapi.impl;

import com.sonicsw.esb.mgmtapi.ESBAPI;
import com.sonicsw.esb.mgmtapi.ESBAPIException;
import com.sonicsw.esb.mgmtapi.impl.ConfigBase;
import com.sonicsw.esb.mgmtapi.impl.DSConfigSPIImpl;
import com.sonicsw.esb.mgmtapi.impl.ESBAPIImpl;
import com.sonicsw.esb.mgmtapi.impl.OfflineDSSPIImpl;
import com.sonicsw.mf.jmx.client.IConnectionListener;

public class ESBAPIFactoryImpl {
    private long requestTimeout = 0L;
    private long socketConnectionTimeout = 0L;
    private long connectTimeout = 0L;
    private IConnectionListener m_connectionListener = null;
    static boolean setHandlers = false;

    public void setRequestTimeout(long timeout) {
        this.requestTimeout = timeout;
    }

    public void setSocketConnectionTimeout(long socketConnectionTimeout) {
        this.socketConnectionTimeout = socketConnectionTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setConnectionListener(IConnectionListener listener) {
        this.m_connectionListener = listener;
    }

    public ESBAPI createConfigAPI(String domain, String url, String user, String password) {
        if (!setHandlers) {
            this.setHandlers();
            setHandlers = true;
        }
        ESBAPIImpl api = new ESBAPIImpl();
        ConfigBase configBack = null;
        configBack = url.endsWith(".xml") ? new OfflineDSSPIImpl() : new DSConfigSPIImpl();
        configBack.setDomainName(domain);
        configBack.setUrl(url);
        configBack.setUser(user);
        configBack.setPassword(password);
        configBack.setRequestTimeout(this.requestTimeout);
        configBack.setSocketConnectionTimeout(this.socketConnectionTimeout);
        configBack.setConnectTimeout(this.connectTimeout);
        configBack.setConnectionListener(this.m_connectionListener);
        try {
            configBack.connect();
        }
        catch (Exception e) {
            throw new ESBAPIException(e);
        }
        api.setConfigBack(configBack);
        return api;
    }

    private void setHandlers() {
        String pkgs = System.getProperty("java.protocol.handler.pkgs");
        if (pkgs == null || pkgs.indexOf("com.sonicsw.xqimpl.util") == -1) {
            if (pkgs != null && pkgs.length() > 0) {
                System.setProperty("java.protocol.handler.pkgs", pkgs + "||com.sonicsw.xqimpl.util");
            } else {
                System.setProperty("java.protocol.handler.pkgs", "com.sonicsw.xqimpl.util");
            }
        }
    }
}

