/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.traversal;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactTraversalContext;
import com.sonicsw.deploy.IArtifactTraverser;
import com.sonicsw.deploy.artifact.ESBArtifact;
import com.sonicsw.deploy.artifact.SonicFSArtifact;
import com.sonicsw.deploy.traversal.AbstractExtnTraverser;
import com.sonicsw.deploy.traversal.ESBTraverserFactory;
import com.sonicsw.deploy.traversal.ExtnTraverserFactory;
import com.sonicsw.deploy.traversal.SonicFSTraverserFactory;
import com.sonicsw.deploy.util.ELExpressionUtils;
import com.sonicsw.deploy.util.PropertyUtils;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class ExtnPropertiesTraverser
extends AbstractExtnTraverser {
    private static final String TRAVERSAL_PROPERTIES_ENABLED = "traversal.properties.enabled";
    private static final String TRAVERSAL_PROPERTIES_EXTENSIONS = "traversal.properties.extensions";
    private static final String DEFAULT_EXTENSIONS = "properties,props";
    private static boolean s_enabled;
    private static List s_extensions;

    public ExtnPropertiesTraverser(IArtifact artifact) {
        super(artifact);
    }

    public static boolean isValidExtension(String extension) {
        if (!s_enabled || extension == null) {
            return false;
        }
        return s_extensions.contains(extension.toLowerCase());
    }

    @Override
    public void doTraversal(IArtifactTraversalContext context) throws Exception {
        byte[] propsAsBytes = context.getStorage().getContentsAsBytes(this.m_artifact);
        ByteArrayInputStream instream = new ByteArrayInputStream(propsAsBytes);
        Properties props = new Properties();
        props.load(instream);
        Collection<Object> propValues = props.values();
        Iterator<Object> propsIter = propValues.iterator();
        ArrayList<IArtifact> artifacts = new ArrayList<IArtifact>();
        while (propsIter.hasNext()) {
            String propValue = (String)propsIter.next();
            IArtifact artifact = null;
            int start = -1;
            String fsName = ELExpressionUtils.getFSNameFromELExpression(propValue);
            if (fsName == null) {
                start = propValue.indexOf("sonicfs://");
                fsName = this.retrieveSubString(start, fsName, propValue);
            }
            if (fsName != null) {
                artifact = this.createArtifactForSonicfsURL(fsName, context);
                if (artifact == null || artifacts.contains(artifact)) continue;
                artifacts.add(artifact);
                continue;
            }
            String esbName = null;
            start = propValue.indexOf("sonicesb://");
            esbName = this.retrieveSubString(start, esbName, propValue);
            if (esbName != null) {
                artifact = this.createArtifactForSonicESBURL(esbName, context);
            } else {
                String processName = ELExpressionUtils.getProcessNameFromELExpression(propValue);
                if (processName != null) {
                    artifact = new ESBArtifact(ESBArtifact.PROCESS, processName);
                }
            }
            if (artifact != null) {
                if (artifacts.contains(artifact)) continue;
                artifacts.add(artifact);
                continue;
            }
            start = propValue.indexOf("sonic://");
            if (start == -1 || (artifact = this.createArtifactForSonicURL(propValue.substring(start), context)) == null || artifacts.contains(artifact)) continue;
            artifacts.add(artifact);
        }
        for (IArtifact artifact : artifacts) {
            if (artifact instanceof SonicFSArtifact) {
                IArtifactTraverser traverser = ExtnTraverserFactory.createTraverser(artifact, context);
                if (traverser == null) {
                    traverser = SonicFSTraverserFactory.createTraverser(artifact);
                }
                traverser.traverse(context);
                continue;
            }
            if (!(artifact instanceof ESBArtifact)) continue;
            ESBTraverserFactory.createTraverser(artifact).traverse(context);
        }
    }

    private String retrieveSubString(int start, String fsNameParam, String propValue) {
        String fsName = fsNameParam;
        if (start != -1) {
            fsName = propValue.substring(start);
        }
        return fsName;
    }

    static {
        PropertyUtils prop = PropertyUtils.getInstance();
        s_enabled = prop.getBooleanProperty(TRAVERSAL_PROPERTIES_ENABLED, true);
        if (s_enabled) {
            s_extensions = prop.tokenizeToLower(prop.getProperty(TRAVERSAL_PROPERTIES_EXTENSIONS, DEFAULT_EXTENSIONS));
        }
    }
}

