/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.tools.migration;

import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDirIdentity;
import com.sonicsw.mf.common.dirconfig.InvalidXMLException;
import com.sonicsw.mf.jmx.client.DirectoryServiceProxy;
import com.sonicsw.xqimpl.tools.migration.Migration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MigrationSuite {
    private List m_migrations = new ArrayList();
    private String m_name;

    public MigrationSuite(Document document, String suiteName, String resourcePath, String xqDirectoryPath) {
        File xqDirectory = new File(xqDirectoryPath);
        if (!xqDirectory.exists()) {
            throw new IllegalArgumentException("Directory " + xqDirectoryPath + " does not exist.  Please check arguments and try again.");
        }
        File migrationDirectory = new File(xqDirectory, "migration");
        if (!migrationDirectory.exists()) {
            migrationDirectory.mkdir();
        }
        long startTime = System.currentTimeMillis();
        Element migrationSuite = document.getDocumentElement();
        this.m_name = migrationSuite.getAttribute("name");
        NodeList migrations = migrationSuite.getElementsByTagName("migration");
        for (int i = 0; i < migrations.getLength(); ++i) {
            this.m_migrations.add(new Migration((Element)migrations.item(i), suiteName, resourcePath, startTime, xqDirectory.getAbsolutePath(), migrationDirectory));
        }
    }

    public void migrate(DirectoryServiceProxy proxy) throws IOException, FileNotFoundException, DirectoryServiceException, InvalidXMLException, TransformerConfigurationException, TransformerException {
        StringBuilder buffer = new StringBuilder("/");
        buffer.append("xqMigrations");
        String migrationsDir = buffer.toString();
        buffer.append("/").append(this.m_name);
        this.createDirectoryIfNecessary(proxy, "/", migrationsDir);
        this.createDirectoryIfNecessary(proxy, migrationsDir, buffer.toString());
        Iterator migrations = this.migrations();
        while (migrations.hasNext()) {
            Migration migration = (Migration)migrations.next();
            String name = migration.getName();
            System.out.println("Starting Migration:" + name);
            migration.migrate(proxy);
            System.out.println("Completed Migration:" + name);
        }
        System.out.println("Completed Migration Suite:" + this.m_name);
    }

    public String getName() {
        return this.m_name;
    }

    public Iterator migrations() {
        return this.m_migrations.iterator();
    }

    private void createDirectoryIfNecessary(DirectoryServiceProxy proxy, String parent, String name) throws DirectoryServiceException {
        if (!this.directoryExists(proxy, parent, name)) {
            proxy.createDirectory(name);
        }
    }

    private boolean directoryExists(DirectoryServiceProxy proxy, String parent, String name) throws DirectoryServiceException {
        IDirIdentity[] directories = proxy.listDirectories(parent);
        for (int i = 0; i < directories.length; ++i) {
            if (!directories[i].getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

