<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:mf="http://www.sonicsw.com/mf" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<xsl:output indent="yes" media-type="text/xml" method="xml"/>
	<xsl:param name="schemaLocation"/>
	<xsl:param name="currentTime"/>
	<xsl:param name="migrationName"/>
	<xsl:param name="suiteName"/>
	<xsl:template match="mf:Domain">
		<xsl:copy>
			<xsl:copy-of select="@name"/>
			<xsl:attribute name="xsi:schemaLocation"><xsl:value-of select="$schemaLocation"/></xsl:attribute>
			<xsl:element name="Directory"  namespace="http://www.sonicsw.com/mf">
			<xsl:attribute name="name"><xsl:text>/</xsl:text></xsl:attribute>
			<xsl:element name="Directory"  namespace="http://www.sonicsw.com/mf">
				<xsl:attribute name="name"><xsl:text>/xqMigrations</xsl:text></xsl:attribute>
				<xsl:element name="Directory" namespace="http://www.sonicsw.com/mf">
					<xsl:attribute name="name">/xqMigrations/<xsl:value-of select="$suiteName"/></xsl:attribute>
					<xsl:element name="ConfigElement" namespace="http://www.sonicsw.com/mf">
						<xsl:element name="ElementID" namespace="http://www.sonicsw.com/mf">
							<xsl:attribute name="version"><xsl:text>1</xsl:text></xsl:attribute>
							<xsl:attribute name="releaseVersion"><xsl:text>1.0</xsl:text></xsl:attribute>
							<xsl:attribute name="name">/xqMigrations/<xsl:value-of select="$suiteName"/>/<xsl:value-of select="$migrationName"/></xsl:attribute>
							<xsl:attribute name="creationTimestamp"><xsl:value-of select="$currentTime"/></xsl:attribute>
							<xsl:attribute name="type"><xsl:text>migration</xsl:text></xsl:attribute>
						</xsl:element>
						<xsl:element name="AttributeSet" namespace="http://www.sonicsw.com/mf">
							<xsl:element name="Attribute" namespace="http://www.sonicsw.com/mf">
								<xsl:attribute name="name"><xsl:text>completion</xsl:text></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$currentTime"/></xsl:attribute>
								<xsl:attribute name="type"><xsl:text>long</xsl:text></xsl:attribute>
							</xsl:element>
						</xsl:element>
					</xsl:element>
				</xsl:element>
			</xsl:element>
			<xsl:apply-templates/>
			</xsl:element>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="mf:*">
		<xsl:if test="not(local-name(..)='AttributeSet') or (string(@name)='url' or string(@name)='description' or string(@name)='name' or string(@name)='type')">
			<xsl:copy>
				<xsl:copy-of select="@*"/>
				<xsl:apply-templates/>
			</xsl:copy>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
