/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.mgmtapi.runtime.impl;

import com.sonicsw.esb.mgmtapi.ESBAPIException;
import com.sonicsw.esb.mgmtapi.runtime.ESBArtifactInfo;
import com.sonicsw.esb.mgmtapi.runtime.IContainerRuntimeAPI;
import com.sonicsw.xqimpl.config.IConfigSPI;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class EsbContainerRuntimeAPI
implements IContainerRuntimeAPI {
    private IConfigSPI m_domainConnection;
    private ObjectName m_daemonRuntimeID;

    public EsbContainerRuntimeAPI(IConfigSPI configSPI, String mfContainerName, String esbContainerName) {
        this.m_domainConnection = configSPI;
        try {
            String context = this.m_domainConnection.getDomainName() + "." + mfContainerName + ":ID=" + esbContainerName;
            this.m_daemonRuntimeID = new ObjectName(context);
        }
        catch (MalformedObjectNameException e) {
            throw new ESBAPIException((Exception)e);
        }
    }

    public ESBArtifactInfo[] abortProcesses(String[] processNames) {
        try {
            String method = "abortProcesses";
            Object[] params = new Object[]{processNames};
            String[] signature = new String[]{String[].class.getName()};
            return (ESBArtifactInfo[])this.invokeMethod(method, params, signature);
        }
        catch (Exception e) {
            throw new ESBAPIException(e);
        }
    }

    public ESBArtifactInfo[] abortServices(String[] serviceNames) {
        try {
            String method = "abortServices";
            Object[] params = new Object[]{serviceNames};
            String[] signature = new String[]{String[].class.getName()};
            return (ESBArtifactInfo[])this.invokeMethod(method, params, signature);
        }
        catch (Exception e) {
            throw new ESBAPIException(e);
        }
    }

    public ESBArtifactInfo[] getArtifacts() {
        try {
            String method = "getArtifacts";
            Object[] params = new Object[]{};
            String[] signature = new String[]{};
            return (ESBArtifactInfo[])this.invokeMethod(method, params, signature);
        }
        catch (Exception e) {
            throw new ESBAPIException(e);
        }
    }

    public ESBArtifactInfo getServiceInfo(String serviceName) {
        try {
            String method = "getServiceInfo";
            Object[] params = new Object[]{serviceName};
            String[] signature = new String[]{String.class.getName()};
            return (ESBArtifactInfo)this.invokeMethod(method, params, signature);
        }
        catch (Exception e) {
            throw new ESBAPIException(e);
        }
    }

    public ESBArtifactInfo getProcessInfo(String processName) {
        try {
            String method = "getProcessInfo";
            Object[] params = new Object[]{processName};
            String[] signature = new String[]{String.class.getName()};
            return (ESBArtifactInfo)this.invokeMethod(method, params, signature);
        }
        catch (Exception e) {
            throw new ESBAPIException(e);
        }
    }

    public ESBArtifactInfo[] reloadProcesses(String[] processNames) {
        try {
            String method = "reloadProcesses";
            Object[] params = new Object[]{processNames};
            String[] signature = new String[]{String[].class.getName()};
            return (ESBArtifactInfo[])this.invokeMethod(method, params, signature);
        }
        catch (Exception e) {
            throw new ESBAPIException(e);
        }
    }

    public ESBArtifactInfo[] reloadServices(String[] serviceNames) {
        try {
            String method = "reloadServices";
            Object[] params = new Object[]{serviceNames};
            String[] signature = new String[]{String[].class.getName()};
            return (ESBArtifactInfo[])this.invokeMethod(method, params, signature);
        }
        catch (Exception e) {
            throw new ESBAPIException(e);
        }
    }

    public ESBArtifactInfo[] startProcesses(String[] processNames) {
        try {
            String method = "startProcesses";
            Object[] params = new Object[]{processNames};
            String[] signature = new String[]{String[].class.getName()};
            return (ESBArtifactInfo[])this.invokeMethod(method, params, signature);
        }
        catch (Exception e) {
            throw new ESBAPIException(e);
        }
    }

    public ESBArtifactInfo[] startServices(String[] serviceNames) {
        try {
            String method = "startServices";
            Object[] params = new Object[]{serviceNames};
            String[] signature = new String[]{String[].class.getName()};
            return (ESBArtifactInfo[])this.invokeMethod(method, params, signature);
        }
        catch (Exception e) {
            throw new ESBAPIException(e);
        }
    }

    public ESBArtifactInfo[] stopProcesses(String[] processNames) {
        try {
            String method = "stopProcesses";
            Object[] params = new Object[]{processNames};
            String[] signature = new String[]{String[].class.getName()};
            return (ESBArtifactInfo[])this.invokeMethod(method, params, signature);
        }
        catch (Exception e) {
            throw new ESBAPIException(e);
        }
    }

    public ESBArtifactInfo[] stopServices(String[] serviceNames) {
        try {
            String method = "stopServices";
            Object[] params = new Object[]{serviceNames};
            String[] signature = new String[]{String[].class.getName()};
            return (ESBArtifactInfo[])this.invokeMethod(method, params, signature);
        }
        catch (Exception e) {
            throw new ESBAPIException(e);
        }
    }

    public boolean abortContainer() {
        try {
            String method = "abortContainer";
            Object[] params = new Object[]{};
            String[] signature = new String[]{};
            Boolean invokeResult = (Boolean)this.invokeMethod(method, params, signature);
            return invokeResult;
        }
        catch (Exception e) {
            throw new ESBAPIException(e);
        }
    }

    private Object invokeMethod(String method, Object[] params, String[] signature) {
        return this.m_domainConnection.invoke(this.m_daemonRuntimeID, method, params, signature);
    }
}

