/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.tools.migration;

import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.InvalidXMLException;
import com.sonicsw.mf.jmx.client.DirectoryServiceProxy;
import com.sonicsw.xqimpl.tools.migration.DirectoryMigration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Migration {
    private List m_directories = new ArrayList();
    private String m_resourcePath;
    private String m_suiteName;
    private String m_startTime;
    private String m_name;
    private static final MessageFormat s_completionFormat = new MessageFormat("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\t<Domain xmlns=\"http://www.sonicsw.com/mf\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.sonicsw.com/mf MFConfigurationElements.xsd\" name=\"Sonic\">\n\t\t<Directory name=\"/xqMigrations\">\n\t\t\t<Directory name=\"/xqMigrations/{0}\">\n\t\t\t\t<ConfigElement>\n\t\t\t\t\t<ElementID version=\"1\" releaseVersion=\"1.0\" name=\"/xqMigrations/{0}/{1}\" creationTimestamp=\"{2}\" type=\"migration\"/>\n\t\t\t\t\t<AttributeSet>\n\t\t\t\t\t\t<Attribute name=\"completion\" type=\"long\" value=\"{2}\"/>\n\t\t\t\t\t</AttributeSet>\n\t\t\t\t</ConfigElement>\n\t\t\t</Directory>\n\t\t</Directory>\n\t</Domain>");

    public Migration(Element migration, String suiteName, String resourcePath, long startTime, String xqHomePath, File migrationDirectory) {
        this.m_suiteName = suiteName;
        this.m_startTime = "" + startTime;
        this.m_name = migration.getAttribute("name");
        StringBuilder resourceBuffer = new StringBuilder(resourcePath);
        resourceBuffer.append(this.m_name).append("/");
        this.m_resourcePath = resourceBuffer.toString();
        File newMigrationDirectory = new File(migrationDirectory, this.m_name + startTime);
        NodeList directories = migration.getElementsByTagName("directoryMigration");
        for (int i = 0; i < directories.getLength(); ++i) {
            this.m_directories.add(new DirectoryMigration((Element)directories.item(i), this, xqHomePath, newMigrationDirectory));
        }
    }

    public InputStream getResourceAsStream(String name) {
        StringBuilder buffer = new StringBuilder(this.m_resourcePath);
        buffer.append(name);
        InputStream is = ClassLoader.getSystemResourceAsStream(buffer.toString());
        if (is == null) {
            throw new IllegalArgumentException("Cannot find resource " + buffer.toString());
        }
        return is;
    }

    public void migrate(DirectoryServiceProxy proxy) throws IOException, FileNotFoundException, DirectoryServiceException, InvalidXMLException, TransformerConfigurationException, TransformerException {
        if (this.migrationHasRun(proxy)) {
            System.out.println("Migration " + this.m_name + " has already been run.  Skipping...");
            return;
        }
        Iterator directories = this.directoryMigrations();
        while (directories.hasNext()) {
            ((DirectoryMigration)directories.next()).migrate(proxy);
        }
    }

    private boolean migrationHasRun(DirectoryServiceProxy proxy) throws DirectoryServiceException {
        StringBuilder elementName = new StringBuilder("/");
        elementName.append("xqMigrations");
        elementName.append("/");
        elementName.append(this.m_suiteName);
        String directory = elementName.toString();
        elementName.append("/");
        elementName.append(this.m_name);
        return this.elementExists(proxy, directory, elementName.toString());
    }

    private boolean elementExists(DirectoryServiceProxy proxy, String directory, String element) throws DirectoryServiceException {
        IElementIdentity[] elements = proxy.listElements(directory);
        for (int i = 0; i < elements.length; ++i) {
            if (!elements[i].getName().equals(element)) continue;
            return true;
        }
        return false;
    }

    private void recordCompletion(DirectoryServiceProxy proxy) throws InvalidXMLException, DirectoryServiceException {
        Object[] elementData = new Object[]{this.m_suiteName, this.m_name, this.m_startTime};
        proxy.importFromXML(s_completionFormat.format(elementData));
    }

    public Iterator directoryMigrations() {
        return this.m_directories.iterator();
    }

    public String getSuiteName() {
        return this.m_suiteName;
    }

    public String getStartTime() {
        return this.m_startTime;
    }

    public String getName() {
        return this.m_name;
    }
}

