/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.util;

import com.sonicsw.esb.expression.def.EsbpExpressionDef;
import com.sonicsw.esb.expression.def.ExpressionDef;
import com.sonicsw.esb.expression.def.ExpressionDefProcessor;
import com.sonicsw.esb.expression.def.ExpressionDefProcessorFactory;
import com.sonicsw.esb.expression.def.PropsExpressionDef;
import com.sonicsw.esb.expression.def.URLReaderExpressionDef;
import com.sonicsw.esb.expression.def.el.ELExpressionDefProcessFactory;
import com.sonicsw.esb.expression.def.el.ExpressionDefProcessorBase;

public class ELExpressionUtils {
    private static final ExpressionDefProcessorFactory s_expressionDefFactory = new ELExpressionDefProcessFactory(false);

    public static boolean isValidExpression(String expressionStr) {
        return s_expressionDefFactory.isValidExpression(expressionStr);
    }

    public static String getFSNameFromELExpression(String expressionStr) {
        ExpressionDefProcessor expressionDefProcessor;
        String fsName = null;
        if (s_expressionDefFactory.isValidExpression(expressionStr) && (expressionDefProcessor = s_expressionDefFactory.getExpressionDefProcessor(expressionStr)) != null) {
            ExpressionDef expression = expressionDefProcessor.getExpressionDef(expressionStr, false);
            if (expression instanceof PropsExpressionDef) {
                fsName = ExpressionDefProcessorBase.getString((Object)((PropsExpressionDef)expression).getPropertyFileName());
            } else if (expression instanceof URLReaderExpressionDef) {
                fsName = ExpressionDefProcessorBase.getString((Object)((URLReaderExpressionDef)expression).getURL());
            }
        }
        return fsName;
    }

    public static String getProcessNameFromELExpression(String expressionStr) {
        ExpressionDef expression;
        ExpressionDefProcessor expressionDefProcessor;
        String processName = null;
        if (s_expressionDefFactory.isValidExpression(expressionStr) && (expressionDefProcessor = s_expressionDefFactory.getExpressionDefProcessor(expressionStr)) != null && (expression = expressionDefProcessor.getExpressionDef(expressionStr, false)) instanceof EsbpExpressionDef) {
            processName = ExpressionDefProcessorBase.getString((Object)((EsbpExpressionDef)expression).getAttributeName());
        }
        return processName;
    }
}

