/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.traversal;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.IArtifactTraversalContext;
import com.sonicsw.deploy.artifact.ArtifactFactory;
import com.sonicsw.deploy.storage.AbstractArtifactStorage;
import java.util.ArrayList;
import java.util.List;

public class TraverserContext
implements IArtifactTraversalContext {
    private List m_ignored = new ArrayList();
    private List m_traversed = new ArrayList();
    private List m_errored = new ArrayList();
    private List m_skipped = new ArrayList();
    private IArtifactStorage m_store;
    private boolean m_traverseCompressed;

    public TraverserContext(IArtifactStorage store, IArtifact[] ignore) {
        this.m_store = store;
        if (ignore != null) {
            for (int i = 0; i < ignore.length; ++i) {
                this.m_ignored.add(ignore[i]);
            }
        }
    }

    @Override
    public boolean isIgnored(IArtifact artifact) {
        IArtifact testArtifact = artifact;
        while (true) {
            if (this.m_ignored.contains(testArtifact)) {
                return true;
            }
            if (testArtifact.isRootPath()) break;
            testArtifact = ArtifactFactory.createArtifact(testArtifact.getDisplayType(), testArtifact.getParentPath());
        }
        return false;
    }

    @Override
    public IArtifactStorage getStorage() {
        return this.m_store;
    }

    @Override
    public boolean addTraversed(IArtifact artifact) {
        return this.addTraversed(artifact, true);
    }

    @Override
    public boolean addTraversed(IArtifact artifact, boolean checkIgnored) {
        boolean ret = false;
        if (this.isTraversed(artifact)) {
            ((AbstractArtifactStorage)this.m_store)._notifyMessage(3, "Skipping '" + artifact + "' - artifact has already been handled");
        } else if (this.isIgnored(artifact) && checkIgnored) {
            ((AbstractArtifactStorage)this.m_store)._notifyMessage(3, "Skipping '" + artifact + "' - it is on the ignore list");
        } else {
            this.m_traversed.add(artifact);
            ret = true;
        }
        return ret;
    }

    @Override
    public boolean isTraversed(IArtifact artifact) {
        return this.m_traversed.contains(artifact);
    }

    @Override
    public IArtifact[] getTraversed() {
        return this.m_traversed.toArray(new IArtifact[0]);
    }

    @Override
    public IArtifact[] getIgnored() {
        return this.m_ignored.toArray(new IArtifact[0]);
    }

    @Override
    public void addErrored(IArtifact artifact) {
        if (!this.m_errored.contains(artifact)) {
            this.m_errored.add(artifact);
        }
    }

    public IArtifact[] getErrored() {
        return this.m_errored.toArray(new IArtifact[0]);
    }

    @Override
    public void addSkipped(IArtifact artifact) {
        if (!this.m_skipped.contains(artifact)) {
            this.m_skipped.add(artifact);
        }
    }

    public IArtifact[] getSkipped() {
        return this.m_skipped.toArray(new IArtifact[0]);
    }

    public IArtifact[] completeTraversal() {
        IArtifact artifact;
        int i;
        ArrayList<IArtifact> result = new ArrayList<IArtifact>();
        for (i = 0; i < this.m_traversed.size(); ++i) {
            artifact = (IArtifact)this.m_traversed.get(i);
            if (artifact.isDirectory() || artifact.isRootPath()) continue;
            result.add(artifact);
        }
        for (i = 0; i < this.m_errored.size(); ++i) {
            artifact = (IArtifact)this.m_errored.get(i);
            ((AbstractArtifactStorage)this.m_store)._notifyErrorMessage("Removing '" + artifact + "' from the traversal results, there was an error during traversal.", null);
            result.remove(artifact);
        }
        for (i = 0; i < this.m_skipped.size(); ++i) {
            result.remove(this.m_skipped.get(i));
        }
        return result.toArray(new IArtifact[0]);
    }

    @Override
    public boolean traverseCompressed() {
        return this.m_traverseCompressed;
    }

    public void setTraverseCompressed(boolean traverse) {
        this.m_traverseCompressed = traverse;
    }
}

