/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.util;

import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.storage.DSArtifactStorage;
import com.sonicsw.deploy.storage.FileArtifactStorage;
import com.sonicsw.deploy.storage.ZipArtifactStorage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;

public class CommandLineParser {
    private String m_lastError = "No error";
    private boolean m_verbose = false;
    private Hashtable m_includedArtifacts = new Hashtable();
    private String m_outputFile;
    private String m_mapFile;
    private String m_rulesFile;
    private String m_logFile;
    private ArrayList m_stores = new ArrayList();
    private String m_traversalMode;

    public boolean parse(String[] args) throws Exception {
        return this.parse(args, 2);
    }

    public boolean parse(String[] args, int numSourceStores) throws Exception {
        int numArgsConsumed;
        for (int i = 0; i < args.length && args[i] != null; i += numArgsConsumed) {
            numArgsConsumed = 0;
            if ("-v".equalsIgnoreCase(args[i])) {
                this.m_verbose = true;
                numArgsConsumed = 1;
            } else if ("-out".equalsIgnoreCase(args[i])) {
                this.m_outputFile = args[i + 1];
                numArgsConsumed = 2;
            } else if ("-map".equalsIgnoreCase(args[i])) {
                this.m_mapFile = args[i + 1];
                numArgsConsumed = 2;
            } else if ("-log".equalsIgnoreCase(args[i])) {
                this.m_logFile = args[i + 1];
                numArgsConsumed = 2;
            } else if ("-rules".equalsIgnoreCase(args[i])) {
                this.m_rulesFile = args[i + 1];
                numArgsConsumed = 2;
            } else if ("-include".equalsIgnoreCase(args[i])) {
                numArgsConsumed = this.parseInclude(args, i);
            } else if ("-includeFile".equalsIgnoreCase(args[i])) {
                numArgsConsumed = this.parseIncludeFile(args[i + 1]);
            } else if ("-fs".equalsIgnoreCase(args[i]) || "-ds".equalsIgnoreCase(args[i]) || "-xar".equalsIgnoreCase(args[i])) {
                numArgsConsumed = this.createStore(args, i, numSourceStores);
            } else if ("-traversal".equalsIgnoreCase(args[i])) {
                this.m_traversalMode = args[i + 1];
                numArgsConsumed = 2;
            } else {
                this.m_lastError = "Invalid arguement at command line arguement: " + i;
                return false;
            }
            if (numArgsConsumed != -1) continue;
            return false;
        }
        return true;
    }

    public IArtifactStorage[] getStores() {
        return this.m_stores.toArray(new IArtifactStorage[0]);
    }

    public String getLastError() {
        return this.m_lastError;
    }

    public void closeStores() throws Exception {
        IArtifactStorage[] stores = this.m_stores.toArray(new IArtifactStorage[0]);
        for (int i = 0; i < stores.length; ++i) {
            this.closeStore(stores[i]);
        }
    }

    private void closeStore(IArtifactStorage store) throws Exception {
        if (store instanceof ZipArtifactStorage) {
            ZipArtifactStorage zipStore = (ZipArtifactStorage)store;
            zipStore.closeArchive();
        }
    }

    public String getOutputFile() {
        return this.m_outputFile;
    }

    public String getMapFile() {
        return this.m_mapFile;
    }

    public String getRulesFile() {
        return this.m_rulesFile;
    }

    public String getLogFile() {
        return this.m_logFile;
    }

    public Hashtable getArtifactFilter() {
        return this.m_includedArtifacts;
    }

    public boolean getVerbose() {
        return this.m_verbose;
    }

    public String getTraversalMode() {
        return this.m_traversalMode;
    }

    private int createStore(String[] args, int pos, int numSourceStores) throws Exception {
        boolean create = false;
        if (this.m_stores.size() >= numSourceStores) {
            create = true;
        }
        if ("-ds".equalsIgnoreCase(args[pos])) {
            return this.createDSStore(args, pos + 1);
        }
        if ("-fs".equalsIgnoreCase(args[pos])) {
            return this.createFSStore(args, pos + 1, create);
        }
        if ("-xar".equalsIgnoreCase(args[pos])) {
            return this.createXARStore(args, pos + 1, create);
        }
        return -1;
    }

    private int createDSStore(String[] args, int startArg) throws Exception {
        DSArtifactStorage ds = null;
        String domain = null;
        String url = null;
        String username = null;
        String password = null;
        int i = startArg;
        int endArg = startArg + 3;
        for (i = startArg; i <= endArg && args[i] != null && args[i].charAt(0) != '-'; ++i) {
            if (domain == null) {
                domain = args[i];
                continue;
            }
            if (url == null) {
                url = args[i];
                continue;
            }
            if (username == null) {
                username = args[i];
                continue;
            }
            if (password != null) continue;
            password = args[i];
        }
        if (domain == null || url == null) {
            this.m_lastError = "domain or url not provided for DS store";
            return -1;
        }
        ds = new DSArtifactStorage();
        ds.connect(domain, url, username, password);
        this.m_stores.add(ds);
        return i - startArg + 1;
    }

    private int createFSStore(String[] args, int startArg, boolean create) throws Exception {
        FileArtifactStorage fs = null;
        String path = null;
        if (args[startArg].charAt(0) == '-') {
            this.m_lastError = "Path not provided for file system store";
            return -1;
        }
        path = args[startArg];
        File file = new File(path);
        if (create) {
            file.mkdir();
        }
        if (!file.exists()) {
            this.m_lastError = "Path " + path + " does not exist for file system store";
            return -1;
        }
        fs = new FileArtifactStorage();
        fs.setRoot(path);
        this.m_stores.add(fs);
        return 2;
    }

    private int createXARStore(String[] args, int startArg, boolean create) throws Exception {
        ZipArtifactStorage zip = null;
        if (args[startArg].charAt(0) == '-') {
            this.m_lastError = "Archive file not provided for XAR store";
            return -1;
        }
        String xarPath = args[startArg];
        zip = new ZipArtifactStorage();
        zip.openArchive(xarPath, create);
        this.m_stores.add(zip);
        return 2;
    }

    private int parseInclude(String[] args, int startArg) {
        int i;
        for (i = startArg + 1; i < args.length && args[i] != null && args[i].charAt(0) != '-'; ++i) {
            args[i] = args[i].toLowerCase();
            this.m_includedArtifacts.put(args[i], args[i]);
        }
        return i - startArg;
    }

    private int parseIncludeFile(String includeFilename) {
        File includeFile = new File(includeFilename);
        try {
            BufferedReader reader = new BufferedReader(new FileReader(includeFile));
            String artifactName = null;
            do {
                if ((artifactName = reader.readLine()) == null) continue;
                artifactName = artifactName.toLowerCase();
                this.m_includedArtifacts.put(artifactName, artifactName);
            } while (artifactName != null);
        }
        catch (FileNotFoundException e) {
            this.m_lastError = "Unable to open include file: " + includeFilename;
            return -1;
        }
        catch (IOException e) {
            this.m_lastError = "Error while reading include file: " + includeFilename;
            return -1;
        }
        return 2;
    }

    public void writeStore(IArtifactStorage store) throws Exception {
        if (store instanceof ZipArtifactStorage) {
            ZipArtifactStorage zip = (ZipArtifactStorage)store;
            zip.saveArchive();
        }
    }

    public String getStoreName(IArtifactStorage store) {
        String storeName = "";
        if (store instanceof DSArtifactStorage) {
            DSArtifactStorage ds = (DSArtifactStorage)store;
            storeName = ds.getDomain() + "//" + ds.getURL();
        } else if (store instanceof ZipArtifactStorage) {
            ZipArtifactStorage zip = (ZipArtifactStorage)store;
            storeName = zip.getArchive().getPath();
        } else if (store instanceof FileArtifactStorage) {
            FileArtifactStorage fs = (FileArtifactStorage)store;
            storeName = fs.getRoot().getPath();
        }
        return storeName;
    }
}

