/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.action;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactFilter;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.action.AbstractAction;
import com.sonicsw.deploy.artifact.ConfigBeanArtifact;
import com.sonicsw.deploy.artifact.ESBArtifact;
import com.sonicsw.deploy.artifact.SonicFSArtifact;
import com.sonicsw.deploy.artifact.SystemArtifact;
import com.sonicsw.deploy.artifact.ZipFileArtifact;
import com.sonicsw.deploy.filter.PassThruArtifactFilter;
import com.sonicsw.deploy.storage.AbstractArtifactStorage;
import com.sonicsw.xqimpl.util.ClassUtils;
import java.util.HashSet;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;

public class CopyAction
extends AbstractAction {
    private static final IArtifactFilter S_PASS_THRU_FILTER = new PassThruArtifactFilter();
    private IArtifact[] m_artifact;
    protected IArtifactFilter m_filter;

    public CopyAction(IArtifact[] artifact) {
        this(artifact, S_PASS_THRU_FILTER);
    }

    public CopyAction(IArtifact[] artifact, IArtifactFilter filter) {
        this.m_artifact = (IArtifact[])ClassUtils.arrayCopy((Object[])artifact);
        this.m_filter = filter;
    }

    @Override
    public String getDescription() {
        return "Copy";
    }

    @Override
    public void run(IArtifactStorage source, IArtifactStorage destination) throws Exception {
        AbstractArtifactStorage aSource = (AbstractArtifactStorage)source;
        AbstractArtifactStorage aDest = (AbstractArtifactStorage)destination;
        HashSet<IArtifact> zipFiles = new HashSet<IArtifact>();
        for (int i = 0; i < this.m_artifact.length; ++i) {
            IArtifact iArtifact = this.m_artifact[i];
            if (iArtifact instanceof ZipFileArtifact) {
                zipFiles.add(iArtifact);
                aSource._notifyMessage(2, "Copy '" + iArtifact + "' to " + aDest.getStoreName() + " postponed");
                continue;
            }
            if (this.validateFile(aSource, iArtifact)) {
                this.storeArtifact(aSource, aDest, iArtifact);
                continue;
            }
            aSource._notifyMessage(2, "Skipping Copy '" + iArtifact + "' to " + aDest.getStoreName());
        }
        for (ZipFileArtifact zipFileArtifact : zipFiles) {
            aSource._notifyMessage(2, "Copy '" + zipFileArtifact + "' to " + aDest.getStoreName());
            this.m_filter.store(zipFileArtifact, source.getContentsAsBytes(zipFileArtifact), source, destination);
        }
    }

    private boolean validateFile(AbstractArtifactStorage aSource, IArtifact current) {
        boolean result;
        block6: {
            result = false;
            String path = current.getPath();
            String VALIDATE_XML_XSL = "sonicsw.import.validate.xml.xsl";
            String FORCE_IMPORT = "sonicsw.forceimport.xml.xsl";
            String DONT_ASK_DIALOG = "sonicsw.doNotAskDialog";
            if (Boolean.getBoolean("sonicsw.import.validate.xml.xsl") && path != null && (path.endsWith(".xsl") || path.endsWith(".xml"))) {
                try {
                    aSource.getContentsAsDom(current);
                    result = true;
                }
                catch (Exception e) {
                    aSource._notifyMessage(2, "Validation failed for file '" + current);
                    if (!Boolean.getBoolean("sonicsw.doNotAskDialog")) {
                        JCheckBox dontAskBox = new JCheckBox("Don't ask this again");
                        String msg = "Validation failed for file " + current;
                        Object[] msgContent = new Object[]{msg, dontAskBox};
                        int doImport = JOptionPane.showConfirmDialog(null, msgContent, "Do you still want to import ?", 0);
                        if (doImport == 0) {
                            result = true;
                        }
                        boolean remember = dontAskBox.isSelected();
                        System.setProperty("sonicsw.doNotAskDialog", String.valueOf(remember));
                        System.setProperty("sonicsw.forceimport.xml.xsl", String.valueOf(result));
                        break block6;
                    }
                    result = Boolean.getBoolean("sonicsw.forceimport.xml.xsl");
                }
            } else {
                result = true;
            }
        }
        return result;
    }

    private void storeArtifact(AbstractArtifactStorage source, AbstractArtifactStorage dest, IArtifact current) throws Exception {
        Object data = null;
        try {
            if (current instanceof ESBArtifact || current instanceof ConfigBeanArtifact) {
                data = source.getContentsAsString(current);
            } else if (current instanceof SonicFSArtifact) {
                data = source.getContentsAsBytes(current);
            } else if (current instanceof SystemArtifact) {
                data = ((SystemArtifact)current).getContent();
            }
        }
        catch (Throwable e) {
            source._notifyMessage(3, "Ignoring following error while reading '" + current + "'. Error '" + e.getMessage() + "'");
        }
        if (data == null) {
            source._notifyMessage(3, "Skip copy of '" + current + "' artifact has no content");
            return;
        }
        source._notifyMessage(2, "Copy '" + current + "' to " + dest.getStoreName());
        this.m_filter.store(current, data, source, dest);
    }

    public static void copyTo(IArtifactStorage source, IArtifactStorage dest, IArtifact[] artifacts) throws Exception {
        source.performActionTo(dest, new CopyAction(artifacts));
    }

    public static void copyTo(IArtifactStorage source, IArtifactStorage dest, IArtifact[] artifacts, IArtifactFilter filter) throws Exception {
        source.performActionTo(dest, new CopyAction(artifacts, filter));
    }
}

