/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.action;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactDepends;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.action.AbstractAction;
import com.sonicsw.deploy.action.SearchAction;
import com.sonicsw.deploy.compare.MQDependency;
import com.sonicsw.deploy.compare.MQDependencyBase;
import com.sonicsw.deploy.traversal.TraverserFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;

public class DependencyAction
extends AbstractAction
implements IArtifactDepends {
    protected String m_defaultFileName = "Sonic_Dependency.xml";
    protected String m_reportSource = "";
    protected Hashtable m_artifactList = null;
    protected MQDependencyBase m_mqDependency = new MQDependency();

    @Override
    public void setHeader(String reportSource) {
        this.m_reportSource = reportSource;
    }

    @Override
    public void setArtifactList(Hashtable artifactList) {
        this.m_artifactList = artifactList;
    }

    @Override
    public String getDescription() {
        return "DependencyReport";
    }

    @Override
    public void run(IArtifactStorage store) throws Exception {
        IArtifact[] artifacts = SearchAction.search(store, null, TraverserFactory.createListAllTraverser());
        String artifactPath = "";
        if (this.m_artifactList != null && this.m_artifactList.size() > 0) {
            artifacts = this.getArtifacts(artifactPath, artifacts);
        }
        this.m_mqDependency.setArtifactLists(store, artifacts);
        this.m_mqDependency.performDependencyAnalysis();
    }

    private IArtifact[] getArtifacts(String artifactPathParam, IArtifact[] artifactsParam) throws Exception {
        IArtifact[] artifacts = artifactsParam;
        String artifactPath = artifactPathParam;
        try {
            ArrayList<IArtifact> includedArtifacts = new ArrayList<IArtifact>();
            for (int i = 0; i < artifacts.length; ++i) {
                artifactPath = artifacts[i].getPath();
                String name = artifacts[i].getName().toLowerCase();
                Object obj = this.m_artifactList.get(name);
                if (obj == null) continue;
                includedArtifacts.add(artifacts[i]);
            }
            artifacts = includedArtifacts.toArray(new IArtifact[0]);
        }
        catch (Exception e) {
            String msg = "Error while processing artifact " + artifactPath + ": " + e.getMessage();
            throw new Exception(msg);
        }
        return artifacts;
    }

    @Override
    public void generateReport(File file) throws IOException {
        this.m_mqDependency.generateReport(file, this.m_reportSource);
    }

    public static void createDependencyReport(IArtifactStorage source) throws Exception {
        source.performAction(new DependencyAction());
    }

    @Override
    public String getDefaultOutputFilename() {
        return this.m_defaultFileName;
    }
}

