/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.mgmtapi.config.impl;

import com.sonicsw.esb.mgmtapi.ESBAPIException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URL;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public class ConfigUtils {
    public static void writeXmlString(String directory, String name, String elementContent, boolean overwrite) {
        File dir = new File(directory);
        if (!dir.exists()) {
            throw new ESBAPIException((Exception)new IllegalStateException("Output location '" + directory + "' does not exist"));
        }
        if (!dir.isDirectory()) {
            throw new ESBAPIException((Exception)new IllegalStateException("Output location '" + directory + "' exists but is not a valid directory"));
        }
        File file = new File(dir, name + ".xml");
        if (!overwrite && file.exists()) {
            throw new ESBAPIException((Exception)new IllegalStateException("File '" + file + "' already exists and overwrite == false"));
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write(elementContent);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new ESBAPIException((Exception)e);
        }
    }

    public static String readFile(String fileName) {
        File f = new File(fileName);
        return ConfigUtils.readFile(f, Charset.forName("UTF-8"));
    }

    public static String readFile(File file) {
        return ConfigUtils.readFile(file, Charset.forName("UTF-8"));
    }

    public static String readFile(URL u) {
        InputStream in;
        try {
            in = u.openStream();
        }
        catch (IOException e) {
            throw new ESBAPIException((Exception)e);
        }
        return ConfigUtils.readFile(in, Charset.forName("UTF-8"));
    }

    public static String readFile(File f, Charset charset) {
        FileInputStream in;
        try {
            in = new FileInputStream(f);
        }
        catch (IOException e) {
            throw new ESBAPIException((Exception)e);
        }
        return ConfigUtils.readFile(in, charset);
    }

    public static String readFile(InputStream in, Charset charset) {
        try {
            boolean more;
            InputStreamReader reader = new InputStreamReader(in, charset);
            BufferedReader br = new BufferedReader(reader);
            StringBuilder result = new StringBuilder();
            char[] cbuff = new char[100];
            do {
                int read;
                boolean bl = more = (read = br.read(cbuff)) > 0;
                if (!more) continue;
                CharBuffer ch = CharBuffer.wrap(cbuff, 0, read);
                result.append(ch);
            } while (more);
            return result.toString();
        }
        catch (IOException e) {
            throw new ESBAPIException((Exception)e);
        }
    }
}

