/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.artifact;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.artifact.ConfigBeanArtifact;
import com.sonicsw.deploy.artifact.ESBArtifact;
import com.sonicsw.deploy.artifact.RootArtifact;
import com.sonicsw.deploy.artifact.SonicFSArtifact;
import com.sonicsw.deploy.artifact.SystemArtifact;
import com.sonicsw.deploy.artifact.ZipContentArtifact;
import com.sonicsw.deploy.artifact.ZipFileArtifact;

public class ArtifactFactory {
    public static final IArtifact createArtifact(IArtifact artifact, String newPath) {
        IArtifact updatedArtifact = null;
        if (artifact instanceof ZipFileArtifact) {
            updatedArtifact = new ZipFileArtifact(newPath, (ZipFileArtifact)artifact);
        } else {
            if (artifact instanceof ZipContentArtifact) {
                throw new UnsupportedOperationException("can not move artifacts within archives");
            }
            updatedArtifact = ArtifactFactory.createArtifact(artifact.getDisplayType(), newPath);
            if (artifact instanceof SonicFSArtifact) {
                ((SonicFSArtifact)updatedArtifact).setEncoding(((SonicFSArtifact)artifact).getEncoding());
            }
        }
        return updatedArtifact;
    }

    public static final IArtifact createArtifact(String type, String path) {
        if (type.equals("ESB")) {
            return new ESBArtifact(path);
        }
        if (type.equals("SonicFS")) {
            if (ZipFileArtifact.isArchiveFile(path)) {
                return new ZipFileArtifact(path);
            }
            return new SonicFSArtifact(path);
        }
        if (type.equals("System")) {
            return new SystemArtifact(path);
        }
        if (type.equals("Root")) {
            return RootArtifact.ROOT;
        }
        if (type.equals("ConfigBean")) {
            return new ConfigBeanArtifact(path);
        }
        if (type.equals("ZipFile")) {
            if (ZipFileArtifact.isArchiveFile(path)) {
                return new ZipFileArtifact(path);
            }
            return new SonicFSArtifact(path);
        }
        if (type.equals("ZipContent")) {
            return new ZipContentArtifact(path);
        }
        throw new UnsupportedOperationException("'" + type + "' is not a valid artifact type");
    }
}

