/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.action;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.action.AbstractAction;
import com.sonicsw.deploy.action.SearchAction;
import com.sonicsw.deploy.artifact.ESBArtifact;
import com.sonicsw.deploy.traversal.TraverserFactory;
import com.sonicsw.deploy.util.MapCreator;
import com.sonicsw.sonicxq.ConnectionDocument;
import com.sonicsw.sonicxq.EndpointDocument;
import com.sonicsw.sonicxq.ProcessDocument;
import com.sonicsw.sonicxq.ServiceDocument;
import com.sonicsw.sonicxq.XQCONTAINERDocument;
import java.io.File;

public class CreateMapAction
extends AbstractAction {
    private File m_mapFile;
    private File m_rulesFile;

    public CreateMapAction(File mapFile, File rulesFile) {
        this.m_mapFile = mapFile;
        this.m_rulesFile = rulesFile;
    }

    @Override
    public String getDescription() {
        return "CreateMap";
    }

    @Override
    public void run(IArtifactStorage source) throws Exception {
        IArtifact[] artifacts = SearchAction.search(source, null, TraverserFactory.createListAllTraverser());
        MapCreator mapCreator = new MapCreator(source);
        for (int i = 0; i < artifacts.length; ++i) {
            if (!(artifacts[i] instanceof ESBArtifact)) continue;
            String data = source.getContentsAsString(artifacts[i]);
            String path = artifacts[i].getParentPath();
            if (path.equals(ESBArtifact.CONTAINER.getPath())) {
                mapCreator.addArchiveContainer(XQCONTAINERDocument.Factory.parse(data));
                continue;
            }
            if (path.equals(ESBArtifact.SERVICE.getPath())) {
                mapCreator.addArchiveService(ServiceDocument.Factory.parse(data));
                continue;
            }
            if (path.equals(ESBArtifact.PROCESS.getPath())) {
                mapCreator.addArchiveProcess(ProcessDocument.Factory.parse(data));
                continue;
            }
            if (path.equals(ESBArtifact.ENDPOINT.getPath())) {
                mapCreator.addArchiveEndpoint(EndpointDocument.Factory.parse(data));
                continue;
            }
            if (!path.equals(ESBArtifact.CONNECTION.getPath())) continue;
            mapCreator.addArchiveConnection(ConnectionDocument.Factory.parse(data));
        }
        mapCreator.createMapFile(this.m_mapFile, this.m_rulesFile);
    }

    public static void createMap(IArtifactStorage source, File mapFile, File rulesFile) throws Exception {
        source.performAction(new CreateMapAction(mapFile, rulesFile));
    }
}

