/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.action;

import com.sonicsw.deploy.IArtifactDiff;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.action.DiffAction;
import com.sonicsw.deploy.compare.MQDependency;
import com.sonicsw.sonicxq.ArtifactImpactListType;
import com.sonicsw.sonicxq.ConnectionDependencyType;
import com.sonicsw.sonicxq.ConnectionInfoType;
import com.sonicsw.sonicxq.DependencyListType;
import com.sonicsw.sonicxq.DiffBinaryArtifactType;
import com.sonicsw.sonicxq.DiffType;
import com.sonicsw.sonicxq.DiffVerboseType;
import com.sonicsw.sonicxq.ESBArtifactImpactDocument;
import com.sonicsw.sonicxq.EndpointDependencyType;
import com.sonicsw.sonicxq.EndpointInfoType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.xmlbeans.XmlOptions;

public class ImpactAnalysisAction
extends DiffAction
implements IArtifactDiff {
    protected ESBArtifactImpactDocument m_impactDoc = null;
    protected MQDependency m_sourceDependency = new MQDependency();
    protected MQDependency m_targetDependency = new MQDependency();
    protected List m_newDestinations = new ArrayList();
    protected List m_newConnections = new ArrayList();
    protected List m_unusedDestinations = new ArrayList();
    protected List m_unusedConnections = new ArrayList();
    protected String m_reportOutput = null;

    public ImpactAnalysisAction() {
        this.m_defaultFileName = "Sonic_ImpactAnalysis.xml";
        this.m_impactDoc = ESBArtifactImpactDocument.Factory.newInstance();
    }

    public void setHeader(String reportSource, String reportTarget, String reportOutput) {
        this.m_reportSource = reportSource;
        this.m_reportTarget = reportTarget;
        this.m_reportOutput = reportOutput;
    }

    @Override
    public void run(IArtifactStorage sourceStore, IArtifactStorage targetStore) throws Exception {
        super.run(sourceStore, targetStore);
        this.performDependencyImpactAnalysis(sourceStore, targetStore);
    }

    protected void reformatBinaryDiffs(DiffVerboseType verboseReport) {
        DiffBinaryArtifactType[] binaryDiffs = this.m_verboseDiffs.getBinaryArtifactDiffArray();
        DiffBinaryArtifactType[] newBinarys = new DiffBinaryArtifactType[binaryDiffs.length];
        for (int i = 0; i < binaryDiffs.length; ++i) {
            DiffBinaryArtifactType newBinary = DiffBinaryArtifactType.Factory.newInstance();
            String newString = binaryDiffs[i].getPath() + " will be overwritten";
            newBinary.setPath(newString);
            newBinarys[i] = newBinary;
        }
        this.m_verboseDiffs.setBinaryArtifactDiffArray(newBinarys);
    }

    @Override
    public void generateReport(File impactFile) throws IOException {
        DiffType diffs = DiffType.Factory.newInstance();
        if (this.m_verbose) {
            this.reformatBinaryDiffs(this.m_verboseDiffs);
            diffs.setArtifactDiffsVerbose(this.m_verboseDiffs);
            diffs.setArtifactsInSource(this.m_inSourceOnly);
        } else {
            diffs.setArtifactDiffsTerse(this.m_terseDiffs);
            diffs.setArtifactsInSource(this.m_inSourceOnly);
        }
        ArtifactImpactListType artifactImpactList = ArtifactImpactListType.Factory.newInstance();
        artifactImpactList.setChanges(diffs);
        DependencyListType addedDependencies = this.generateDependencyList(this.m_sourceDependency, this.m_newDestinations, this.m_newConnections);
        artifactImpactList.setAddedDependencies(addedDependencies);
        DependencyListType unusedDependencies = this.generateDependencyList(this.m_sourceDependency, this.m_unusedDestinations, this.m_unusedConnections);
        artifactImpactList.setDeletedDependencies(unusedDependencies);
        artifactImpactList.setDate(new Date(System.currentTimeMillis()).toString());
        artifactImpactList.setSource(this.m_reportSource);
        artifactImpactList.setTarget(this.m_reportTarget);
        if (this.m_reportOutput != null) {
            artifactImpactList.setOutput(this.m_reportOutput);
        }
        this.m_impactDoc.setESBArtifactImpact(artifactImpactList);
        XmlOptions xmlOpts = new XmlOptions();
        xmlOpts.setSavePrettyPrint();
        xmlOpts.setSavePrettyPrintIndent(4);
        this.m_impactDoc.save(impactFile, xmlOpts);
    }

    private DependencyListType generateDependencyList(MQDependency mqDepends, List destinations, List connections) {
        DependencyListType dependencyList = DependencyListType.Factory.newInstance();
        EndpointDependencyType[] endpointDependencies = destinations.toArray(new EndpointDependencyType[0]);
        HashMap endpointDependencyList = mqDepends.getMqDestinationDependencyList();
        for (int i = 0; i < endpointDependencies.length; ++i) {
            ArrayList endpointList;
            String key = MQDependency.formEndpointKey(endpointDependencies[i]);
            if (key == null || (endpointList = (ArrayList)endpointDependencyList.get(key)) == null || endpointList.isEmpty()) continue;
            EndpointInfoType[] dependencies = endpointList.toArray(new EndpointInfoType[0]);
            endpointDependencies[i].setEndpointInfoArray(dependencies);
        }
        dependencyList.setEndpointDependencyArray(endpointDependencies);
        ConnectionDependencyType[] newConnectionDependencies = connections.toArray(new ConnectionDependencyType[0]);
        HashMap connectionDependencyList = mqDepends.getMqConnectionDependencyList();
        for (int i = 0; i < newConnectionDependencies.length; ++i) {
            ArrayList connectionList;
            String key = newConnectionDependencies[i].getDependencyURL();
            if (key == null || (connectionList = (ArrayList)connectionDependencyList.get(key)) == null || connectionList.isEmpty()) continue;
            ConnectionInfoType[] dependencies = connectionList.toArray(new ConnectionInfoType[0]);
            newConnectionDependencies[i].setConnectionInfoArray(dependencies);
        }
        dependencyList.setConnectionDependencyArray(newConnectionDependencies);
        return dependencyList;
    }

    protected void performDependencyImpactAnalysis(IArtifactStorage sourceStore, IArtifactStorage targetStore) throws Exception {
        this.m_sourceDependency.setArtifactLists(sourceStore, this.m_sourceArtifacts);
        this.m_sourceDependency.performDependencyAnalysis();
        this.m_targetDependency.setArtifactLists(targetStore, this.m_targetArtifacts);
        this.m_targetDependency.performDependencyAnalysis();
        this.findNewDestinations();
        this.findNewConnections();
        this.findUnusedDestinations();
        this.findUnusedConnections();
    }

    protected void findNewDestinations() {
        ArrayList sourceEndpointArray = this.m_sourceDependency.getMqDestinationList();
        ArrayList targetEndpointArray = this.m_targetDependency.getMqDestinationList();
        EndpointDependencyType[] sourceEndpointDependencies = sourceEndpointArray.toArray(new EndpointDependencyType[0]);
        EndpointDependencyType[] targetEndpointDependencies = targetEndpointArray.toArray(new EndpointDependencyType[0]);
        for (int i = 0; i < sourceEndpointDependencies.length; ++i) {
            boolean found = false;
            String sourceKey = MQDependency.formEndpointKey(sourceEndpointDependencies[i]);
            for (int j = 0; j < targetEndpointDependencies.length; ++j) {
                String targetKey = MQDependency.formEndpointKey(targetEndpointDependencies[j]);
                if (!sourceKey.equalsIgnoreCase(targetKey)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.m_newDestinations.add(sourceEndpointDependencies[i]);
        }
    }

    protected void findNewConnections() {
        ArrayList sourceConnectionArray = this.m_sourceDependency.getMqConnectionList();
        ArrayList targetConnectionArray = this.m_targetDependency.getMqConnectionList();
        ConnectionDependencyType[] sourceConnectionDependencies = sourceConnectionArray.toArray(new ConnectionDependencyType[0]);
        ConnectionDependencyType[] targetConnectionDependencies = targetConnectionArray.toArray(new ConnectionDependencyType[0]);
        for (int i = 0; i < sourceConnectionDependencies.length; ++i) {
            boolean found = false;
            String sourceUrl = sourceConnectionDependencies[i].getDependencyURL();
            if (sourceUrl == null) continue;
            for (int j = 0; j < targetConnectionDependencies.length; ++j) {
                String targetUrl = targetConnectionDependencies[j].getDependencyURL();
                if (!sourceUrl.equalsIgnoreCase(targetUrl)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.m_newConnections.add(sourceConnectionDependencies[i]);
        }
    }

    protected void findUnusedDestinations() {
        int i;
        ArrayList targetEndpointArray = this.m_targetDependency.getMqDestinationList();
        ArrayList sourceEndpointArray = this.m_sourceDependency.getMqDestinationList();
        EndpointDependencyType[] targetEndpointDependencies = targetEndpointArray.toArray(new EndpointDependencyType[0]);
        EndpointDependencyType[] sourceEndpointDependencies = sourceEndpointArray.toArray(new EndpointDependencyType[0]);
        boolean[] dependencyInUse = new boolean[targetEndpointDependencies.length];
        for (i = 0; i < targetEndpointDependencies.length; ++i) {
            String targetKey = MQDependency.formEndpointKey(targetEndpointDependencies[i]);
            if (targetKey != null) continue;
            dependencyInUse[i] = true;
        }
        block1: for (i = 0; i < sourceEndpointDependencies.length; ++i) {
            String sourceDest = MQDependency.formEndpointKey(sourceEndpointDependencies[i]);
            if (sourceDest == null) continue;
            for (int j = 0; j < targetEndpointDependencies.length; ++j) {
                String targetDest = MQDependency.formEndpointKey(targetEndpointDependencies[j]);
                if (!sourceDest.equalsIgnoreCase(targetDest)) continue;
                dependencyInUse[j] = true;
                continue block1;
            }
        }
        HashMap sourceDependencyMap = this.m_sourceDependency.getMqDestinationDependencyList();
        HashMap targetDependencyMap = this.m_targetDependency.getMqDestinationDependencyList();
        for (int i2 = 0; i2 < targetEndpointDependencies.length; ++i2) {
            if (dependencyInUse[i2]) continue;
            String targetKey = MQDependency.formEndpointKey(targetEndpointDependencies[i2]);
            ArrayList targetEsbUsersList = (ArrayList)targetDependencyMap.get(targetKey);
            for (int j = 0; j < sourceEndpointDependencies.length; ++j) {
                String sourceKey = MQDependency.formEndpointKey(sourceEndpointDependencies[j]);
                ArrayList sourceEsbUsersList = (ArrayList)sourceDependencyMap.get(sourceKey);
                for (int k = sourceEsbUsersList.size() - 1; k >= 0; --k) {
                    for (int l = targetEsbUsersList.size() - 1; l >= 0; --l) {
                        String targetEpName;
                        String sourceEpName = ((EndpointInfoType)sourceEsbUsersList.get(k)).getName();
                        if (!sourceEpName.equalsIgnoreCase(targetEpName = ((EndpointInfoType)targetEsbUsersList.get(l)).getName())) continue;
                        targetEsbUsersList.remove(l);
                        if (!targetEsbUsersList.isEmpty()) continue;
                        this.m_unusedDestinations.add(targetEndpointDependencies[i2]);
                    }
                }
            }
        }
    }

    protected void findUnusedConnections() {
        int i;
        ArrayList targetConnectionArray = this.m_targetDependency.getMqConnectionList();
        ArrayList sourceConnectionArray = this.m_sourceDependency.getMqConnectionList();
        ConnectionDependencyType[] targetConnectionDependencies = targetConnectionArray.toArray(new ConnectionDependencyType[0]);
        ConnectionDependencyType[] sourceConnectionDependencies = sourceConnectionArray.toArray(new ConnectionDependencyType[0]);
        boolean[] dependencyInUse = new boolean[targetConnectionDependencies.length];
        for (i = 0; i < targetConnectionDependencies.length; ++i) {
            String targetUrl = targetConnectionDependencies[i].getDependencyURL();
            if (targetUrl != null) continue;
            dependencyInUse[i] = true;
        }
        block1: for (i = 0; i < sourceConnectionDependencies.length; ++i) {
            String sourceUrl = sourceConnectionDependencies[i].getDependencyURL();
            if (sourceUrl == null) continue;
            for (int j = 0; j < targetConnectionDependencies.length; ++j) {
                String targetUrl = targetConnectionDependencies[j].getDependencyURL();
                if (!sourceUrl.equalsIgnoreCase(targetUrl)) continue;
                dependencyInUse[j] = true;
                continue block1;
            }
        }
        HashMap sourceDependencyMap = this.m_sourceDependency.getMqConnectionDependencyList();
        HashMap targetDependencyMap = this.m_targetDependency.getMqConnectionDependencyList();
        for (int i2 = 0; i2 < targetConnectionDependencies.length; ++i2) {
            if (dependencyInUse[i2]) continue;
            String targetKey = targetConnectionDependencies[i2].getDependencyURL();
            ArrayList targetEsbUsersList = (ArrayList)targetDependencyMap.get(targetKey);
            for (int j = 0; j < sourceConnectionDependencies.length; ++j) {
                String sourceKey = sourceConnectionDependencies[j].getDependencyURL();
                ArrayList sourceEsbUsersList = (ArrayList)sourceDependencyMap.get(sourceKey);
                int sourceLen = sourceEsbUsersList.size();
                for (int k = sourceLen - 1; k >= 0; --k) {
                    int targetLen = targetEsbUsersList.size();
                    for (int l = targetLen - 1; l >= 0; --l) {
                        String targetConnName;
                        String sourceConnName = ((ConnectionInfoType)sourceEsbUsersList.get(k)).getConnectionName();
                        if (!sourceConnName.equalsIgnoreCase(targetConnName = ((ConnectionInfoType)targetEsbUsersList.get(l)).getConnectionName())) continue;
                        targetEsbUsersList.remove(l);
                        if (!targetEsbUsersList.isEmpty()) continue;
                        this.m_unusedConnections.add(targetConnectionDependencies[i2]);
                    }
                }
            }
        }
    }
}

