/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.compare;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.artifact.ESBArtifact;
import com.sonicsw.deploy.compare.AbstractFileComparator;
import com.sonicsw.deploy.compare.BinaryDiff;
import com.sonicsw.deploy.compare.Diff;
import com.sonicsw.deploy.compare.TextDiff;
import com.sonicsw.deploy.compare.XmlDiff;
import com.sonicsw.sonicxq.DiffArtifactPathType;
import com.sonicsw.sonicxq.DiffBinaryArtifactType;
import com.sonicsw.sonicxq.DiffTerseType;
import com.sonicsw.sonicxq.DiffTextArtifactType;
import com.sonicsw.sonicxq.DiffVerboseType;
import com.sonicsw.sonicxq.DiffXmlArtifactType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ArtifactDiff {
    private IArtifactStorage m_sourceStore;
    private IArtifactStorage m_targetStore;
    private Map m_sourceArtifactList;
    private Map m_targetArtifactList;
    protected List m_differentArtifacts = new ArrayList();

    public ArtifactDiff(Map sourceHash, Map targetHash, IArtifactStorage srcStore, IArtifactStorage trgStore) {
        this.m_sourceArtifactList = sourceHash;
        this.m_targetArtifactList = targetHash;
        this.m_sourceStore = srcStore;
        this.m_targetStore = trgStore;
    }

    public DiffVerboseType diffArtifactListVerbose() throws Exception {
        ArrayList keyArray = new ArrayList(this.m_sourceArtifactList.keySet());
        String[] keys = keyArray.toArray(new String[0]);
        IArtifact source = null;
        IArtifact target = null;
        ArrayList diffXmlArtifacts = new ArrayList();
        ArrayList diffTextArtifacts = new ArrayList();
        ArrayList diffBinaryArtifacts = new ArrayList();
        for (int i = 0; i < keys.length; ++i) {
            try {
                ArrayList list;
                source = (IArtifact)this.m_sourceArtifactList.get(keys[i]);
                target = (IArtifact)this.m_targetArtifactList.get(keys[i]);
                if (source != null) {
                    this.validateArtifact(this.m_sourceStore, source);
                }
                if (source == null || target == null) continue;
                String extension = source.getExtension();
                Diff diff = null;
                if (AbstractFileComparator.isXMLExtension(extension) || !source.isDirectory() && source instanceof ESBArtifact) {
                    diff = new XmlDiff(this.m_sourceStore, this.m_targetStore);
                    list = diffXmlArtifacts;
                } else if (AbstractFileComparator.isTextExtension(extension)) {
                    diff = new TextDiff(this.m_sourceStore, this.m_targetStore);
                    list = diffTextArtifacts;
                } else {
                    diff = new BinaryDiff(this.m_sourceStore, this.m_targetStore);
                    list = diffBinaryArtifacts;
                }
                this.performVerboseDiff(diff, list, source, target);
                this.m_sourceArtifactList.remove(keys[i]);
                this.m_targetArtifactList.remove(keys[i]);
                continue;
            }
            catch (Exception e) {
                String msg = "Error while processing artifact " + source.getPath() + ": " + e.getMessage();
                throw new Exception(msg);
            }
        }
        DiffVerboseType diffList = DiffVerboseType.Factory.newInstance();
        diffList.setXmlArtifactDiffArray(diffXmlArtifacts.toArray(new DiffXmlArtifactType[0]));
        diffList.setTextArtifactDiffArray(diffTextArtifacts.toArray(new DiffTextArtifactType[0]));
        diffList.setBinaryArtifactDiffArray(diffBinaryArtifacts.toArray(new DiffBinaryArtifactType[0]));
        return diffList;
    }

    private void validateArtifact(IArtifactStorage store, IArtifact artifact) throws Exception {
        String extension = artifact.getExtension();
        if (AbstractFileComparator.isXMLExtension(extension)) {
            store.getContentsAsDom(artifact);
        }
    }

    private void performVerboseDiff(Diff diff, List list, IArtifact source, IArtifact target) throws Exception {
        Object diffRecord = diff.diffArtifact(source, target);
        if (diffRecord != null) {
            list.add(diffRecord);
            this.m_differentArtifacts.add(source);
        }
    }

    public DiffTerseType diffArtifactListTerse() throws Exception {
        ArrayList keyArray = new ArrayList(this.m_sourceArtifactList.keySet());
        String[] keys = keyArray.toArray(new String[0]);
        IArtifact source = null;
        IArtifact target = null;
        ArrayList<DiffArtifactPathType> diffArtifacts = new ArrayList<DiffArtifactPathType>();
        for (int i = 0; i < keys.length; ++i) {
            source = (IArtifact)this.m_sourceArtifactList.get(keys[i]);
            target = (IArtifact)this.m_targetArtifactList.get(keys[i]);
            if (source == null || target == null) continue;
            String extension = source.getExtension();
            Diff diff = null;
            diff = AbstractFileComparator.isXMLExtension(extension) || !source.isDirectory() && source instanceof ESBArtifact ? new XmlDiff(this.m_sourceStore, this.m_targetStore) : (AbstractFileComparator.isTextExtension(extension) ? new TextDiff(this.m_sourceStore, this.m_targetStore) : new BinaryDiff(this.m_sourceStore, this.m_targetStore));
            if (((Diff)diff).diffArtifact(source, target) != null) {
                DiffArtifactPathType shortFormat = DiffArtifactPathType.Factory.newInstance();
                shortFormat.setPath(source.getArchivePath());
                diffArtifacts.add(shortFormat);
            }
            this.m_sourceArtifactList.remove(keys[i]);
            this.m_targetArtifactList.remove(keys[i]);
        }
        DiffTerseType diffs = DiffTerseType.Factory.newInstance();
        diffs.setArtifactDiffArray(diffArtifacts.toArray(new DiffArtifactPathType[0]));
        return diffs;
    }

    public List getDifferentArtifacts() {
        return this.m_differentArtifacts;
    }
}

