/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.tools.common;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactFilter;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.artifact.ArtifactFactory;
import com.sonicsw.deploy.artifact.ZipContentArtifact;
import com.sonicsw.deploy.compare.AbstractFileComparator;
import com.sonicsw.deploy.storage.AbstractArtifactStorage;
import com.sonicsw.deploy.tools.common.OverwriteSetting;
import com.sonicsw.deploy.util.FileUtils;
import com.sonicsw.xqimpl.util.DOMUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ImportPropertiesFile
implements IArtifactFilter {
    public static final String DEFAULT_FILE_NAME = "ImportProperties.xml";
    private static final Pattern ARTIFACT_PATTERN = Pattern.compile("[aA]rtifact");
    private static final Pattern SINGLE_BACKSLASH_PATTERN = Pattern.compile("(?<=[\\w:])\\\\(?=\\w)");
    private File m_file;
    private String m_name;
    private IArtifactStorage m_sourceStorage;
    private IArtifactStorage m_destinationStorage;
    private boolean m_globalOverwrite = false;
    private List<IArtifact> m_ignore = new ArrayList<IArtifact>();
    private Map<IArtifact, OverwriteSetting> m_overwrites = new HashMap<IArtifact, OverwriteSetting>();
    private MoveMappings m_moveMappings = new MoveMappings();
    private ReplacementActions m_replacementActions = null;

    public ImportPropertiesFile() {
        this.setFilterName("Filter[Import Properties]");
    }

    public ImportPropertiesFile(File file) throws Exception {
        this.setFilterName("Filter[Import Properties]");
        this.init(file);
    }

    public File getFile() {
        return this.m_file;
    }

    private String getFilterName() {
        return this.m_name;
    }

    private void setFilterName(String name) {
        this.m_name = name;
    }

    private IArtifactStorage getSourceStorage() {
        return this.m_sourceStorage;
    }

    private void setSourceStorage(IArtifactStorage storage) {
        this.m_sourceStorage = storage;
    }

    private IArtifactStorage getDestinationStorage() {
        return this.m_destinationStorage;
    }

    private void setDestinationStorage(IArtifactStorage storage) {
        this.m_destinationStorage = storage;
    }

    public boolean getGlobalOverwrite() {
        return this.m_globalOverwrite;
    }

    public void setGlobalOverwrite(boolean globalOverwrite) {
        this.m_globalOverwrite = globalOverwrite;
    }

    public boolean getOverwrite(IArtifact artifact) {
        return this.getOverwrite(artifact, false);
    }

    public boolean getOverwrite(IArtifact artifact, boolean inherit) {
        OverwriteSetting overwriteSetting = this.getOverwriteSetting(artifact, inherit);
        if (overwriteSetting.equals(OverwriteSetting.ALWAYS)) {
            return true;
        }
        if (overwriteSetting.equals(OverwriteSetting.NEVER)) {
            return false;
        }
        return this.m_globalOverwrite;
    }

    public OverwriteSetting getOverwriteSetting(IArtifact artifact) {
        return this.getOverwriteSetting(artifact, false);
    }

    public OverwriteSetting getOverwriteSetting(IArtifact artifact, boolean inherit) {
        if (inherit) {
            IArtifact testArtifact = artifact;
            while (true) {
                if (this.m_overwrites.containsKey(testArtifact)) {
                    return this.m_overwrites.get(testArtifact);
                }
                if (!testArtifact.isRootPath()) {
                    testArtifact = ArtifactFactory.createArtifact(testArtifact.getDisplayType(), testArtifact.getParentPath());
                    continue;
                }
                break;
            }
        } else if (this.m_overwrites.containsKey(artifact)) {
            return this.m_overwrites.get(artifact);
        }
        return OverwriteSetting.GLOBAL;
    }

    public void setOverwriteSetting(IArtifact artifact, OverwriteSetting overwrite) {
        this.m_overwrites.put(artifact, overwrite);
    }

    public void clearOverwriteSetting(IArtifact artifact) {
        this.m_overwrites.remove(artifact);
    }

    public IArtifact[] getOverwriteList() {
        ArrayList<IArtifact> arrayList = new ArrayList<IArtifact>(this.m_overwrites.keySet());
        return arrayList.toArray(new IArtifact[0]);
    }

    public void clearOverwriteList() {
        this.m_overwrites.clear();
    }

    public IArtifact[] getIgnoreList() {
        return this.m_ignore.toArray(new IArtifact[0]);
    }

    public boolean getIgnore(IArtifact artifact) {
        return this.m_ignore.contains(artifact);
    }

    public boolean isIgnored(IArtifact artifact) {
        IArtifact testArtifact = artifact;
        while (true) {
            if (this.m_ignore.contains(testArtifact)) {
                return true;
            }
            if (testArtifact.isRootPath()) break;
            testArtifact = ArtifactFactory.createArtifact(testArtifact.getDisplayType(), testArtifact.getParentPath());
        }
        return false;
    }

    public void clearIgnoreList() {
        this.m_ignore.clear();
    }

    public void addIgnore(IArtifact artifact) {
        if (!this.m_ignore.contains(artifact)) {
            this.m_ignore.add(artifact);
        }
    }

    public void addIgnore(IArtifact[] artifacts) {
        for (int i = 0; i < artifacts.length; ++i) {
            this.addIgnore(artifacts[i]);
        }
    }

    public void removeIgnore(IArtifact artifact) {
        this.m_ignore.remove(artifact);
    }

    public void addReplacement(String searchText, String replacementText) throws Exception {
        ReplacementMapping rm = new ReplacementMapping(searchText, replacementText);
        if (this.m_replacementActions == null) {
            this.m_replacementActions = new ReplacementActions(rm);
        } else {
            this.m_replacementActions.addReplacementMappingAtTail(rm);
        }
    }

    public final void init(File file) throws Exception {
        this.init(FileUtils.readFile(file));
        this.m_file = file;
    }

    public void init(byte[] content) throws Exception {
        this.m_file = null;
        this.m_ignore.clear();
        this.m_overwrites.clear();
        this.m_moveMappings.clear();
        this.m_replacementActions = null;
        Document document = DOMUtils.getDocument((byte[])content);
        Element element = document.getDocumentElement();
        this.elementsToArtifactList(DOMUtils.getElementByTagName((Element)element, (String)"ignore"), this.m_ignore);
        this.initOverwrites(DOMUtils.getElementByTagName((Element)element, (String)"overwrites"));
        this.initReplacements(DOMUtils.getElementByTagName((Element)element, (String)"replacements"));
        this.initMoveMappings(DOMUtils.getElementByTagName((Element)element, (String)"moves"));
    }

    public void writeToFile() throws Exception {
        if (this.m_file == null) {
            throw new Exception("Failed to save file - file is not specified");
        }
        this.writeToFile(this.m_file);
    }

    public void writeToFile(File file) throws Exception {
        this.m_file = file;
        FileUtils.writeFile(file, this.toXML(), "UTF-8");
    }

    public String getContent() {
        return this.toXML();
    }

    private String toXML() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<?xml version=\"1.0\" ?>\r\n");
        buffer.append("<import>\r\n");
        if (!this.m_ignore.isEmpty()) {
            buffer.append("    <ignore>\r\n");
            for (int i = 0; i < this.m_ignore.size(); ++i) {
                IArtifact artifact = this.m_ignore.get(i);
                buffer.append("        <artifact type=\"");
                buffer.append(artifact.getDisplayType());
                buffer.append("\" path=\"");
                buffer.append(artifact.getPath());
                buffer.append("\"/>\r\n");
            }
            buffer.append("    </ignore>\r\n");
        }
        buffer.append("    <overwrites global=\"");
        buffer.append(Boolean.toString(this.m_globalOverwrite));
        if (this.m_overwrites.size() == 0) {
            buffer.append("\"/>\r\n");
        } else {
            buffer.append("\">\r\n");
            for (Map.Entry<IArtifact, OverwriteSetting> overwriteEntry : this.m_overwrites.entrySet()) {
                IArtifact artifact = overwriteEntry.getKey();
                OverwriteSetting overwriteSetting = overwriteEntry.getValue();
                if (overwriteSetting == OverwriteSetting.GLOBAL) continue;
                buffer.append("        <artifact type=\"");
                buffer.append(artifact.getDisplayType());
                buffer.append("\" path=\"");
                buffer.append(artifact.getPath());
                buffer.append("\" overwrite=\"");
                buffer.append(overwriteSetting == OverwriteSetting.ALWAYS ? "always" : "never");
                buffer.append("\"/>\r\n");
            }
            buffer.append("    </overwrites>\r\n");
        }
        buffer.append("</import>\r\n");
        return buffer.toString();
    }

    @Override
    public void store(IArtifact artifact, Object content, IArtifactStorage sourceStore, IArtifactStorage destinationStore) {
        try {
            this.setSourceStorage(sourceStore);
            this.setDestinationStorage(destinationStore);
            if (this.isIgnored(artifact)) {
                ((AbstractArtifactStorage)sourceStore)._notifyMessage(3, this.getFilterName() + ": ignore " + artifact);
                return;
            }
            boolean b_overwrite = this.getOverwrite(artifact, true);
            IArtifact destinationArtifact = this.m_moveMappings.move(artifact);
            if (!b_overwrite && destinationStore.exists(destinationArtifact)) {
                ((AbstractArtifactStorage)sourceStore)._notifyMessage(3, this.getFilterName() + ": skip " + artifact + "; it already exists in " + ((AbstractArtifactStorage)destinationStore).getStoreName() + " and overwrite is false");
                return;
            }
            Object updatedContent = content;
            if (this.m_replacementActions != null && !AbstractFileComparator.isBinExtension(artifact.getExtension())) {
                updatedContent = this.m_replacementActions.performReplacementActions(artifact, updatedContent);
            }
            ((AbstractArtifactStorage)sourceStore)._notifyMessage(2, this.getFilterName() + ": store  " + destinationArtifact + " in " + ((AbstractArtifactStorage)destinationStore).getStoreName());
            destinationStore.store(destinationArtifact, updatedContent);
        }
        catch (Exception e) {
            ((AbstractArtifactStorage)sourceStore)._notifyErrorMessage(this.getFilterName() + ": Exception during import of " + artifact + "; artifact will be skipped.\n" + e + e.getMessage(), e);
        }
    }

    private void initOverwrites(Element element) {
        if (element == null) {
            return;
        }
        String globalOverwrite = element.getAttribute("global");
        if (globalOverwrite != null) {
            this.m_globalOverwrite = Boolean.valueOf(globalOverwrite);
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            OverwriteSetting overwriteSetting;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !"artifact".equals(node.getLocalName())) continue;
            String type = ((Element)node).getAttribute("type");
            String path = ((Element)node).getAttribute("path");
            String overwrite = ((Element)node).getAttribute("overwrite");
            if (type == null || path == null) continue;
            if ("always".equals(overwrite)) {
                overwriteSetting = OverwriteSetting.ALWAYS;
            } else if ("never".equals(overwrite)) {
                overwriteSetting = OverwriteSetting.NEVER;
            } else {
                return;
            }
            this.setOverwriteSetting(ArtifactFactory.createArtifact(type, path), overwriteSetting);
        }
    }

    private void initReplacements(Element element) throws Exception {
        this.m_replacementActions = new ReplacementActions(element);
    }

    private void initMoveMappings(Element movesElement) {
        if (movesElement == null) {
            return;
        }
        NodeList nodeList = movesElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !"move".equals(node.getLocalName())) continue;
            this.initMoveMapping((Element)node);
        }
    }

    private void initMoveMapping(Element element) {
        this.addMoveMapping(element, false, null);
    }

    private void addMoveMapping(Element moveElement, boolean activatePending, String[] matchingGroups) {
        if (moveElement == null) {
            return;
        }
        String update = moveElement.getAttribute("update");
        Element fromElement = DOMUtils.getImmediateChildElementByName((Element)moveElement, (String)"fromArtifact");
        Element toElement = DOMUtils.getImmediateChildElementByName((Element)moveElement, (String)"toArtifact");
        if (fromElement != null && toElement != null) {
            Text warningText;
            IArtifact fromArtifact = this.elementToArtifact(fromElement);
            IArtifact toArtifact = this.elementToArtifact(toElement);
            String fromType = fromArtifact.getDisplayType();
            String toType = toArtifact.getDisplayType();
            if (activatePending && matchingGroups != null && matchingGroups.length > 0) {
                String fromPath = fromArtifact.getPath();
                String toPath = toArtifact.getPath();
                for (int i = 0; i < matchingGroups.length; ++i) {
                    String searchString = "\\$" + Integer.toString(i + 1);
                    String replaceString = matchingGroups[i];
                    Pattern pattern = Pattern.compile(searchString);
                    Matcher matcher = pattern.matcher(fromPath);
                    fromPath = matcher.replaceAll(replaceString);
                    matcher.reset(toPath);
                    toPath = matcher.replaceAll(replaceString);
                }
                fromArtifact = ArtifactFactory.createArtifact(fromType, fromPath);
                toArtifact = ArtifactFactory.createArtifact(toType, toPath);
            }
            if (Boolean.valueOf(update).booleanValue()) {
                String from = null;
                String to = null;
                if (fromType.equals("SonicFS")) {
                    from = "sonicfs://" + fromArtifact.getPath();
                }
                if (toType.equals("SonicFS")) {
                    to = "sonicfs://" + toArtifact.getPath();
                }
                if (from != null && to != null) {
                    ReplacementMapping rm = new ReplacementMapping(from, to);
                    if (this.m_replacementActions == null) {
                        this.m_replacementActions = new ReplacementActions(rm);
                    } else if (activatePending) {
                        this.m_replacementActions.addReplacementMappingAtHead(rm);
                    } else {
                        this.m_replacementActions.addReplacementMappingAtTail(rm);
                    }
                }
            }
            String warning = null;
            Element warningElement = DOMUtils.getImmediateChildElementByName((Element)moveElement, (String)"warning");
            if (warningElement != null && (warningText = DOMUtils.getFirstTextChild((Element)warningElement)) != null) {
                warning = warningText.getNodeValue();
            }
            if (activatePending) {
                this.m_moveMappings.addAtHead(fromArtifact, toArtifact, warning);
            } else {
                this.m_moveMappings.addAtTail(fromArtifact, toArtifact, warning);
            }
        }
    }

    private IArtifact elementToArtifact(Element element) {
        if (element == null) {
            return null;
        }
        if (element.getNodeType() == 1 && ARTIFACT_PATTERN.matcher(element.getLocalName()).find()) {
            String type = element.getAttribute("type");
            String path = element.getAttribute("path");
            if (type != null && path != null) {
                return ArtifactFactory.createArtifact(type, path);
            }
        }
        return null;
    }

    private void elementsToArtifactList(Element element, List<IArtifact> list) {
        if (element == null) {
            return;
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !"artifact".equals(node.getLocalName())) continue;
            String type = ((Element)node).getAttribute("type");
            String path = ((Element)node).getAttribute("path");
            if (type == null || path == null) continue;
            list.add(ArtifactFactory.createArtifact(type, path));
        }
    }

    private static IArtifact createArtifact(IArtifact sourceArtifact, String archivePath) {
        String typeName = null;
        String pathName = null;
        int slash1 = archivePath.indexOf("/");
        if (slash1 == -1) {
            typeName = archivePath.toString();
            pathName = "/";
        } else if (slash1 > 0) {
            typeName = archivePath.substring(0, slash1);
            pathName = archivePath.substring(slash1, archivePath.length());
        } else {
            int slash2;
            if ((slash2 = archivePath.indexOf("/", ++slash1)) == -1) {
                slash2 = archivePath.length();
                pathName = "/";
            } else {
                pathName = archivePath.substring(slash2, archivePath.length());
            }
            typeName = archivePath.substring(slash1, slash2);
        }
        return ArtifactFactory.createArtifact(sourceArtifact, pathName);
    }

    private class MoveMappings {
        private final List<Pattern> m_sourceList = new ArrayList<Pattern>();
        private final List<String> m_destinationList = new ArrayList<String>();
        private final List<String> m_warningList = new ArrayList<String>();

        private MoveMappings() {
        }

        private boolean addAtTail(IArtifact sourceArtifact, IArtifact destinationArtifact, String warning) {
            boolean added = this.m_sourceList.add(Pattern.compile(sourceArtifact.getArchivePath()));
            if (added) {
                int addAt = this.m_sourceList.size() - 1;
                this.m_destinationList.add(addAt, destinationArtifact.getArchivePath());
                this.m_warningList.add(addAt, warning);
            }
            return added;
        }

        private boolean addAtHead(IArtifact sourceArtifact, IArtifact destinationArtifact, String warning) {
            for (int i = 0; i < this.m_sourceList.size(); ++i) {
                if (!this.m_sourceList.get(i).pattern().equals(sourceArtifact.getArchivePath())) continue;
                return false;
            }
            this.m_sourceList.add(0, Pattern.compile(sourceArtifact.getArchivePath()));
            this.m_destinationList.add(0, destinationArtifact.getArchivePath());
            this.m_warningList.add(0, warning);
            return true;
        }

        private void clear() {
            this.m_sourceList.clear();
            this.m_destinationList.clear();
            this.m_warningList.clear();
        }

        private IArtifact move(IArtifact sourceArtifact) {
            String sourcePath = sourceArtifact.getArchivePath();
            IArtifact destinationArtifact = sourceArtifact;
            for (int i = 0; i < this.m_sourceList.size(); ++i) {
                Matcher matchMatcher = this.m_sourceList.get(i).matcher(sourcePath);
                if (!matchMatcher.find()) continue;
                String destinationPath = matchMatcher.replaceFirst(this.m_destinationList.get(i));
                if (this.m_warningList.get(i) != null) {
                    ((AbstractArtifactStorage)ImportPropertiesFile.this.getSourceStorage())._notifyMessage(3, ImportPropertiesFile.this.getFilterName() + " Warning during move of " + sourcePath + " to " + destinationPath + ": " + this.m_warningList.get(i));
                }
                destinationArtifact = ImportPropertiesFile.createArtifact(sourceArtifact, destinationPath);
                break;
            }
            return destinationArtifact;
        }
    }

    private static class ReplacementMapping {
        private final Pattern m_pattern;
        private String m_to;

        private ReplacementMapping(String from, String to) {
            this.m_pattern = Pattern.compile(from);
            Matcher matcher = SINGLE_BACKSLASH_PATTERN.matcher(to);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(sb, "\\\\");
                sb.append("\\");
            }
            matcher.appendTail(sb);
            this.m_to = sb.toString();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ReplacementMapping) {
                return this.getSearchString().equals(((ReplacementMapping)obj).getSearchString());
            }
            if (obj instanceof String) {
                return this.getSearchString().equals(obj);
            }
            return false;
        }

        public int hashCode() {
            return this.getSearchString().hashCode();
        }

        private String getSearchString() {
            return this.m_pattern.pattern();
        }

        private String getReplacementString() {
            return this.m_to;
        }

        private Object doReplacement(Object obj) {
            String stringToSearch = null;
            if (obj instanceof String) {
                stringToSearch = (String)obj;
            } else if (obj instanceof byte[]) {
                stringToSearch = new String((byte[])obj);
            } else {
                return obj;
            }
            Matcher matcher = this.m_pattern.matcher(stringToSearch);
            return matcher.replaceAll(this.m_to);
        }
    }

    private class ConditionalReplacement {
        private Pattern m_containsPattern = null;
        private Pattern m_excludesPattern = null;
        private String m_warning = null;
        private ReplacementActions m_replacementActions = null;
        private List<Element> m_pendingMoveMappings = null;
        private String[] m_matchingGroups = null;

        private ConditionalReplacement(Element element) {
            Element move;
            Text text;
            Element warning;
            String excludesText;
            String containsText = element.getAttribute("containsText");
            if (containsText != null && containsText.length() > 0) {
                this.m_containsPattern = Pattern.compile(containsText);
            }
            if ((excludesText = element.getAttribute("excludesText")) != null && excludesText.length() > 0) {
                this.m_excludesPattern = Pattern.compile(excludesText);
            }
            if ((warning = DOMUtils.getImmediateChildElementByName((Element)element, (String)"warning")) != null && (text = DOMUtils.getFirstTextChild((Element)warning)) != null) {
                this.m_warning = text.getNodeValue();
            }
            if ((move = DOMUtils.getImmediateChildElementByName((Element)element, (String)"move")) != null) {
                this.m_pendingMoveMappings = new ArrayList<Element>();
                NodeList children = element.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node node = children.item(i);
                    if (node.getNodeType() != 1 || !"move".equals(node.getLocalName())) continue;
                    this.m_pendingMoveMappings.add((Element)node);
                }
            }
            this.m_replacementActions = new ReplacementActions(element);
        }

        boolean meetsCondition(Object content) {
            Matcher matcher;
            String stringToSearch = null;
            if (content instanceof String) {
                stringToSearch = (String)content;
            } else if (content instanceof byte[]) {
                stringToSearch = new String((byte[])content);
            } else {
                return false;
            }
            boolean meetsCondition = true;
            if (this.m_containsPattern != null) {
                matcher = this.m_containsPattern.matcher(stringToSearch);
                boolean matched = matcher.find();
                if (matched && matcher.groupCount() > 0) {
                    this.m_matchingGroups = new String[matcher.groupCount()];
                    int i = 0;
                    while (i < this.m_matchingGroups.length) {
                        this.m_matchingGroups[i++] = matcher.group(i);
                    }
                }
                meetsCondition &= matched;
            }
            if (meetsCondition && this.m_excludesPattern != null) {
                matcher = this.m_excludesPattern.matcher(stringToSearch);
                meetsCondition &= !matcher.find();
            }
            return meetsCondition;
        }

        private Object performConditionalReplacements(IArtifact artifact, Object content) {
            if (this.m_replacementActions == null) {
                return content;
            }
            if (!this.meetsCondition(content)) {
                return content;
            }
            if (this.m_warning != null) {
                ((AbstractArtifactStorage)ImportPropertiesFile.this.getSourceStorage())._notifyMessage(3, ImportPropertiesFile.this.getFilterName() + " Warning during import of " + artifact.getArchivePath() + ": " + this.m_warning);
            }
            if (this.m_pendingMoveMappings != null) {
                for (int i = 0; i < this.m_pendingMoveMappings.size(); ++i) {
                    Element moveElement = this.m_pendingMoveMappings.get(i);
                    this.activatePendingMoveMapping(moveElement);
                }
            }
            return this.m_replacementActions.performReplacementActions(artifact, content);
        }

        private void activatePendingMoveMapping(Element moveElement) {
            ImportPropertiesFile.this.addMoveMapping(moveElement, true, this.m_matchingGroups);
        }
    }

    private class ReplacementActions {
        private ArrayList<ConditionalReplacement> m_conditionalReplacements = new ArrayList();
        private ArrayList<ReplacementMapping> m_replacementMappings = new ArrayList();

        private ReplacementActions(ReplacementMapping rm) {
            this.m_replacementMappings.add(rm);
        }

        private ReplacementActions(Element element) {
            if (element == null) {
                return;
            }
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() == 1 && "if".equals(node.getLocalName())) {
                    this.m_conditionalReplacements.add(new ConditionalReplacement((Element)node));
                    continue;
                }
                if (node.getNodeType() != 1 || !"replace".equals(node.getLocalName())) continue;
                String searchText = ((Element)node).getAttribute("searchText");
                String replaceText = ((Element)node).getAttribute("replaceText");
                if (searchText == null || replaceText == null) continue;
                this.m_replacementMappings.add(new ReplacementMapping(searchText, replaceText));
            }
        }

        private boolean isEmpty() {
            return this.m_conditionalReplacements.isEmpty() && this.m_replacementMappings.isEmpty();
        }

        private void addReplacementMappingAtHead(ReplacementMapping rm) {
            this.m_replacementMappings.add(0, rm);
        }

        private void addReplacementMappingAtTail(ReplacementMapping rm) {
            this.m_replacementMappings.add(rm);
        }

        private ConditionalReplacement[] getConditionalReplacements() {
            return this.m_conditionalReplacements.toArray(new ConditionalReplacement[0]);
        }

        private ReplacementMapping[] getReplacementMappings() {
            return this.m_replacementMappings.toArray(new ReplacementMapping[0]);
        }

        private Object performReplacementActions(IArtifact artifact, Object content) {
            int i;
            if (this.isEmpty()) {
                return content;
            }
            if (artifact instanceof ZipContentArtifact) {
                ((ZipContentArtifact)artifact).getZipFileArtifact().markDirty();
            }
            Object updatedContent = content;
            if (this.m_conditionalReplacements != null && !this.m_conditionalReplacements.isEmpty()) {
                ConditionalReplacement[] cr = this.getConditionalReplacements();
                for (i = 0; i < cr.length; ++i) {
                    updatedContent = cr[i].performConditionalReplacements(artifact, updatedContent);
                }
            }
            if (!this.m_replacementMappings.isEmpty()) {
                ReplacementMapping[] rm = this.getReplacementMappings();
                for (i = 0; i < rm.length; ++i) {
                    updatedContent = rm[i].doReplacement(updatedContent);
                }
            }
            return updatedContent;
        }
    }
}

