/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.traversal;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactTraversalContext;
import com.sonicsw.deploy.artifact.SonicFSArtifact;
import com.sonicsw.deploy.traversal.AbstractExtnTraverser;
import com.sonicsw.deploy.traversal.ExtnXPRJBPTraverser;
import com.sonicsw.deploy.traversal.ExtnXPRJRoutingRuleTraverser;
import com.sonicsw.deploy.traversal.SonicFSListTraverser;

public class ExtnXPRJTraverser
extends AbstractExtnTraverser {
    public static final String EXTN_XPRJ = "xprj";

    public ExtnXPRJTraverser(IArtifact artifact) {
        super(artifact);
    }

    public static boolean isValidExtension(String extension) {
        return EXTN_XPRJ.equalsIgnoreCase(extension);
    }

    @Override
    public void doTraversal(IArtifactTraversalContext context) throws Exception {
        context.getStorage().getContentsAsString(this.m_artifact);
        int index = this.m_artifact.getName().lastIndexOf(46);
        String name = this.m_artifact.getName().substring(0, index);
        String project = this.m_artifact.getParentPath() + name + "/";
        if (this.m_artifact instanceof SonicFSArtifact) {
            SonicFSArtifact projectArtifact = new SonicFSArtifact(project);
            new SonicFSListTraverser(projectArtifact).traverse(context);
            this.handleXPRJInternalReferences(context, projectArtifact);
        }
    }

    private void handleXPRJInternalReferences(IArtifactTraversalContext context, IArtifact project) throws Exception {
        String projectPath = project.getPath();
        IArtifact[] artifacts = context.getTraversed();
        for (int i = 0; i < artifacts.length; ++i) {
            if (!"bp".equals(artifacts[i].getExtension()) || !artifacts[i].getPath().startsWith(projectPath)) continue;
            new ExtnXPRJBPTraverser(artifacts[i]).doTraversal(context);
        }
        if (project instanceof SonicFSArtifact) {
            new ExtnXPRJRoutingRuleTraverser(new SonicFSArtifact(project, "definition/routing-rules.xml")).doTraversal(context);
        }
    }
}

