/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.traversal;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactTraversalContext;
import com.sonicsw.deploy.artifact.SonicFSArtifact;
import com.sonicsw.deploy.traversal.AbstractExtnTraverser;
import com.sonicsw.deploy.traversal.ExtnXPRJBPTraverser;
import com.sonicsw.deploy.traversal.ExtnXPRJRoutingRuleTraverser;
import com.sonicsw.deploy.traversal.SonicFSListTraverser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProcessSetTraverser
extends AbstractExtnTraverser {
    public static final String FILE_PROCESS_SET = "process-set.xml";

    public ProcessSetTraverser(IArtifact artifact) {
        super(artifact);
    }

    public static boolean isProcessSet(String filename) {
        return FILE_PROCESS_SET.equalsIgnoreCase(filename);
    }

    @Override
    public void doTraversal(IArtifactTraversalContext context) throws Exception {
        Document doc = context.getStorage().getContentsAsDom(this.m_artifact);
        Element element = doc.getDocumentElement();
        String name = element.getAttribute("name");
        String project = this.m_artifact.getParentPath();
        if (this.m_artifact instanceof SonicFSArtifact) {
            SonicFSArtifact projectArtifact = new SonicFSArtifact(project);
            new SonicFSListTraverser(projectArtifact).traverse(context);
            this.handleXPRJInternalReferences(context, projectArtifact);
            new ExtnXPRJRoutingRuleTraverser(new SonicFSArtifact(projectArtifact, "definition/routing-rules.xml")).doTraversal(context);
        }
    }

    private void handleXPRJInternalReferences(IArtifactTraversalContext context, IArtifact project) throws Exception {
        String projectPath = project.getPath();
        IArtifact[] artifacts = context.getTraversed();
        for (int i = 0; i < artifacts.length; ++i) {
            if (!"bp".equals(artifacts[i].getExtension()) || !artifacts[i].getPath().startsWith(projectPath)) continue;
            new ExtnXPRJBPTraverser(artifacts[i]).doTraversal(context);
        }
    }
}

