/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.mgmtapi.config.impl;

import com.sonicsw.esb.mgmtapi.ESBAPIContext;
import com.sonicsw.esb.mgmtapi.ESBAPIException;
import com.sonicsw.esb.mgmtapi.config.IContainerConfig;
import com.sonicsw.esb.mgmtapi.config.IContainerConfigAPI;
import com.sonicsw.esb.mgmtapi.config.impl.ConfigUtils;
import com.sonicsw.mf.mgmtapi.config.IContainerBean;
import com.sonicsw.mx.config.IAttributeMap;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.xqimpl.config.IConfigSPI;
import com.sonicsw.xqimpl.config.IConfiguration;
import com.sonicsw.xqimpl.config.XQConfiguration;
import com.sonicsw.xqimpl.config.XQConfigurationException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class ContainerConfigAPI
implements IContainerConfigAPI {
    final IConfigSPI configBackend;

    public ContainerConfigAPI(IConfigSPI configBackend) {
        this.configBackend = configBackend;
    }

    public IContainerConfig createESBContainer(String name) throws ESBAPIException {
        return (IContainerConfig)this.configBackend.createConfiguration(name, "XQ_CONTAINER");
    }

    public void deleteESBContainer(String name) throws ESBAPIException {
        this.configBackend.deleteConfiguration(name, "XQ_CONTAINER");
    }

    public IContainerConfig importESBContainer(String filename, boolean overwrite) {
        IConfiguration ret = this.configBackend.importConfiguration(filename, "XQ_CONTAINER", overwrite, true);
        return (IContainerConfig)ret;
    }

    public void exportESBContainer(String name, String directory, boolean overwrite) throws ESBAPIException {
        try {
            IConfiguration container = this.configBackend.getConfiguration(name, "XQ_CONTAINER");
            String elementContent = ((XQConfiguration)container).serializeToXML();
            ConfigUtils.writeXmlString(directory, container.getName(), elementContent, overwrite);
        }
        catch (XQConfigurationException e) {
            throw new ESBAPIException((Exception)((Object)e));
        }
    }

    public String exportESBContainer(String name) throws ESBAPIException {
        try {
            IConfiguration container = this.configBackend.getConfiguration(name, "XQ_CONTAINER");
            String elementContent = ((XQConfiguration)container).serializeToXML();
            return elementContent;
        }
        catch (XQConfigurationException e) {
            throw new ESBAPIException((Exception)((Object)e));
        }
    }

    public String[] listESBContainers() throws ESBAPIException {
        return this.configBackend.listConfigurations("XQ_CONTAINER");
    }

    public IContainerConfig getESBContainer(String name) throws ESBAPIException {
        return (IContainerConfig)this.configBackend.getConfiguration(name, "XQ_CONTAINER");
    }

    public IContainerBean getMFContainer(String name) {
        return (IContainerBean)this.configBackend.getBean(IConfigSPI.MFCONTAINER_BEAN, name);
    }

    public void saveESBContainer(IContainerConfig testContainer) {
        this.configBackend.saveConfiguration((IConfiguration)testContainer);
    }

    public void addESBContainerToMFContainer(String mfContainerName, String esbContainerName) {
        this.configBackend.addXQContainerToMFContainer(mfContainerName, esbContainerName, true);
    }

    public String[] listMFContainersWithESBContainer(String esbContainerName) {
        return this.listMFContainersWithESBContainer(esbContainerName, true);
    }

    public String[] listMFContainerLogicalIDsWithESBContainer(String esbContainerName) {
        return this.listMFContainersWithESBContainer(esbContainerName, false);
    }

    private String[] listMFContainersWithESBContainer(String esbContainerName, boolean trimName) {
        ArrayList<String> wantedMFContainers = new ArrayList<String>();
        Set mfContainers = this.configBackend.listAllOfType("MF_CONTAINER");
        Iterator mfIT = mfContainers.iterator();
        block0: while (mfIT.hasNext()) {
            IConfigElement container = this.configBackend.loadConfigElement((String)mfIT.next());
            String mfContainerID = container.getName();
            IAttributeMap componentsSet = (IAttributeMap)container.getAttribute("COMPONENTS");
            for (IAttributeMap componentValue : componentsSet.values()) {
                String esbContainerNameFound;
                IConfigBean compReference = (IConfigBean)componentValue.getAttribute("CONFIG_REF");
                String compType = compReference.getConfigType().getName();
                if (!compReference.getConfigType().getName().equals("XQ_CONTAINER") || (esbContainerNameFound = (String)compReference.getAttribute("name")) == null || !esbContainerNameFound.equals(esbContainerName)) continue;
                if (trimName) {
                    mfContainerID = mfContainerID.substring(mfContainerID.lastIndexOf(47) + 1);
                }
                wantedMFContainers.add(mfContainerID);
                continue block0;
            }
        }
        String[] result = wantedMFContainers.toArray(new String[0]);
        return result;
    }

    public String[] listESBContainersInMFContainer(String mfContainerName) {
        ESBAPIContext ctx = new ESBAPIContext("");
        ctx.setDescr("listESBContainers");
        ctx.setObjectId(mfContainerName);
        ctx.setObjectType(IConfigSPI.MFCONTAINER_BEAN.getName());
        try {
            IConfigElement container = this.configBackend.loadConfigElement(mfContainerName);
            if (container == null) {
                throw new ESBAPIException("MF Container `" + mfContainerName + "` does not exist", ctx);
            }
            LinkedList<String> esbContainers = new LinkedList<String>();
            IAttributeMap componentsSet = (IAttributeMap)container.getAttribute("COMPONENTS");
            for (IAttributeMap componentValue : componentsSet.values()) {
                String esbContainerName;
                IConfigBean compReference = (IConfigBean)componentValue.getAttribute("CONFIG_REF");
                String compType = compReference.getConfigType().getName();
                if (!compReference.getConfigType().getName().equals("XQ_CONTAINER") || (esbContainerName = (String)compReference.getAttribute("name")) == null) continue;
                esbContainers.add(esbContainerName);
            }
            String[] names = new String[esbContainers.size()];
            return esbContainers.toArray(names);
        }
        catch (Exception e) {
            throw new ESBAPIException(e, ctx);
        }
    }

    public void removeESBContainerFromMFContainer(String mfContainerName, String esbContainerName) {
        this.configBackend.removeXQContainerFromMFContainer(mfContainerName, esbContainerName);
    }
}

