/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.mgmtapi.config.impl;

import com.sonicsw.esb.mgmtapi.config.IConnectionConfig;
import com.sonicsw.esb.mgmtapi.config.IEndpointConfig;
import com.sonicsw.esb.mgmtapi.config.IEndpointConfigAPI;
import com.sonicsw.xqimpl.config.IConfigSPI;
import com.sonicsw.xqimpl.config.IConfiguration;
import java.util.Set;

public class EndpointConfigAPI
implements IEndpointConfigAPI {
    public IConfigSPI configBackend;
    private static final IConnectionConfig.ConnectionType[] connectionTypes = new IConnectionConfig.ConnectionType[]{IConnectionConfig.JMS_CONNECTION_TYPE};

    public EndpointConfigAPI(IConfigSPI m_configbackend) {
        this.configBackend = m_configbackend;
    }

    public String[] listEndpoints() {
        String[] ret = this.configBackend.listConfigurations("endpoint");
        return ret;
    }

    public IEndpointConfig createEndpoint(String name) {
        IEndpointConfig cfg = (IEndpointConfig)this.configBackend.createConfiguration(name, "endpoint");
        return cfg;
    }

    public void deleteEndpoint(String name) {
        this.configBackend.deleteConfiguration(name, "endpoint");
    }

    public void saveEndpoint(IEndpointConfig endpoint) {
        this.configBackend.saveConfiguration((IConfiguration)endpoint);
    }

    public IEndpointConfig getEndpoint(String name) {
        IEndpointConfig cfg = (IEndpointConfig)this.configBackend.getConfiguration(name, "endpoint");
        return cfg;
    }

    public String exportEndpoint(String name) {
        IConfiguration cfg = (IConfiguration)this.getEndpoint(name);
        return this.retreiveExportConfig(cfg);
    }

    public IEndpointConfig importEndpoint(String configurationContent, boolean overwrite) {
        IConfiguration imported = this.configBackend.importConfiguration(configurationContent, "endpoint", overwrite, true);
        return (IEndpointConfig)imported;
    }

    public IConnectionConfig.ConnectionType[] listConnectionTypes() {
        return connectionTypes;
    }

    public String[] listConnections() {
        String[] ret = this.configBackend.listConfigurations("connection");
        return ret;
    }

    public IConnectionConfig createConnectionConfig(String name) {
        IConnectionConfig cfg = (IConnectionConfig)this.configBackend.createConfiguration(name, "connection");
        return cfg;
    }

    public IConnectionConfig getConnectionConfig(String name) {
        IConnectionConfig cfg = (IConnectionConfig)this.configBackend.getConfiguration(name, "connection");
        return cfg;
    }

    public void deleteConnectionConfig(String name) {
        this.configBackend.deleteConfiguration(name, "connection");
    }

    public void saveConnection(IConnectionConfig connection) {
        this.configBackend.saveConfiguration((IConfiguration)connection);
    }

    public String exportConnection(String name) {
        IConfiguration cfg = (IConfiguration)this.getConnectionConfig(name);
        return this.retreiveExportConfig(cfg);
    }

    private String retreiveExportConfig(IConfiguration cfg) {
        if (cfg == null) {
            return null;
        }
        String ret = this.configBackend.exportConfiguration(cfg);
        return ret;
    }

    public IConnectionConfig importConnection(String configurationContent, boolean overwrite) {
        IConfiguration imported = this.configBackend.importConfiguration(configurationContent, "connection", overwrite, true);
        return (IConnectionConfig)imported;
    }

    public String[] getContainersUsingConection(String name) {
        Set http = this.configBackend.executePhysQuery("/xqContainers", "RoutingHttpConnection", name, "name");
        Set bus = this.configBackend.executePhysQuery("/xqContainers", "BusConnection", name, "name");
        bus.addAll(http);
        return bus.toArray(new String[bus.size()]);
    }

    public String[] getEndpointsUsingConnection(String name) {
        String[] ret = null;
        Set eps = this.configBackend.executePhysQuery("/xqEndpoints", "connection_ref", name, "name");
        ret = eps.toArray(new String[eps.size()]);
        return ret;
    }
}

