/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.mgmtapi.config.impl;

import com.sonicsw.esb.mgmtapi.ESBAPIException;
import com.sonicsw.esb.mgmtapi.config.IProcessConfig;
import com.sonicsw.esb.mgmtapi.config.IProcessConfigAPI;
import com.sonicsw.xqimpl.config.IConfigSPI;
import com.sonicsw.xqimpl.config.IConfiguration;
import java.util.Set;

public class ProcessConfigAPI
implements IProcessConfigAPI {
    public IConfigSPI configBackend;

    public ProcessConfigAPI(IConfigSPI m_configbackend) {
        this.configBackend = m_configbackend;
    }

    public String[] listProcesses() {
        String[] list = this.configBackend.listConfigurations("process");
        return list;
    }

    public IProcessConfig getProcess(String name) {
        IConfiguration configuration = this.configBackend.getConfiguration(name, "process");
        return (IProcessConfig)configuration;
    }

    public void deleteProcess(String name) {
        this.configBackend.deleteConfiguration(name, "process");
    }

    public String exportProcess(String name) {
        IProcessConfig process = this.getProcess(name);
        String ret = this.configBackend.exportConfiguration((IConfiguration)process);
        return ret;
    }

    public IProcessConfig importProcess(String configurationContent, boolean overwrite) {
        IConfiguration imported = this.configBackend.importConfiguration(configurationContent, "process", overwrite, true);
        return (IProcessConfig)imported;
    }

    public String[] listDeployedContainers(String processName) {
        IProcessConfig process = this.getProcess(processName);
        if (process == null) {
            throw new ESBAPIException((Exception)new IllegalArgumentException("no process by name:" + processName));
        }
        Set temp = this.configBackend.executePhysQueryListContains("/xqContainers", "services", processName, "name");
        return temp.toArray(new String[temp.size()]);
    }

    public void saveProcess(IProcessConfig process) {
        this.configBackend.saveConfiguration((IConfiguration)process);
    }
}

