/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.tools.admin;

import com.sonicsw.deploy.IArtifactDepends;
import com.sonicsw.deploy.IArtifactDiff;
import com.sonicsw.deploy.IArtifactMerge;
import com.sonicsw.deploy.IArtifactNotificationEvent;
import com.sonicsw.deploy.IArtifactNotificationListener;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.action.ApplyMapAction;
import com.sonicsw.deploy.action.CreateMapAction;
import com.sonicsw.deploy.action.DependencyAction;
import com.sonicsw.deploy.action.DiffAction;
import com.sonicsw.deploy.action.ImpactAnalysisAction;
import com.sonicsw.deploy.action.MergeAction;
import com.sonicsw.deploy.action.RevDependencyAction;
import com.sonicsw.deploy.artifact.RootArtifact;
import com.sonicsw.deploy.storage.DSArtifactStorage;
import com.sonicsw.deploy.storage.ZipArtifactStorage;
import com.sonicsw.deploy.tools.common.DSToFSExportHandler;
import com.sonicsw.deploy.tools.common.DSToZipExportHandler;
import com.sonicsw.deploy.tools.common.ExportPropertiesArtifact;
import com.sonicsw.deploy.tools.common.FSToDSImportHandler;
import com.sonicsw.deploy.tools.common.ZipToDSImportHandler;
import com.sonicsw.deploy.util.CommandLineParser;
import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mx.config.util.SonicFSException;
import com.sonicsw.mx.config.util.SonicFSFileSystem;
import com.sonicsw.xqimpl.Version;
import com.sonicsw.xqimpl.config.IConfiguration;
import com.sonicsw.xqimpl.config.IXQConfigManager;
import com.sonicsw.xqimpl.config.XQConfigHelper;
import com.sonicsw.xqimpl.config.XQConfigManager;
import com.sonicsw.xqimpl.config.XQConfiguration;
import com.sonicsw.xqimpl.config.XQConfigurationException;
import com.sonicsw.xqimpl.config.XQGlobalConfig;
import com.sonicsw.xqimpl.config.XQLicenseCodeConfig;
import com.sonicsw.xqimpl.config.XQLicenseHelper;
import com.sonicsw.xqimpl.config.XmlValidator;
import com.sonicsw.xqimpl.config.XmlValidatorFactory;
import com.sonicsw.xqimpl.tools.admin.ESBContainerCommands;
import com.sonicsw.xqimpl.tools.admin.MFContainerUtility;
import com.sonicsw.xqimpl.tools.common.DSConnectionDetails;
import com.sonicsw.xqimpl.tools.common.ESBContainerInfo;
import com.sonicsw.xqimpl.tools.common.Utils;
import com.sonicsw.xqimpl.util.sonicfs.Handler;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.xml.sax.SAXException;

public final class XQCommandLine {
    private static final String OVERRIDE = "override";
    private static final boolean SHOW_PROMPT = true;
    private static String[] m_arguments;
    private static String SCRIPT_NAME;
    private static String m_promptWord;
    private static XQConfigManager m_configManager;
    private static boolean m_connected;
    private Method m_commandMethod;
    private String m_inputCommand;
    private int m_argumentCount;
    private boolean m_bye = false;
    private boolean m_help = false;
    private Method m_newCommandMethod;
    private Map<String, Method> m_commands;
    private String m_helpString = "help";
    private Class<XQCommandLine> m_AdminclassObject = XQCommandLine.class;
    private static final String DEFAULT_DOMAIN = "Domain1";
    private static final String RESOURCE_STR = "/Resources";
    private static final String BINARY_EXT_SEP = ",";
    private static final String BINARY_EXTS;
    private static MFContainerUtility m_containerUtility;
    private static SonicFSFileSystem m_fs;
    private static ESBContainerCommands m_esbContainerCommands;
    private static String m_url;
    private static String m_user;
    private static String m_password;
    private static String m_domain;
    private static QuickAndDirtyNotificationListener qdListener;

    public XQCommandLine() {
        if (System.getProperty("sonicsw.mf.disableFTClient") == null) {
            System.setProperty("sonicsw.mf.disableFTClient", "true");
        }
        this.m_commands = new Hashtable<String, Method>();
        try {
            this.m_commands.put("dump", this.m_AdminclassObject.getDeclaredMethod("dump", new Class[0]));
            this.m_commands.put("exit", this.m_AdminclassObject.getDeclaredMethod("exit", new Class[0]));
            this.m_commands.put("bye", this.m_AdminclassObject.getDeclaredMethod("exit", new Class[0]));
            this.m_commands.put("help", this.m_AdminclassObject.getDeclaredMethod("help", new Class[0]));
            this.m_commands.put("?", this.m_AdminclassObject.getDeclaredMethod("help", new Class[0]));
            this.m_commands.put("import", this.m_AdminclassObject.getDeclaredMethod("Import", new Class[0]));
            this.m_commands.put("importnv", this.m_AdminclassObject.getDeclaredMethod("ImportNV", new Class[0]));
            this.m_commands.put("export", this.m_AdminclassObject.getDeclaredMethod("Export", new Class[0]));
            this.m_commands.put("add", this.m_AdminclassObject.getDeclaredMethod("add", new Class[0]));
            this.m_commands.put("delete", this.m_AdminclassObject.getDeclaredMethod("delete", new Class[0]));
            this.m_commands.put("list", this.m_AdminclassObject.getDeclaredMethod("list", new Class[0]));
            this.m_commands.put("connect", this.m_AdminclassObject.getDeclaredMethod("connect", new Class[0]));
            this.m_commands.put("disconnect", this.m_AdminclassObject.getDeclaredMethod("disconnect", new Class[0]));
            this.m_commands.put("container", this.m_AdminclassObject.getDeclaredMethod("container", new Class[0]));
            this.m_commands.put("createmap", this.m_AdminclassObject.getDeclaredMethod("createmap", new Class[0]));
            this.m_commands.put("applymap", this.m_AdminclassObject.getDeclaredMethod("applymap", new Class[0]));
            this.m_commands.put("diff", this.m_AdminclassObject.getDeclaredMethod("diff", new Class[0]));
            this.m_commands.put("mqdepends", this.m_AdminclassObject.getDeclaredMethod("mqdepends", new Class[0]));
            this.m_commands.put("mqrevdepends", this.m_AdminclassObject.getDeclaredMethod("mqrevdepends", new Class[0]));
            this.m_commands.put("impact", this.m_AdminclassObject.getDeclaredMethod("impact", new Class[0]));
            this.m_commands.put("merge", this.m_AdminclassObject.getDeclaredMethod("merge", new Class[0]));
            this.m_commands.put("set", this.m_AdminclassObject.getDeclaredMethod("set", new Class[0]));
            this.m_commands.put("props", this.m_AdminclassObject.getDeclaredMethod("props", new Class[0]));
            this.m_commands.put("esbcontainer", this.m_AdminclassObject.getDeclaredMethod("esbcontainer", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            XQCommandLine.showError(e);
        }
    }

    public void getCommand() {
        this.getCommand(new BufferedReader(new InputStreamReader(System.in)));
    }

    public void getCommand(BufferedReader reader) {
        this.m_bye = false;
        while (!this.m_bye) {
            this.cleanInput();
            XQCommandLine.prompt();
            try {
                String line = reader.readLine();
                if (line == null || "exit".equals(line.trim()) || "bye".equals(line.trim())) {
                    this.m_bye = true;
                    this.exit();
                }
                String spaceDelims = " \n\t\r";
                StringTokenizer inputTokenizer = new StringTokenizer(line, spaceDelims, true);
                boolean unbalancedQuote = false;
                while (inputTokenizer.hasMoreElements() && !this.m_help && !unbalancedQuote) {
                    String token = inputTokenizer.nextToken(spaceDelims);
                    if (spaceDelims.indexOf(token) != -1) continue;
                    int lastIndex = token.indexOf("\"");
                    if (lastIndex != -1) {
                        int countDoubleQuotes = 1;
                        while ((lastIndex = token.indexOf("\"", lastIndex + 1)) != -1) {
                            ++countDoubleQuotes;
                        }
                        if (countDoubleQuotes % 2 != 0) {
                            if (inputTokenizer.hasMoreTokens()) {
                                token = token + inputTokenizer.nextToken("\"");
                                if (inputTokenizer.hasMoreTokens() && "\"".equals(inputTokenizer.nextToken())) {
                                    token = token + "\"";
                                } else {
                                    unbalancedQuote = true;
                                }
                            } else {
                                unbalancedQuote = true;
                            }
                        }
                    }
                    try {
                        if (unbalancedQuote || this.dealWithInput(token)) continue;
                        break;
                    }
                    catch (NoSuchMethodException e) {
                        XQCommandLine.showError(e);
                    }
                }
                if (unbalancedQuote) {
                    System.out.println("UNBALANCED_QUOTES");
                    continue;
                }
                if (this.m_commandMethod == null) continue;
                try {
                    this.m_commandMethod.invoke(this.m_AdminclassObject, (Object[])null);
                }
                catch (InvocationTargetException e) {
                    Throwable ex = e.getTargetException();
                    if (ex instanceof MethodError) {
                        XQCommandLine.showError(ex);
                        continue;
                    }
                    XQCommandLine.showErrorAndTrace(ex);
                }
                catch (Exception e) {
                    XQCommandLine.showErrorAndTrace(e);
                }
            }
            catch (IOException e) {
                XQCommandLine.showError("Cannot process the command" + e.getMessage());
                this.exit();
            }
        }
    }

    private boolean dealWithInput(String token) throws NoSuchMethodException {
        boolean ret = true;
        this.m_inputCommand = this.m_inputCommand == null || "".equals(this.m_inputCommand) ? token : this.m_inputCommand + " " + token;
        if (this.m_argumentCount == 0) {
            this.m_newCommandMethod = this.m_commands.get(this.m_inputCommand.toLowerCase());
            if (this.m_newCommandMethod == null) {
                if (this.m_commandMethod != null) {
                    this.parseArgument(token);
                } else {
                    System.out.println("Unknown command : " + this.m_inputCommand);
                    System.out.println("  Type 'help' to view the list of available commands");
                    ret = false;
                }
            } else {
                this.m_commandMethod = this.m_newCommandMethod;
            }
        } else {
            this.parseArgument(token);
        }
        if (this.m_commandMethod == null && token.compareTo(this.m_helpString) == 0) {
            this.m_commandMethod = this.m_AdminclassObject.getDeclaredMethod("help", new Class[0]);
            this.m_inputCommand = this.m_inputCommand.compareTo(this.m_helpString) == 0 ? "" : this.m_inputCommand.substring(0, this.m_inputCommand.length() - 2);
            this.m_help = true;
        }
        return ret;
    }

    private void parseArgument(String token) {
        StringTokenizer firstArgTokenizer = new StringTokenizer(token, ",\"\t ", true);
        while (firstArgTokenizer.hasMoreTokens()) {
            String arg = "";
            boolean inDoubleQuotes = false;
            boolean completeToken = false;
            while (!completeToken) {
                String subToken = firstArgTokenizer.nextToken();
                if (subToken.compareTo(BINARY_EXT_SEP) == 0) {
                    if (inDoubleQuotes) {
                        arg = arg + subToken;
                    } else {
                        completeToken = true;
                    }
                } else if (subToken.compareTo("\"") == 0) {
                    inDoubleQuotes = !inDoubleQuotes;
                    arg = arg + subToken;
                } else {
                    arg = arg + subToken;
                }
                if (firstArgTokenizer.hasMoreTokens()) continue;
                completeToken = true;
            }
            if (arg.length() <= 0) continue;
            if (arg.charAt(0) == '\"' && arg.charAt(arg.length() - 1) == '\"') {
                arg = arg.length() == 2 ? "" : arg.substring(1, arg.length() - 1);
            }
            XQCommandLine.m_arguments[this.m_argumentCount++] = arg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cleanInput() {
        XQCommandLine xQCommandLine = this;
        synchronized (xQCommandLine) {
            m_arguments = new String[75];
        }
        this.m_argumentCount = 0;
        this.m_commandMethod = null;
        this.m_newCommandMethod = null;
        this.m_inputCommand = "";
    }

    public void exit() {
        try {
            if (m_connected) {
                m_fs.close();
            }
        }
        catch (Exception e) {
            XQCommandLine.showError("Disconnect failure " + e.getMessage());
        }
        System.out.println("Shutting down...");
        System.exit(0);
    }

    private static void showErrorAndTrace(Throwable e) {
        XQCommandLine.showError(e);
        e.printStackTrace();
    }

    private static void showError(Throwable e) {
        if (e.getMessage() != null) {
            XQCommandLine.showError(e.getMessage());
        } else {
            XQCommandLine.showError(e.toString());
        }
    }

    private static void showError(String s) {
        System.out.println("*Error*: " + s);
    }

    private static void throwError(String s) {
        throw new MethodError(s);
    }

    public static void container() {
        if (!m_connected) {
            throw MethodError.NOT_CONNECTED;
        }
        String command = m_arguments[0];
        String containerName = m_arguments[1];
        String componentName = m_arguments[2];
        if (!MFContainerUtility.parseContainerArgs(command, containerName, componentName)) {
            MFContainerUtility.printContainerUsage();
            return;
        }
        if ("list".equalsIgnoreCase(command)) {
            XQCommandLine.containerList();
        }
        if ("suspend".equalsIgnoreCase(command)) {
            XQCommandLine.containerSuspend(containerName, componentName);
        } else if ("resume".equalsIgnoreCase(command)) {
            XQCommandLine.containerResume(containerName, componentName);
        } else if ("shutdown".equalsIgnoreCase(command)) {
            XQCommandLine.containerShutdown(containerName);
        } else if ("reload".equalsIgnoreCase(command)) {
            XQCommandLine.containerReload(containerName, componentName);
        } else if ("status".equalsIgnoreCase(command)) {
            XQCommandLine.containerStatus(containerName);
        }
    }

    private static void containerList() {
        m_containerUtility.printDomainState();
    }

    private static void containerStatus(String containerName) {
        m_containerUtility.printContainerState(containerName);
    }

    private static void containerResume(String containerName, String componentName) {
        m_containerUtility.resume(containerName, componentName);
    }

    private static void containerSuspend(String containerName, String componentName) {
        m_containerUtility.suspend(containerName, componentName);
    }

    private static void containerShutdown(String containerName) {
        m_containerUtility.shutdown(containerName);
    }

    private static void containerReload(String containerName, String componentName) {
        m_containerUtility.reload(containerName, componentName);
    }

    public static synchronized void connect() {
        m_domain = m_arguments[0];
        m_url = m_arguments[1];
        m_user = m_arguments[2];
        m_password = m_arguments[3];
        if (m_domain == null || m_domain.length() == 0) {
            XQCommandLine.showError("Domain name is not specified");
        } else if (m_url == null || m_url.length() == 0) {
            XQCommandLine.showError("Broker URL is not specified");
        } else {
            System.out.println("Connecting ...");
            Hashtable<String, String> contextHash = Utils.createContextMap(m_domain, m_url, m_user, m_password);
            try {
                m_configManager = XQConfigManager.getInstance(contextHash);
                m_configManager.setDirectoryProxy(m_url, m_password, m_user, m_domain);
                if (m_configManager.getConnectorClient() != null) {
                    m_containerUtility = new MFContainerUtility(m_domain, m_configManager.getConnectorClient());
                }
                m_fs = new SonicFSFileSystem((IDirectoryFileSystemService)m_configManager.getDirectoryService(), m_user);
                Handler.setDirectoryService((IDirectoryFileSystemService)((IDirectoryFileSystemService)m_configManager.getDirectoryService()));
                Handler.setOverrideProperties(contextHash);
                DSConnectionDetails dsConnectionDetails = new DSConnectionDetails(m_domain, m_url, m_user, m_password);
                m_esbContainerCommands = new ESBContainerCommands(dsConnectionDetails, System.out);
                m_connected = true;
                System.out.println("    Connected to Directory Service at " + m_url);
            }
            catch (Exception e) {
                XQCommandLine.showError(e);
            }
        }
    }

    public static void disconnect() {
        if (!m_connected) {
            throw MethodError.NOT_CONNECTED;
        }
        m_connected = false;
        try {
            m_fs.close();
            m_esbContainerCommands = null;
        }
        catch (Exception e) {
            XQCommandLine.showError("Disconnect failure " + e.getMessage());
        }
    }

    public static void list() {
        if (!m_connected) {
            throw MethodError.NOT_CONNECTED;
        }
        String type = m_arguments[0];
        if (type == null || type.length() == 0) {
            System.out.println("    " + "XQ_CONTAINER".toLowerCase());
            System.out.println("    service");
            System.out.println("    serviceType");
            System.out.println("    endpoint");
            System.out.println("    endpointType");
            System.out.println("    connection");
            System.out.println("    connectionType");
            System.out.println("    process");
            System.out.println("    accessor");
            System.out.println("    license");
            return;
        }
        if ("container".equalsIgnoreCase(type)) {
            XQCommandLine.containerList();
            return;
        }
        if ("file".equalsIgnoreCase(type = XQCommandLine.getCanonicalType(type)) || "directory".equalsIgnoreCase(type)) {
            try {
                String name = m_arguments[1];
                if (name == null) {
                    name = RESOURCE_STR;
                } else if (name.charAt(0) != '/') {
                    name = "/Resources/" + name;
                }
                System.out.println("File listing from Directory Service. Location = " + name);
                String[] result = m_fs.list(name);
                for (int i = 0; i < result.length; ++i) {
                    System.out.println("    " + result[i]);
                }
            }
            catch (SonicFSException e) {
                XQCommandLine.showError("Failed to generate list. " + e.getMessage());
            }
        } else if (XQCommandLine.isValidType(type)) {
            System.out.println("Listing from Directory Service. Type = " + type);
            try {
                Map elementsName = m_configManager.listElementsName(type);
                System.out.println("Results...");
                if (type.equals("license")) {
                    for (String sVersion : Version.getCompatibleVersions()) {
                        try {
                            XQLicenseHelper xqCHelper = new XQLicenseHelper(m_configManager, sVersion);
                            System.out.println("Displaying control code for version " + sVersion + "..");
                            System.out.println("Control Code = " + xqCHelper.getLicenseKey());
                            System.out.println("");
                        }
                        catch (Exception exception) {}
                    }
                    return;
                }
                for (Map.Entry entry : elementsName.entrySet()) {
                    if (((String)entry.getValue()).length() <= 0) continue;
                    System.out.println("    " + (String)entry.getKey());
                }
            }
            catch (XQConfigurationException e) {
                XQCommandLine.showError("Failed to generate list. " + e.getMessage());
            }
        } else {
            XQCommandLine.showError("'" + type + "' is not a valid type");
        }
    }

    private static String getCanonicalType(String type) {
        if (type.equalsIgnoreCase("XQ_CONTAINER")) {
            return "XQ_CONTAINER";
        }
        if (type.equalsIgnoreCase("service")) {
            return "service";
        }
        if (type.equalsIgnoreCase("serviceType")) {
            return "serviceType";
        }
        if (type.equalsIgnoreCase("endpoint")) {
            return "endpoint";
        }
        if (type.equalsIgnoreCase("endpointType")) {
            return "endpointType";
        }
        if (type.equalsIgnoreCase("connection")) {
            return "connection";
        }
        if (type.equalsIgnoreCase("connectionType")) {
            return "connectionType";
        }
        if (type.equalsIgnoreCase("process")) {
            return "process";
        }
        if (type.equalsIgnoreCase("accessor")) {
            return "accessor";
        }
        if (type.equalsIgnoreCase("license")) {
            return "license";
        }
        return type;
    }

    private static void internalImport(boolean validate) {
        if (!m_connected) {
            throw MethodError.NOT_CONNECTED;
        }
        String type = m_arguments[0];
        String filename = m_arguments[1];
        if (type == null || type.length() == 0) {
            XQCommandLine.showError("Type is not specified");
        } else if ("archive".equalsIgnoreCase(type)) {
            XQCommandLine.importArchive();
        } else if ("fs".equalsIgnoreCase(type)) {
            XQCommandLine.importFS();
        } else if (!XQCommandLine.isValidType(type)) {
            if ("container".equals(type)) {
                XQCommandLine.showError("Importing type \"container\" is not supported. Try using type \"xq_container\".");
            } else {
                XQCommandLine.showError("'" + type + "' is not a valid type");
            }
        } else if (filename == null || filename.length() == 0) {
            XQCommandLine.showError("File name is not specified");
        } else {
            try {
                boolean overwrite = false;
                String szOver = m_arguments[2];
                if (OVERRIDE.equalsIgnoreCase(szOver)) {
                    overwrite = true;
                }
                type = XQCommandLine.getCanonicalType(type);
                File file = new File(filename);
                System.out.println("Importing into Directory Service...");
                System.out.println("    type     = " + type);
                System.out.println("    file     = " + file.getAbsolutePath());
                System.out.println("    override = " + overwrite);
                IConfiguration component = XQConfigHelper.createConfigObject((XQConfigManager)m_configManager, (String)type);
                component.initFromDSFile(file.getAbsolutePath(), validate, !overwrite);
                component.initFromDS(component.getElement());
                if (!XQCommandLine.bindComponent(type, component, !component.isNewElement())) {
                    XQCommandLine.showError("Configuration already exists. Specify override to overwrite existing configuration.");
                }
            }
            catch (XQConfigurationException e) {
                XQCommandLine.showError(e);
            }
        }
    }

    private static void importFS() {
        XQCommandLine.importFS(new FSToDSImportHandler());
    }

    private static void importArchive() {
        XQCommandLine.importFS(new ZipToDSImportHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void importFS(FSToDSImportHandler handler) {
        String srcArchivePath = m_arguments[1];
        String importSettingsArgument = m_arguments[2];
        String skipCleanupArgument = m_arguments[3];
        if (srcArchivePath == null || srcArchivePath.length() == 0) {
            XQCommandLine.showError("Source archive path is not specified");
            return;
        }
        boolean skipCleanup = false;
        File importPropertiesFile = null;
        try {
            handler.addNotificationListener(qdListener);
            if (importSettingsArgument != null && importSettingsArgument.length() != 0) {
                if (OVERRIDE.equalsIgnoreCase(importSettingsArgument)) {
                    handler.getProperties().setGlobalOverwrite(true);
                } else if ("skipcleanup".equalsIgnoreCase(importSettingsArgument)) {
                    skipCleanup = true;
                } else {
                    importPropertiesFile = new File(importSettingsArgument);
                    if (!importPropertiesFile.exists()) {
                        XQCommandLine.showError("Import properties file " + importPropertiesFile + " does not exist");
                        return;
                    }
                    handler.openPropertiesFile(importSettingsArgument);
                    if ("skipcleanup".equalsIgnoreCase(skipCleanupArgument)) {
                        skipCleanup = true;
                    }
                }
            }
            handler.open(srcArchivePath);
            handler.connectToDS(m_configManager.getDirectoryService(), m_domain, m_user);
            handler.importToDS();
        }
        catch (Exception e) {
            XQCommandLine.showErrorAndTrace(e);
        }
        finally {
            if (handler != null && !skipCleanup) {
                try {
                    handler.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void Import() {
        XQCommandLine.internalImport(true);
    }

    public static void ImportNV() {
        XQCommandLine.internalImport(false);
    }

    public static boolean isValidType(String type) {
        String directory = XQConfigHelper.getDirectory((String)type);
        return directory != null && directory.length() != 0;
    }

    public static void Export() {
        if (!m_connected) {
            throw MethodError.NOT_CONNECTED;
        }
        String type = m_arguments[0];
        if (type == null || type.length() == 0) {
            XQCommandLine.throwError("Type is not specified");
        }
        if ("archive".equalsIgnoreCase(type)) {
            XQCommandLine.exportArchive();
            return;
        }
        if ("fs".equalsIgnoreCase(type)) {
            XQCommandLine.exportFS();
            return;
        }
        if ("directory".equalsIgnoreCase(type)) {
            XQCommandLine.exportDirectory();
            return;
        }
        if ("license".equalsIgnoreCase(type)) {
            XQCommandLine.exportLicense();
            return;
        }
        if (!("bootfile".equalsIgnoreCase(type) || "file".equalsIgnoreCase(type) || XQCommandLine.isValidType(type))) {
            XQCommandLine.showError("'" + type + "' is not a valid type");
            return;
        }
        String name = m_arguments[1];
        String filename = m_arguments[2];
        if (name == null || name.length() == 0) {
            XQCommandLine.showError("Name is not specified");
            return;
        }
        if ("bootfile".equalsIgnoreCase(type)) {
            XQCommandLine.exportBootfile(name, filename);
        } else {
            XQCommandLine.exportComponent(name, type, filename);
        }
    }

    private static void exportLicense() {
        String container = m_arguments[1];
        String version = null;
        if (m_arguments.length > 2) {
            version = m_arguments[2];
        }
        if (container == null || container.length() == 0 || !"container".equalsIgnoreCase(container)) {
            XQCommandLine.showError("Container is not specified");
        } else {
            if (version == null) {
                version = Version.getMajorMinorVersion();
            }
            System.out.println("Displaying control code for version " + version + " +...");
            try {
                XQLicenseCodeConfig component = version.startsWith("5.0") ? (XQLicenseCodeConfig)m_configManager.lookup("controlcode", "license/sonicxq/container") : (XQLicenseCodeConfig)m_configManager.lookup("controlcode", "license/sonicxq/container/" + version);
                if (component != null) {
                    System.out.println("Control Code = " + component.getControlCode());
                }
            }
            catch (Exception e) {
                XQCommandLine.showError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportArchive() {
        String targetArchivePath = m_arguments[1];
        String exportPropertiesArgument = m_arguments[2];
        String skipCleanupArgument = m_arguments[3];
        boolean skipCleanup = false;
        if (targetArchivePath == null || targetArchivePath.length() == 0) {
            XQCommandLine.showError("Target archive path is not specified");
            return;
        }
        if (exportPropertiesArgument == null || exportPropertiesArgument.length() == 0) {
            XQCommandLine.showError("export properties argument is not specified");
            return;
        }
        DSToZipExportHandler handler = null;
        try {
            handler = new DSToZipExportHandler();
            handler.addNotificationListener(qdListener);
            if ("all".equalsIgnoreCase(exportPropertiesArgument)) {
                handler.newZip();
                handler.getExportProperties().addRoot(RootArtifact.ROOT);
            } else if (exportPropertiesArgument.endsWith(".xai") || exportPropertiesArgument.endsWith("xml")) {
                handler.newZip();
                ExportPropertiesArtifact exportProperties = handler.getExportProperties();
                exportProperties.init(new File(exportPropertiesArgument));
            } else {
                handler.open(exportPropertiesArgument, false);
            }
            if (skipCleanupArgument != null && "skipcleanup".equalsIgnoreCase(skipCleanupArgument)) {
                skipCleanup = true;
            }
            handler.getExportProperties().setDomain(m_domain);
            handler.getExportProperties().setURL(m_url);
            handler.getExportProperties().setUser(m_user);
            handler.getExportProperties().setPassword(m_password);
            handler.rebuild();
            handler.saveZipAs(targetArchivePath);
        }
        catch (Exception e) {
            XQCommandLine.showErrorAndTrace(e);
        }
        finally {
            if (handler != null && !skipCleanup) {
                try {
                    handler.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportFS() {
        String targetFSPath = m_arguments[1];
        String exportPropertiesArgument = m_arguments[2];
        String skipCleanupArgument = m_arguments[3];
        boolean skipCleanup = false;
        if (targetFSPath == null || targetFSPath.length() == 0) {
            XQCommandLine.showError("Target FS path is not specified");
            return;
        }
        if (exportPropertiesArgument == null || exportPropertiesArgument.length() == 0) {
            XQCommandLine.showError("export properties argument is not specified");
            return;
        }
        DSToFSExportHandler handler = null;
        try {
            handler = new DSToFSExportHandler();
            handler.addNotificationListener(qdListener);
            if ("all".equalsIgnoreCase(exportPropertiesArgument)) {
                handler.open(targetFSPath, true);
                handler.getExportProperties().addRoot(RootArtifact.ROOT);
            } else if (exportPropertiesArgument.endsWith(".xai") || exportPropertiesArgument.endsWith("xml")) {
                handler.open(targetFSPath, true);
                ExportPropertiesArtifact exportProperties = handler.getExportProperties();
                File exportPropertiesFile = new File(exportPropertiesArgument);
                exportProperties.init(exportPropertiesFile);
            } else {
                handler.open(exportPropertiesArgument, false);
            }
            if ("skipcleanup".equalsIgnoreCase(skipCleanupArgument)) {
                skipCleanup = true;
            }
            handler.getExportProperties().setDomain(m_domain);
            handler.getExportProperties().setURL(m_url);
            handler.getExportProperties().setUser(m_user);
            handler.getExportProperties().setPassword(m_password);
            handler.rebuild();
            handler.save();
        }
        catch (Exception e) {
            XQCommandLine.showErrorAndTrace(e);
        }
        finally {
            if (handler != null && !skipCleanup) {
                try {
                    handler.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void exportDirectory() {
        String source = m_arguments[1];
        String target = m_arguments[2];
        String error = null;
        File targetDir = null;
        if (source == null || source.length() == 0) {
            error = "Source directory not specified";
        } else if (target == null || target.length() == 0) {
            error = "Target directory not specified";
        } else {
            targetDir = new File(target);
            if (targetDir.exists() && targetDir.isFile()) {
                error = "Target (" + target + ") is not a directory";
            }
        }
        if (error != null) {
            XQCommandLine.showError(error + ".  Use export directory <source> <target>");
            return;
        }
        XQCommandLine.exportDirectoryContents(source, targetDir);
    }

    private static void exportDirectoryContents(String source, File targetDir) {
        System.out.println("Exporting from Directory Service. Source = " + source);
        try {
            String[] list = m_fs.list(source);
            for (int i = 0; i < list.length; ++i) {
                String sourceItem = XQCommandLine.buildPath(source, "/", list[i]);
                String targetItem = XQCommandLine.buildPath(targetDir.getAbsolutePath(), File.separator, list[i]);
                if (list[i].endsWith("/")) {
                    XQCommandLine.exportDirectoryContents(sourceItem, new File(targetItem));
                    continue;
                }
                if (!targetDir.exists()) {
                    targetDir.mkdirs();
                }
                XQCommandLine.exportComponent(sourceItem, "file", targetItem);
            }
        }
        catch (Exception e) {
            XQCommandLine.showError("Failed to export directory. " + e.getMessage());
        }
    }

    private static String buildPath(String str1, String separator, String str2) {
        if (str1.endsWith(separator)) {
            return str1 + str2;
        }
        return str1 + separator + str2;
    }

    private static void exportBootfile(String name, String filename) {
        try {
            File file = null;
            file = filename == null || filename.length() == 0 ? new File("boot" + name + ".xml") : new File(filename);
            System.out.println("Creating container bootfile...");
            System.out.println("    name = " + name);
            System.out.println("    file = " + file.getAbsolutePath());
            String dump = m_containerUtility.getBootfile(name);
            XQCommandLine.write(file, dump);
        }
        catch (Exception e) {
            XQCommandLine.showError("Error creating container bootfile " + e.getMessage());
        }
    }

    private static void exportComponent(String name, String type, String filename) {
        try {
            if (filename == null || filename.length() == 0) {
                XQCommandLine.showError("File is not specified");
                return;
            }
            File file = new File(filename);
            System.out.println("Exporting from Directory Service...");
            XQCommandLine.printlnDirectoryDetails(file, name, type);
            if ("file".equalsIgnoreCase(type)) {
                String sonicfsName = name;
                if (name.charAt(0) != '/') {
                    sonicfsName = "/Resources/" + name;
                }
                XQCommandLine.write(file, m_fs.getContentBytes(sonicfsName));
            } else {
                XQConfiguration component = (XQConfiguration)m_configManager.lookup(name, XQCommandLine.getCanonicalType(type));
                XQCommandLine.write(file, component.serializeToXML());
            }
        }
        catch (Exception e) {
            XQCommandLine.showError(e);
        }
    }

    private static void write(File file, byte[] data) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        ((OutputStream)out).write(data);
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
    }

    private static void write(File file, String data) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.write(data);
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    public static void add() {
        if (!m_connected) {
            throw MethodError.NOT_CONNECTED;
        }
        String mode = m_arguments[0];
        if (mode == null || mode.length() == 0) {
            XQCommandLine.showError("Mode not specified. Use add < file | license>");
        } else if ("file".equalsIgnoreCase(mode)) {
            XQCommandLine.addFile();
        } else if ("license".equalsIgnoreCase(mode)) {
            XQCommandLine.addLicense();
        } else if ("directory".equalsIgnoreCase(mode)) {
            XQCommandLine.addDirectory();
        } else {
            XQCommandLine.showError("Invalid mode. Use add <file | license>");
        }
    }

    private static void addFile() {
        if (!m_connected) {
            throw MethodError.NOT_CONNECTED;
        }
        String name = m_arguments[1];
        String filename = m_arguments[2];
        String error = null;
        if (name == null || name.length() == 0) {
            XQCommandLine.showError("Name is not specified");
        } else if (filename == null || filename.length() == 0) {
            XQCommandLine.showError("File name is not specified");
        } else {
            error = XQCommandLine.validateName(name);
            if (error != null) {
                XQCommandLine.showError("Name is invalid - " + error);
            } else {
                try {
                    XmlValidator validator;
                    String errors;
                    boolean overwrite = false;
                    String szOver = m_arguments[3];
                    if (OVERRIDE.equalsIgnoreCase(szOver)) {
                        overwrite = true;
                    }
                    File file = new File(filename);
                    String extension = XQCommandLine.getExtension(file.getName());
                    boolean isText = XQCommandLine.isText(extension);
                    if (extension != null && isText && (errors = (validator = XmlValidatorFactory.getXmlValidator((String)extension)).validate(file)) != null) {
                        System.out.println("Error validating file:" + name + " as XML.");
                        System.out.println("Validation Errors: " + errors);
                        return;
                    }
                    XQCommandLine.printData(name, file);
                    System.out.println("    override = " + overwrite);
                    if (!isText) {
                        System.out.println("    binary   = true");
                    }
                    String sonicfsName = name;
                    if (name.charAt(0) != '/') {
                        sonicfsName = "/Resources/" + name;
                    }
                    m_fs.createDirectoryPath(sonicfsName.substring(0, sonicfsName.lastIndexOf(47)));
                    if (overwrite) {
                        m_fs.updateFile(sonicfsName, file, true);
                    } else {
                        m_fs.createFile(sonicfsName, file);
                    }
                }
                catch (SAXException saxe) {
                    XQCommandLine.showError("Error validating file as XML.");
                    String message = saxe.getMessage();
                    if (message != null && message.trim().length() > 0) {
                        System.out.println("Validation Errors: " + message);
                    }
                }
                catch (SonicFSException fse) {
                    String errMsg = fse.getMessage();
                    int idx = errMsg.indexOf("already exists");
                    if (idx > -1) {
                        errMsg = "Unable" + errMsg.substring(idx + "Failed".length(), errMsg.length());
                        System.out.println(errMsg);
                    } else {
                        XQCommandLine.showError(errMsg);
                    }
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        }
    }

    private static void addDirectory() {
        if (!m_connected) {
            throw MethodError.NOT_CONNECTED;
        }
        String name = m_arguments[1];
        String dirname = m_arguments[2];
        String error = null;
        if (name == null || name.length() == 0) {
            XQCommandLine.showError("Name is not specified");
        } else if (dirname == null || dirname.length() == 0) {
            XQCommandLine.showError("Directory name is not specified");
        } else {
            error = XQCommandLine.validateName(name);
            if (error != null) {
                XQCommandLine.showError("Name is invalid - " + error);
            } else {
                try {
                    File dir = new File(dirname);
                    if (!dir.isDirectory()) {
                        XQCommandLine.showError("Error adding directory.");
                        XQCommandLine.showError("Source is not a directory: " + dirname);
                        return;
                    }
                    String sonicfsName = name;
                    if (name.charAt(0) != '/') {
                        sonicfsName = "/Resources/" + name;
                    }
                    XQCommandLine.addDirectory(dir, sonicfsName);
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        }
    }

    private static void addDirectory(File dir, String storePath) {
        File[] files = dir.listFiles();
        try {
            m_fs.createDirectoryPath(storePath);
            for (int i = 0; i < files.length; ++i) {
                XmlValidator validator;
                File file = files[i];
                String filename = storePath + "/" + file.getName();
                if (files[i].isDirectory()) {
                    XQCommandLine.addDirectory(file, filename);
                    continue;
                }
                String extension = XQCommandLine.getExtension(file.getName());
                String errors = null;
                boolean isText = XQCommandLine.isText(extension);
                if (extension != null && isText && (errors = (validator = XmlValidatorFactory.getXmlValidator((String)extension)).validate(file)) != null) {
                    XQCommandLine.showError("Error validating file as XML.");
                    System.out.println("Validation Errors: " + errors);
                }
                if (errors != null) continue;
                XQCommandLine.printData(filename, file);
                if (!isText) {
                    System.out.println("    binary  = true");
                }
                m_fs.updateFile(filename, file, true);
            }
        }
        catch (SAXException saxe) {
            XQCommandLine.showError("Error validating file as XML.");
            String message = saxe.getMessage();
            if (message != null && message.trim().length() > 0) {
                System.out.println("Validation Errors: " + message);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private static void printData(String filename, File file) {
        System.out.println("Adding file into Directory Service...");
        System.out.println("    name     = " + filename);
        System.out.println("    file     = " + file.getAbsolutePath());
    }

    private static boolean checkForMinusArgs() {
        for (int i = 0; i < m_arguments.length; ++i) {
            if (m_arguments[i] == null) {
                return false;
            }
            if (!m_arguments[i].startsWith("-")) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void createmap() {
        IArtifactStorage sourceStore = null;
        try {
            String mapFileName = null;
            String rulesFileName = null;
            if (XQCommandLine.checkForMinusArgs()) {
                CommandLineParser parser = new CommandLineParser();
                if (!parser.parse(m_arguments, 1)) {
                    XQCommandLine.showError(parser.getLastError());
                    return;
                }
                IArtifactStorage[] stores = parser.getStores();
                if (stores.length != 1) {
                    XQCommandLine.showError("Only one store should be specified");
                    return;
                }
                sourceStore = stores[0];
                mapFileName = parser.getMapFile();
                rulesFileName = parser.getRulesFile();
                if (mapFileName == null || mapFileName.length() == 0) {
                    XQCommandLine.showError("Map file is not specified");
                    XQCommandLine.closeZipArchive(sourceStore);
                    return;
                }
            } else {
                String archiveName = m_arguments[0];
                mapFileName = m_arguments[1];
                rulesFileName = m_arguments[2];
                if (archiveName == null || archiveName.length() == 0 || mapFileName == null || mapFileName.length() == 0) {
                    XQCommandLine.showError("Usage: createMap <input archive file> <output map file> [rules file]");
                    return;
                }
                sourceStore = XQCommandLine.createStorage(archiveName);
            }
            File rulesFile = null;
            if (rulesFileName != null) {
                rulesFile = new File(rulesFileName);
            } else {
                String xqHome = System.getProperty("sonicsw.home", null);
                String defaultRulesFilePath = xqHome + "/ESB" + Version.getMajorMinorVersion() + "/deploy/DefaultTailorRules.xml";
                rulesFile = new File(defaultRulesFilePath);
            }
            if (!rulesFile.exists()) {
                XQCommandLine.showError("Rules file '" + rulesFile.getPath() + "' not found");
                XQCommandLine.closeZipArchive(sourceStore);
                return;
            }
            CreateMapAction.createMap(sourceStore, new File(mapFileName), rulesFile);
            XQCommandLine.closeZipArchive(sourceStore);
            return;
        }
        catch (Exception e) {
            XQCommandLine.showError(e);
            return;
        }
        finally {
            XQCommandLine.closeZipArchive(sourceStore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void applymap() {
        IArtifactStorage destStore;
        IArtifactStorage sourceStore;
        block30: {
            block29: {
                block28: {
                    block27: {
                        block26: {
                            sourceStore = null;
                            destStore = null;
                            try {
                                File mapFile;
                                String mapFileName = null;
                                String logFileName = null;
                                if (XQCommandLine.checkForMinusArgs()) {
                                    CommandLineParser parser = new CommandLineParser();
                                    if (!parser.parse(m_arguments, 1)) {
                                        XQCommandLine.showError(parser.getLastError());
                                        return;
                                    }
                                    IArtifactStorage[] stores = parser.getStores();
                                    if (stores.length != 2) {
                                        XQCommandLine.showError("Two stores must be specified");
                                        XQCommandLine.closeZipArchive(sourceStore);
                                        break block26;
                                    }
                                    sourceStore = stores[0];
                                    destStore = stores[1];
                                    mapFileName = parser.getMapFile();
                                    logFileName = parser.getLogFile();
                                } else {
                                    String sourceName = m_arguments[0];
                                    mapFileName = m_arguments[1];
                                    String destName = m_arguments[2];
                                    logFileName = m_arguments[3];
                                    if (sourceName == null || sourceName.length() == 0 || destName == null || destName.length() == 0) {
                                        XQCommandLine.showError("Usage: applyMap <input archive file> <input map file> <output archive file> [log file]");
                                        XQCommandLine.closeZipArchive(sourceStore);
                                        break block27;
                                    }
                                    sourceStore = XQCommandLine.createStorage(sourceName);
                                    destStore = new ZipArtifactStorage();
                                    destStore.addNotificationListener(qdListener);
                                    ((ZipArtifactStorage)destStore).openArchive(destName, true);
                                }
                                if (mapFileName == null || mapFileName.length() == 0) {
                                    XQCommandLine.showError("Map file must be specified");
                                    XQCommandLine.closeZipArchive(sourceStore);
                                    break block28;
                                }
                                if (logFileName == null) {
                                    logFileName = new String("logfile.xml");
                                }
                                if (!(mapFile = new File(mapFileName)).exists()) {
                                    XQCommandLine.showError("Map file '" + mapFile.getName() + "' not found");
                                    XQCommandLine.closeZipArchive(sourceStore);
                                    break block29;
                                }
                                ApplyMapAction.applyMap(sourceStore, destStore, mapFile, new File(logFileName));
                                if (destStore instanceof ZipArtifactStorage) {
                                    ((ZipArtifactStorage)destStore).saveArchive();
                                }
                                XQCommandLine.closeZipArchive(sourceStore);
                                break block30;
                            }
                            catch (Exception e) {
                                XQCommandLine.showError(e);
                                return;
                            }
                        }
                        XQCommandLine.closeZipArchive(destStore);
                        if (sourceStore instanceof DSArtifactStorage) {
                            XQCommandLine.disconnectIfLocal(sourceStore);
                        }
                        if (!(destStore instanceof DSArtifactStorage)) return;
                        XQCommandLine.disconnectIfLocal(destStore);
                        return;
                    }
                    XQCommandLine.closeZipArchive(destStore);
                    if (sourceStore instanceof DSArtifactStorage) {
                        XQCommandLine.disconnectIfLocal(sourceStore);
                    }
                    if (!(destStore instanceof DSArtifactStorage)) return;
                    XQCommandLine.disconnectIfLocal(destStore);
                    return;
                }
                XQCommandLine.closeZipArchive(destStore);
                if (sourceStore instanceof DSArtifactStorage) {
                    XQCommandLine.disconnectIfLocal(sourceStore);
                }
                if (!(destStore instanceof DSArtifactStorage)) return;
                XQCommandLine.disconnectIfLocal(destStore);
                return;
            }
            XQCommandLine.closeZipArchive(destStore);
            if (sourceStore instanceof DSArtifactStorage) {
                XQCommandLine.disconnectIfLocal(sourceStore);
            }
            if (!(destStore instanceof DSArtifactStorage)) return;
            XQCommandLine.disconnectIfLocal(destStore);
            return;
        }
        XQCommandLine.closeZipArchive(destStore);
        if (sourceStore instanceof DSArtifactStorage) {
            XQCommandLine.disconnectIfLocal(sourceStore);
        }
        if (!(destStore instanceof DSArtifactStorage)) return;
        XQCommandLine.disconnectIfLocal(destStore);
        return;
        finally {
            XQCommandLine.closeZipArchive(sourceStore);
            XQCommandLine.closeZipArchive(destStore);
            if (sourceStore instanceof DSArtifactStorage) {
                XQCommandLine.disconnectIfLocal(sourceStore);
            }
            if (destStore instanceof DSArtifactStorage) {
                XQCommandLine.disconnectIfLocal(destStore);
            }
        }
    }

    private static IArtifactStorage createStorage(String sourceName) throws Exception {
        ZipArtifactStorage sourceStore = new ZipArtifactStorage();
        sourceStore.addNotificationListener(qdListener);
        sourceStore.openArchive(sourceName, false);
        return sourceStore;
    }

    private static void disconnectIfLocal(IArtifactStorage destStore) {
        try {
            ((DSArtifactStorage)destStore).disconnectIfLocal();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void closeZipArchive(IArtifactStorage sourceStore) {
        if (sourceStore instanceof ZipArtifactStorage) {
            try {
                ((ZipArtifactStorage)sourceStore).closeArchive();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void diff() {
        XQCommandLine.doDiff(new DiffAction());
    }

    public static void impact() {
        XQCommandLine.doDiff(new ImpactAnalysisAction());
    }

    public static void merge() {
        XQCommandLine.doDiff(new MergeAction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void doDiff(IArtifactDiff diffTool) {
        IArtifactStorage[] stores;
        CommandLineParser parser;
        block15: {
            parser = new CommandLineParser();
            try {
                boolean parseSuccessful = parser.parse(m_arguments, 2);
                if (!parseSuccessful) {
                    XQCommandLine.showError(parser.getLastError());
                    return;
                }
                stores = parser.getStores();
                if (stores.length == 2) break block15;
            }
            catch (Exception e) {
                XQCommandLine.showError(e);
                return;
            }
            if (!(diffTool instanceof IArtifactMerge) || stores.length != 3) {
                XQCommandLine.showError("Unexpected number of stores: " + stores.length + " stores were specified");
                return;
            }
        }
        try {
            diffTool.setVerbose(parser.getVerbose());
            String outFilename = parser.getOutputFile();
            if (outFilename == null) {
                outFilename = diffTool.getDefaultOutputFilename();
            }
            File diffFile = new File(outFilename);
            if (parser.getTraversalMode() != null) {
                diffTool.setTraversalMode(IArtifactDiff.TraversalMode.getTraversalMode(parser.getTraversalMode()));
            }
            if (stores.length == 2) {
                XQCommandLine.runRequest(diffTool, stores[0], stores[1], parser);
            } else {
                XQCommandLine.runRequest((IArtifactMerge)diffTool, stores[0], stores[1], stores[2], parser);
            }
            diffTool.generateReport(diffFile);
            System.out.println("See " + diffFile.getAbsolutePath() + " for results");
            return;
        }
        catch (Exception e) {
            XQCommandLine.showError(e);
            return;
        }
        finally {
            XQCommandLine.parserCloseStores(parser);
        }
    }

    protected static void runRequest(IArtifactDiff diffTool, IArtifactStorage soureStore, IArtifactStorage targetStore, CommandLineParser parser) throws Exception {
        diffTool.setHeader(parser.getStoreName(soureStore), parser.getStoreName(targetStore));
        diffTool.run(soureStore, targetStore);
    }

    protected static void runRequest(IArtifactMerge mergeTool, IArtifactStorage soureStore, IArtifactStorage targetStore, IArtifactStorage destinationStore, CommandLineParser parser) throws Exception {
        mergeTool.setHeader(parser.getStoreName(soureStore), parser.getStoreName(targetStore), parser.getStoreName(destinationStore));
        mergeTool.run(soureStore, targetStore, destinationStore);
    }

    public static void mqdepends() {
        XQCommandLine.doDepends(new DependencyAction());
    }

    public static void mqrevdepends() {
        XQCommandLine.doDepends(new RevDependencyAction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void doDepends(IArtifactDepends dependsTool) {
        CommandLineParser parser;
        block12: {
            Hashtable includeArtifacts;
            parser = new CommandLineParser();
            try {
                if (!parser.parse(m_arguments, 1)) {
                    XQCommandLine.showError(parser.getLastError());
                    return;
                }
                includeArtifacts = parser.getArtifactFilter();
                if (includeArtifacts == null) break block12;
            }
            catch (Exception e) {
                XQCommandLine.showError(e);
                return;
            }
            dependsTool.setArtifactList(includeArtifacts);
        }
        IArtifactStorage[] stores = parser.getStores();
        String outFilename = parser.getOutputFile();
        if (outFilename == null) {
            outFilename = dependsTool.getDefaultOutputFilename();
        }
        if (stores.length != 1) {
            XQCommandLine.showError("Expected one store but " + stores.length + " were specified");
            return;
        }
        try {
            dependsTool.setHeader(parser.getStoreName(stores[0]));
            dependsTool.run(stores[0]);
            File dependsFile = new File(outFilename);
            dependsTool.generateReport(dependsFile);
            System.out.println("See " + dependsFile.getAbsolutePath() + " for results");
            return;
        }
        catch (Exception e) {
            XQCommandLine.showError(e);
            return;
        }
        finally {
            XQCommandLine.parserCloseStores(parser);
        }
    }

    private static void parserCloseStores(CommandLineParser parser) {
        try {
            parser.closeStores();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getExtension(String filename) {
        int index = filename.lastIndexOf(".");
        if (index == -1) {
            return null;
        }
        return filename.substring(index + 1);
    }

    private static boolean isText(String ext) {
        if (ext == null) {
            return true;
        }
        return BINARY_EXTS.indexOf(BINARY_EXT_SEP + ext.toLowerCase() + BINARY_EXT_SEP) < 0;
    }

    private static void addLicense() {
        block14: {
            if (!m_connected) {
                throw MethodError.NOT_CONNECTED;
            }
            String container = m_arguments[1];
            String controlCode = m_arguments[2];
            String version = null;
            if (m_arguments.length > 3) {
                version = m_arguments[3];
            }
            if (container == null || container.length() == 0) {
                XQCommandLine.showError("Container is not specified");
            } else if (controlCode == null || controlCode.length() == 0) {
                XQCommandLine.showError("Control code is not specified");
            } else if (version != null && new StringTokenizer(version, ".").countTokens() > 2) {
                XQCommandLine.showError("Version parameter only supports \"major.minor\" format e.g. 5.0");
            } else if ("container".equalsIgnoreCase(container)) {
                System.out.println("Adding license into Directory Service...");
                System.out.println("    control code = " + controlCode);
                if (version == null) {
                    version = Version.getMajorMinorVersion();
                }
                try {
                    XQLicenseHelper.checkLicense((String)controlCode, (String)version);
                    XQLicenseCodeConfig component = new XQLicenseCodeConfig((IXQConfigManager)m_configManager);
                    component.setControlCode(controlCode, version);
                    if (version.startsWith("5.0")) {
                        XQCommandLine.bindComponent("license/sonicxq/container", (IConfiguration)component, !component.isNewElement());
                        break block14;
                    }
                    XQCommandLine.bindComponent("license/sonicxq/container/" + version, (IConfiguration)component, !component.isNewElement());
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            } else {
                XQCommandLine.showError("Container must be specified");
            }
        }
    }

    public static void set() {
        if (!m_connected) {
            throw MethodError.NOT_CONNECTED;
        }
        String type = m_arguments[0];
        String key = m_arguments[1];
        String value = m_arguments[2];
        if (type == null || type.length() == 0 || !"global".equalsIgnoreCase(type)) {
            XQCommandLine.showError("Type is not specified or is not = global.");
        } else if (key == null || key.length() == 0) {
            XQCommandLine.showError("Key is not specified.");
        } else if (value == null || value.length() == 0) {
            XQCommandLine.showError("Value is not specified.");
        } else {
            try {
                XQGlobalConfig config = null;
                boolean newConfig = false;
                try {
                    config = m_configManager.lookupGlobalConfig();
                }
                catch (Exception e) {
                    config = new XQGlobalConfig((IXQConfigManager)m_configManager);
                    config.createElement("settings");
                    newConfig = true;
                }
                boolean valid = false;
                try {
                    Method[] methods = XQGlobalConfig.class.getMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        Class<?>[] params;
                        String attrName;
                        int setIndex = methods[i].getName().indexOf("set");
                        if (setIndex != 0 || !(attrName = methods[i].getName().substring(3)).equalsIgnoreCase(key) || (params = methods[i].getParameterTypes()) == null || params.length <= 0) continue;
                        String accessorPrefix = "get";
                        Object[] inputParams = new Object[1];
                        if ("boolean".equals(params[0].getName())) {
                            inputParams[0] = Boolean.valueOf(value);
                            accessorPrefix = "is";
                        } else if ("int".equals(params[0].getName())) {
                            inputParams[0] = Integer.valueOf(value);
                        } else {
                            inputParams = new Object[]{value};
                        }
                        System.out.println("Current values:");
                        Method accessorMethod = XQGlobalConfig.class.getDeclaredMethod(accessorPrefix + key, new Class[0]);
                        System.out.println("    " + key + " = " + accessorMethod.invoke((Object)config, new Object[0]));
                        System.out.println("Setting global value.. " + key + " = " + value);
                        methods[i].invoke((Object)config, inputParams);
                        valid = true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (valid) {
                    System.out.println("Successfully set the global value!");
                } else {
                    System.out.println("Key or value is not valid");
                }
                XQCommandLine.bindComponent(null, (IConfiguration)config, !newConfig);
            }
            catch (Exception e) {
                XQCommandLine.showError(e);
            }
        }
    }

    public static void delete() {
        if (!m_connected) {
            throw MethodError.NOT_CONNECTED;
        }
        String type = m_arguments[0];
        String name = m_arguments[1];
        String error = null;
        if (type == null || type.length() == 0) {
            XQCommandLine.showError("Type is not specified");
        } else if (name == null || name.length() == 0) {
            XQCommandLine.showError("Name is not specified");
        } else {
            error = XQCommandLine.validateName(name);
            if (error != null) {
                XQCommandLine.showError("Name is invalid - " + error);
            } else {
                System.out.println("Deleting from Directory Service...");
                System.out.println("    type = " + type);
                System.out.println("    name = " + name);
                try {
                    if ("file".equalsIgnoreCase(type)) {
                        String sonicfsName = name;
                        if (name.charAt(0) != '/') {
                            sonicfsName = "/Resources/" + name;
                        }
                        m_fs.deleteFile(sonicfsName);
                    } else if ("directory".equalsIgnoreCase(type)) {
                        String sonicfsName = name;
                        if (name.charAt(0) != '/') {
                            sonicfsName = "/Resources/" + name;
                        }
                        m_fs.deleteDirectoryPath(sonicfsName);
                    } else if (XQCommandLine.isValidType(type)) {
                        type = XQCommandLine.getCanonicalType(type);
                        m_configManager.deleteElement(name, type);
                    } else {
                        XQCommandLine.showError("'" + type + "' is not a valid type");
                    }
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        }
    }

    public static void dump() {
        if (!m_connected) {
            throw MethodError.NOT_CONNECTED;
        }
        try {
            String type = m_arguments[0];
            String name = m_arguments[1];
            String filename = m_arguments[2];
            String error = null;
            if (type == null || type.length() == 0) {
                type = "";
            }
            if (name == null || name.length() == 0) {
                name = "";
            } else {
                error = XQCommandLine.validateName(name);
                if (error != null) {
                    XQCommandLine.throwError("Name is invalid - " + error);
                }
            }
            File file = null;
            file = filename == null || filename.length() == 0 ? new File("dump.txt") : new File(filename);
            System.out.println("Dump Directory Service entry...");
            XQCommandLine.printlnDirectoryDetails(file, name, type);
            IDirectoryAdminService dsProxy = m_configManager.getDirectoryService();
            String dump = null;
            String fullname = XQConfigHelper.buildPath((String)name, (String)type);
            if ("".equals(fullname)) {
                fullname = "/";
            }
            try {
                dump = dsProxy.exportDirectoryToXML(fullname);
            }
            catch (Exception e) {
                dump = dsProxy.exportElementToXML(fullname);
            }
            FileWriter writer = new FileWriter(file);
            writer.write(dump);
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            XQCommandLine.showError("Error dumping Directory Service entry " + e.getMessage());
        }
    }

    private static void printlnDirectoryDetails(File file, String name, String type) {
        System.out.println("    type = " + type);
        System.out.println("    name = " + name);
        System.out.println("    file = " + file.getAbsolutePath());
    }

    public static void props() {
        if (!m_connected) {
            throw MethodError.NOT_CONNECTED;
        }
        String cmd = m_arguments[0];
        String file = m_arguments[1];
        String key = m_arguments[2];
        if (cmd == null || cmd.length() == 0) {
            XQCommandLine.throwError("Command is not specified");
        }
        if (file == null || file.length() == 0) {
            XQCommandLine.throwError("File is not specified");
        }
        Properties p = new Properties();
        try {
            String content = m_fs.getContent(file);
            if (content != null && content.length() > 0) {
                p.load(new ByteArrayInputStream(content.getBytes()));
            }
        }
        catch (Exception content) {
            // empty catch block
        }
        boolean writeBack = false;
        if ("set".equalsIgnoreCase(cmd)) {
            int index;
            if (!XQCommandLine.isDefined(key)) {
                XQCommandLine.throwError("Key is not specified");
            }
            if ((index = key.indexOf(61)) == -1) {
                XQCommandLine.throwError("<key>=<value> is not specified");
            }
            String string = key.substring(0, index);
            String realVal = key.substring(index + 1);
            p.put(string, realVal);
            writeBack = true;
        } else if ("delete".equalsIgnoreCase(cmd)) {
            if (!XQCommandLine.isDefined(key)) {
                XQCommandLine.throwError("Key is not specified");
            }
            if (p.containsKey(key)) {
                p.remove(key);
                writeBack = true;
            } else {
                System.out.println("Property key='" + key + "' is not defined in the properties file");
            }
        } else if ("get".equalsIgnoreCase(cmd)) {
            if (XQCommandLine.isDefined(key)) {
                String value = (String)p.get(key);
                if (XQCommandLine.isDefined(value)) {
                    System.out.println("Property key='" + key + "' value='" + value + "'");
                } else {
                    System.out.println("Property key='" + key + "' is not defined");
                }
            } else {
                System.out.println("Properties...");
                for (String string : p.keySet()) {
                    System.out.println("    key='" + string + "' value='" + p.get(string) + "'");
                }
            }
        } else if ("merge".equalsIgnoreCase(cmd)) {
            if (!XQCommandLine.isDefined(key)) {
                XQCommandLine.throwError("local file isn't specified");
            }
            Properties localProp = new Properties();
            try {
                localProp.load(new FileInputStream(key));
            }
            catch (Exception exception) {
                XQCommandLine.throwError("Failed to read local properties file: " + exception.getMessage());
            }
            p.putAll((Map<?, ?>)localProp);
            writeBack = true;
        } else {
            XQCommandLine.throwError("props command only supports set, get, delete and merge operations");
        }
        if (writeBack) {
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                p.store(os, null);
                m_fs.updateFile(file, os.toByteArray(), true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void esbcontainer() {
        String subCommand = m_arguments[0];
        String containerName = m_arguments[1];
        String mfContainerName = m_arguments[2];
        try {
            if (m_esbContainerCommands == null) {
                throw new IllegalArgumentException("You must be connected to the Domain first.");
            }
            if (containerName == null) {
                throw new IllegalArgumentException("The container is required");
            }
            ESBContainerInfo containerInfo = new ESBContainerInfo(mfContainerName, containerName, m_esbContainerCommands.getConnectionDetails());
            if ("start".equals(subCommand)) {
                m_esbContainerCommands.start(containerInfo);
            } else if ("abort".equals(subCommand)) {
                m_esbContainerCommands.abort(containerInfo);
            } else if ("start_mf".equals(subCommand)) {
                containerInfo.setMFContainerLocation(containerName);
                m_esbContainerCommands.startMFContainer(containerInfo);
            } else if ("shutdown_mf".equals(subCommand)) {
                containerInfo.setMFContainerLocation(containerName);
                m_esbContainerCommands.shutdownMFContainer(containerInfo);
            } else {
                XQCommandLine.showError("Sub command not recognized, type 'help' for hints.");
            }
        }
        catch (Exception e) {
            XQCommandLine.showError(e);
        }
    }

    private static boolean bindComponent(String typeOverride, IConfiguration component, boolean overwrite) throws XQConfigurationException {
        String type;
        if (component.isNewElement()) {
            component.writeToDS();
        }
        String string = type = typeOverride != null ? typeOverride : component.getType();
        if (overwrite) {
            m_configManager.writeComponentToDS(component, component.getName(), type);
            return true;
        }
        if (!m_configManager.doesElementExist(component.getName(), type)) {
            m_configManager.writeComponentToDS(component, component.getName(), type);
            return true;
        }
        return false;
    }

    private static boolean isDefined(String val) {
        return val != null && val.length() > 0;
    }

    private static void prompt() {
        System.out.print(m_promptWord);
        System.out.flush();
    }

    private static String validateName(String name) {
        if (name == null || name.length() <= 0 || name.length() > 128) {
            return "Length is not valid";
        }
        if (name.indexOf("$") == 0) {
            return "Cannot contain '$'";
        }
        if (name.indexOf("\\") >= 0) {
            return "Cannot contain '\\'";
        }
        if (name.indexOf("::") >= 0) {
            return "Cannot contain '::'";
        }
        if (name.indexOf(".*.") >= 0) {
            return "Cannot contain '.*.'";
        }
        if (name.indexOf(".#.") >= 0) {
            return "Cannot contain '.#.'";
        }
        if (name.indexOf("<") >= 0) {
            return "Cannot contain '<'";
        }
        if (name.indexOf(">") >= 0) {
            return "Cannot contain '>'";
        }
        if (name.indexOf("&") >= 0) {
            return "Cannot contain '&'";
        }
        return null;
    }

    public static void help() {
        System.out.println(SCRIPT_NAME + " available commands :");
        System.out.println("");
        System.out.println("  Basic Commands:");
        System.out.println("    connect <domain> <url> [username] [password] [managementNode]");
        System.out.println("    disconnect");
        System.out.println("    exit | bye");
        System.out.println("    help");
        System.out.println("");
        System.out.println("  SonicFS Maintenance Commands:");
        System.out.println("    add file <name> <filename> [override]");
        System.out.println("    add directory <ds directory> <source-directory>");
        System.out.println("    delete file <name>");
        System.out.println("    delete directory <directory>");
        System.out.println("    export file <name> <filename>");
        System.out.println("    export directory <ds-directory> <target-directory>");
        System.out.println("");
        System.out.println("  ESB Type Maintenance Commands:");
        System.out.println("    add license container <control-code> [version]");
        System.out.println("    container list");
        System.out.println("    container [suspend|resume|reload] <container-name> <component-name>");
        System.out.println("    container [shutdown|status] <container-name>");
        System.out.println("    dump [type] [name] [filename]");
        System.out.println("    delete <type> <name>");
        System.out.println("    import <type> <filename> [override]");
        System.out.println("    export <type> <name> <filename>");
        System.out.println("    export bootfile <container-config-name> [filename]");
        System.out.println("    export license container [version]");
        System.out.println("    set global <key> <value>");
        System.out.println("    list [type]");
        System.out.println("");
        System.out.println("  Deployment Tool Commands:");
        System.out.println("    Where <<type>> is one of:");
        System.out.println("        -fs <file-path>");
        System.out.println("        -xar <archive-path>");
        System.out.println("        -ds <domain> <url> [username] [password]");
        System.out.println("    export archive <target-archive> [source-archive | export-prop-file | all]");
        System.out.println("    import archive <source-archive> [import-prop-file | override]");
        System.out.println("    export fs <target-path> [source-path | export-prop-file | all]");
        System.out.println("    import fs <source-path> [import-prop-file | override]");
        System.out.println("    createMap <input-archive> <map-file> [rules-file]");
        System.out.println("    applyMap <input-archive> <map-file> <output-archive> [log-file]");
        System.out.println("    createMap <<input-store>> -map <map-file> [-rules <rules-file>]");
        System.out.println("    applyMap <<input-store>> <<output-store>> -map <map-file> [-log <log-file>]");
        System.out.println("    diff <<source-store>> <<target-store>> [-out output-file(.xml)] [-v]");
        System.out.println("    impact <<source-store>> <<target-store>> [-out output-file(.xml)] [-v]");
        System.out.println("    merge <<source-store>> <<target-store>> [<<destination-store>>]");
        System.out.println("        [-out output-file(.xml)] [-v]");
        System.out.println("    mqdepends <<source-store>> [-out output-file(.xml)]");
        System.out.println("        [-include <artifact-list> | -includeFile <artifact-file>]");
        System.out.println("    mqrevdepends <<source-store>> [-out output-file(.xml)]");
        System.out.println("        [-include <artifact-list> | -includeFile <artifact-file>]");
        System.out.println("");
        System.out.println("  ESB Container commands:");
        System.out.println("    Notes:");
        System.out.println("        'mf_container_name' In case the MF and ESB container names are different");
        System.out.println("        'mf_container_path' The DS path of the MF Container i.e. /Containers/dev_ESBCore,");
        System.out.println("        use full path if container is not in /Containers/, typing just the container name will");
        System.out.println("        assume the container is inside /Containers/");
        System.out.println("    esbcontainer start <container_name> [<mf_container_name>]");
        System.out.println("    esbcontainer abort <container_name> [<mf_container_name>]");
        System.out.println("    esbcontainer start_mf <mf_container_path>");
        System.out.println("    esbcontainer shutdown_mf <mf_container_path>");
    }

    public static void main(String[] argv) {
        XQCommandLine command = new XQCommandLine();
        int argc = argv.length;
        while (argc-- > 0) {
            if (!argv[argc].startsWith("-s")) continue;
            try {
                command.getCommand(new BufferedReader(new InputStreamReader(new FileInputStream(argv[argc + 1]))));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        command.getCommand();
    }

    static {
        SCRIPT_NAME = "ESBAdmin";
        m_promptWord = SCRIPT_NAME + "> ";
        m_configManager = null;
        m_connected = false;
        BINARY_EXTS = BINARY_EXT_SEP + System.getProperty("com.sonicsw.xq.admin.binaryexts", "bpv,gif,jpg,bmp") + BINARY_EXT_SEP;
        m_url = null;
        m_user = null;
        m_password = null;
        m_domain = DEFAULT_DOMAIN;
        qdListener = new QuickAndDirtyNotificationListener();
    }

    public static class MethodError
    extends Error {
        public static final MethodError NOT_CONNECTED = new MethodError("Not Connected");

        public MethodError(String error) {
            super(error);
        }
    }

    private static class QuickAndDirtyNotificationListener
    implements IArtifactNotificationListener {
        QuickAndDirtyNotificationListener() {
        }

        @Override
        public void notifyMessage(IArtifactNotificationEvent event) {
            if (event.getType() == 4) {
                XQCommandLine.showError(event.getSource() + " " + event.getMessage());
            } else {
                System.out.println(event.getSource() + " " + event.getMessage());
            }
        }
    }
}

