/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.tools.install.config;

import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.mx.config.ConfigServerUtility;
import com.sonicsw.mx.config.util.SonicFSFileSystem;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class SonicFSImport {
    public static boolean m_debug;
    private String m_url;
    private String m_domain;
    private String m_user;
    private String m_password;
    private String m_directory;
    private String m_targetDirectory;
    private List m_regExpExclusionList = new ArrayList();
    private List m_regExpInclusionList = new ArrayList();

    public void debug(String s) {
        if (m_debug) {
            System.out.println(s);
        }
    }

    public SonicFSImport(String[] args) {
        try {
            this.parseArgs(args);
            this.importSonicFSFiles();
            System.out.println("*success*");
        }
        catch (MgmtException e) {
            e.printStackTrace();
            System.out.println("*error*");
            System.exit(-1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("*error*");
            System.exit(-2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importSonicFSFiles() throws Exception {
        File directory = new File(this.m_directory);
        if (!directory.exists()) {
            System.out.println("The input directory: " + this.m_directory + " does not exist.");
            return;
        }
        if (!directory.isDirectory()) {
            throw new Exception("The target: " + this.m_directory + " is not a directory");
        }
        String[] list = directory.list(new RegExpFileNameFilter());
        if (list != null && list.length > 0) {
            ConfigServerUtility csu = new ConfigServerUtility();
            try {
                csu.connect(this.m_domain, this.m_url, this.m_user, this.m_password, true);
                SonicFSFileSystem fs = new SonicFSFileSystem(csu.getDirectoryService(), this.m_user);
                for (int count = 0; count < list.length; ++count) {
                    fs.createDirectoryPath(this.m_targetDirectory);
                    fs.updateFile(this.m_targetDirectory + '/' + list[count], new File(this.m_directory + File.separator + list[count]), true);
                }
            }
            finally {
                csu.disconnect();
            }
        }
    }

    private void parseArgs(String[] args) throws Exception {
        String debug = null;
        String exclusionRegExps = null;
        String inclusionRegExps = null;
        for (int i = 0; i < args.length; ++i) {
            if ("-url".equals(args[i])) {
                this.m_url = args[++i];
                continue;
            }
            if ("-domain".equals(args[i])) {
                this.m_domain = args[++i];
                continue;
            }
            if ("-user".equals(args[i])) {
                this.m_user = args[++i];
                continue;
            }
            if ("-password".equals(args[i])) {
                this.m_password = args[++i];
                continue;
            }
            if ("-debug".equals(args[i])) {
                debug = args[++i];
                continue;
            }
            if ("-sourceDir".equals(args[i])) {
                this.m_directory = args[++i];
                continue;
            }
            if ("-targetDir".equals(args[i])) {
                this.m_targetDirectory = args[++i];
                continue;
            }
            if ("-exclusionRegExps".equals(args[i])) {
                exclusionRegExps = args[++i];
                continue;
            }
            if (!"-inclusionRegExps".equals(args[i])) continue;
            inclusionRegExps = args[++i];
        }
        if (debug != null) {
            boolean bl = m_debug = "true".equals(debug.toLowerCase());
        }
        if (this.m_url == null || this.m_domain == null) {
            throw new Exception("missing -url or -domain");
        }
        if (this.m_directory == null || this.m_targetDirectory == null) {
            throw new Exception("missing -directory or -targetDirectory");
        }
        if (exclusionRegExps != null) {
            this.m_regExpExclusionList = this.parseRegExps(exclusionRegExps);
        }
        if (inclusionRegExps != null) {
            this.m_regExpInclusionList = this.parseRegExps(inclusionRegExps);
        }
    }

    private List parseRegExps(String regExps) {
        ArrayList<String> result = new ArrayList<String>();
        if (regExps != null && regExps.length() > 0) {
            StringTokenizer st = new StringTokenizer(regExps, ";");
            while (st.hasMoreTokens()) {
                String regExp = (String)st.nextElement();
                result.add(regExp);
            }
        }
        return result;
    }

    public static void main(String[] args) {
        new SonicFSImport(args);
        System.exit(0);
    }

    private class RegExpFileNameFilter
    implements FilenameFilter {
        private RegExpFileNameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            File actualFile = new File(dir.getAbsolutePath() + File.separator + name);
            if (!actualFile.exists()) {
                return false;
            }
            if (".".equals(name) || "..".equals(name)) {
                return false;
            }
            if (actualFile.isDirectory()) {
                return false;
            }
            for (String regExp : SonicFSImport.this.m_regExpExclusionList) {
                if (!name.matches(regExp)) continue;
                return false;
            }
            if (SonicFSImport.this.m_regExpInclusionList.size() > 0) {
                for (String regExp : SonicFSImport.this.m_regExpInclusionList) {
                    if (!name.matches(regExp)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
    }
}

