/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.envelope;

import com.sonicsw.esb.visitor.ESBVisitor;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQEndpoint;
import com.sonicsw.xq.XQEndpointCreationException;
import com.sonicsw.xq.XQHeader;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xq.XQProcessAddress;
import com.sonicsw.xq.connector.jms.JMSEndpoint;
import com.sonicsw.xqimpl.config.XQConfigManager;
import com.sonicsw.xqimpl.config.XQEndpointConfig;
import com.sonicsw.xqimpl.config.XQGlobalConfig;
import com.sonicsw.xqimpl.config.XQProcessConfig;
import com.sonicsw.xqimpl.config.XQServiceConfig;
import com.sonicsw.xqimpl.endpoint.container.IEndpointRegistry;
import com.sonicsw.xqimpl.envelope.IEndpointHelper;
import com.sonicsw.xqimpl.envelope.IXQAddressImpl;
import com.sonicsw.xqimpl.envelope.StandaloneEndpointHelper;
import com.sonicsw.xqimpl.envelope.XQAddressFactoryImpl;
import com.sonicsw.xqimpl.envelope.XQAddressImpl;
import com.sonicsw.xqimpl.envelope.XQContainerEndpointHelper;
import com.sonicsw.xqimpl.envelope.XQPartImpl;
import com.sonicsw.xqimpl.envelope.XQProcessAddressImpl;
import com.sonicsw.xqimpl.envelope.XQURLAddressImpl;
import com.sonicsw.xqimpl.service.XQMessageInternal;
import com.sonicsw.xqimpl.util.DOMUtils;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;
import net.sf.saxon.om.NodeInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import progress.message.jclient.DestinationFactory;

public class XQMessageImpl
implements XQMessageInternal {
    private static final long serialVersionUID = -8193394192000116579L;
    private static final XQLog systemLog = XQLogImpl.getInstance();
    public static final String ESB_REPLY_TO = "{http://www.sonicsw.com/esb}ReplyTo";
    public static final String ESB_REPLY_TO_NEW = "SonicESBReplyTo";
    public static boolean USE_NEW_REPLYTO = !XQMessageImpl.isLegacyReplyToEnabled();
    public static final String ESB_CORR_ID = "{http://www.sonicsw.com/esb}CorrelationId";
    public static final String INCOMING_JMS_PRIORITY_PROPERTY = "SonicESB.JMSPriority.incoming";
    public static final String OUTGOING_DRA_ROUTING_PREFIX = "SonicESB.DRARouting.prefix";
    private static final String HEADER_JMS_PRIORITY = "JMSPriority";
    private static final String HEADER_JMS_CORRELATION_ID = "JMSCorrelationID";
    private static final String HEADER_JMS_REPLY_TO = "JMSReplyTo";
    private static final String HEADER_JMS_DESTINATION = "JMSDestination";
    private static final String SONIC_ESB_TEMPORARY_QUEUE_SUBSTRING = ".TemporaryQueues.";
    private HashMap<String, Object> m_headers = new HashMap();
    private ArrayList<XQPartImpl> m_parts = new ArrayList();
    private XQAddress m_replyTo;
    private String m_source;
    private transient HashMap<String, Object> m_sidebandProperties;
    private transient ESBVisitor m_visitor;
    private transient IEndpointRegistry m_endpointRegistry;
    private transient IEndpointHelper m_endpointHelper;
    private static final byte JMS_NULL = 0;
    private static final byte JMS_TOPIC = 1;
    private static final byte JMS_QUEUE = 2;

    private static boolean isLegacyReplyToEnabled() {
        boolean result = true;
        XQGlobalConfig globalCfg = XQGlobalConfig.getGlobalConfig();
        if (globalCfg != null) {
            result = globalCfg.isLegacyReplyToHeaderModeEnabled();
        }
        return result;
    }

    public XQMessageImpl(String source) {
        this(source, false);
    }

    public XQMessageImpl(String source, boolean outsideContainer) {
        this.m_source = source;
        this.m_endpointHelper = outsideContainer ? new StandaloneEndpointHelper() : new XQContainerEndpointHelper();
        this.m_endpointRegistry = this.m_endpointHelper.getEndpointManagerInstance();
    }

    public XQMessageImpl() {
        this(false);
    }

    public XQMessageImpl(boolean outsideContainer) {
        this.m_headers.put("JMSDeliveryMode", 1);
        this.m_headers.put("JMSMessageID", "ID:0:0:0");
        this.m_headers.put("JMSTimestamp", 0L);
        this.m_headers.put("JMSRedelivered", Boolean.FALSE);
        this.m_headers.put("JMSExpiration", 0L);
        this.m_headers.put(HEADER_JMS_PRIORITY, 4);
        this.addSidebandProperty(INCOMING_JMS_PRIORITY_PROPERTY, 4);
        this.m_endpointHelper = outsideContainer ? new StandaloneEndpointHelper() : new XQContainerEndpointHelper();
        this.m_endpointRegistry = this.m_endpointHelper.getEndpointManagerInstance();
    }

    public final void addSidebandProperty(String name, Object value) {
        if (this.m_sidebandProperties == null) {
            this.m_sidebandProperties = new HashMap();
        }
        this.m_sidebandProperties.put(name, value);
    }

    public NodeInfo getPartAsNodeInfo(String cid, boolean validate) throws XQMessageException {
        XQPartImpl part = (XQPartImpl)this.getPart(cid);
        return part.getAsNodeInfo();
    }

    public NodeInfo getPartAsNodeInfo(int index, boolean validate) throws XQMessageException {
        XQPartImpl part = (XQPartImpl)this.getPart(index);
        return part.getAsNodeInfo();
    }

    public IEndpointRegistry getEndpointRegistry() {
        return this.m_endpointRegistry;
    }

    public HashMap<String, Object> getSidebandProperties() {
        return this.m_sidebandProperties;
    }

    public Object getSidebandProperty(String name) {
        if (this.m_sidebandProperties != null) {
            return this.m_sidebandProperties.get(name);
        }
        return null;
    }

    public ESBVisitor getVisitor() {
        return this.m_visitor;
    }

    public Object clone() {
        try {
            XQMessageImpl clone = (XQMessageImpl)super.clone();
            clone.m_headers = (HashMap)this.m_headers.clone();
            clone.m_parts = new ArrayList(this.m_parts.size());
            for (XQPartImpl part : this.m_parts) {
                clone.m_parts.add((XQPartImpl)part.clone());
            }
            if (this.m_sidebandProperties != null) {
                clone.m_sidebandProperties = (HashMap)this.m_sidebandProperties.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Object protectedClone() {
        return this.clone();
    }

    public Object removeSidebandProperty(String name) {
        if (this.m_sidebandProperties != null) {
            return this.m_sidebandProperties.remove(name);
        }
        return null;
    }

    public void setEndpointRegistry(IEndpointRegistry endpointRegistry) {
        this.m_endpointRegistry = endpointRegistry;
    }

    public void setSidebandProperties(HashMap<String, Object> properties) {
        this.m_sidebandProperties = properties;
    }

    public void setVisitor(ESBVisitor visitor) {
        this.m_visitor = visitor;
    }

    public void setupSourceEndpoint(IEndpointRegistry reg) {
        try {
            if (this.m_source != null) {
                this.m_endpointHelper.registerEndpoint(reg, "ESB.source.endpoint", reg.getEndpoint(this.m_source));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setupReplyTo(IEndpointRegistry reg) {
        try {
            if (this.m_replyTo != null) {
                return;
            }
            String replyToProperty = this.getStringHeader(ESB_REPLY_TO);
            if (null == replyToProperty) {
                replyToProperty = this.getStringHeader(ESB_REPLY_TO_NEW);
            }
            this.m_replyTo = this.parseReplyToProperty(replyToProperty);
            if (this.m_replyTo != null) {
                return;
            }
            Destination destination = (Destination)this.getHeaderValue(HEADER_JMS_REPLY_TO);
            if (destination != null && this.m_source != null) {
                XQEndpointConfig sourceEndpointConfig = ((JMSEndpoint)reg.getEndpoint(this.m_source)).getConfig();
                this.m_replyTo = this.m_endpointHelper.createReplyToInvocationEndpointAddress(sourceEndpointConfig, destination, reg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private XQAddress parseReplyToProperty(String replyToPropertyValue) throws XQMessageException {
        if (replyToPropertyValue == null) {
            return null;
        }
        if (replyToPropertyValue.startsWith("PROCESS")) {
            String processName = null;
            String stepName = null;
            StringTokenizer strTok = new StringTokenizer(replyToPropertyValue, ":");
            if (strTok.hasMoreTokens()) {
                strTok.nextToken();
                if (strTok.hasMoreTokens()) {
                    processName = strTok.nextToken();
                }
                while (strTok.hasMoreTokens()) {
                    stepName = strTok.nextToken();
                }
            }
            if (stepName != null && processName != null) {
                return this.createProcessAddress(processName, stepName);
            }
            if (processName != null) {
                return new XQAddressImpl(processName, 2);
            }
        } else {
            if (replyToPropertyValue.startsWith("SERVICE")) {
                return new XQAddressImpl(replyToPropertyValue.substring(replyToPropertyValue.indexOf(":") + 1), 1);
            }
            if (replyToPropertyValue.startsWith("ENDPOINT") && !this.isTemporaryReplyTo(replyToPropertyValue)) {
                try {
                    XQEndpoint endpoint = this.m_endpointRegistry.getEndpoint(replyToPropertyValue.substring(replyToPropertyValue.indexOf(":") + 1));
                    if (endpoint != null) {
                        return new XQAddressImpl(replyToPropertyValue.substring(replyToPropertyValue.indexOf(":") + 1), 0);
                    }
                }
                catch (Exception endpoint) {}
            } else if (replyToPropertyValue.startsWith("ADDRESS_STRING_URL")) {
                try {
                    String url = replyToPropertyValue.substring(replyToPropertyValue.indexOf(":") + 1);
                    if (this.m_source != null) {
                        return new XQURLAddressImpl(url, this.m_source, (XQAddressFactoryImpl)this.m_endpointHelper.getAddressFactory());
                    }
                    return null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private XQAddress createProcessAddress(String processName, String stepName) throws XQMessageException {
        try {
            return this.m_endpointHelper.getAddressFactory().createProcessAddress(processName, stepName);
        }
        catch (Exception ex) {
            throw new XQMessageException((Throwable)ex);
        }
    }

    private boolean isTemporaryReplyTo(String replyToPropertyValue) {
        if (replyToPropertyValue.indexOf(SONIC_ESB_TEMPORARY_QUEUE_SUBSTRING) != -1) {
            return true;
        }
        if (replyToPropertyValue.indexOf(".AsynchTmp") != -1) {
            return true;
        }
        return replyToPropertyValue.indexOf("ClientTmp.") != -1;
    }

    public void addPart(XQPart part) throws XQMessageException {
        this.checkForDupeCID(part);
        XQPartImpl ourPart = this.convertToXQPartImpl(part);
        this.m_parts.add(ourPart);
    }

    private XQPartImpl convertToXQPartImpl(XQPart part) {
        if (part instanceof XQPartImpl) {
            return (XQPartImpl)part;
        }
        XQPartImpl ourPart = new XQPartImpl();
        if (part.getDataHandler() != null) {
            ourPart.setDataHandler(part.getDataHandler());
        } else {
            ourPart.setContent(part.getContent(), part.getContentType());
        }
        ourPart.setContentId(part.getContentId());
        XQMessageImpl.copyAllPartHeaders(part.getHeader(), ourPart.getHeader());
        return ourPart;
    }

    private static void copyAllPartHeaders(XQHeader from, XQHeader to) {
        Iterator keys = from.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            to.setValue(key, from.getValue(key));
        }
    }

    public void addPartAt(XQPart part, int index) throws XQMessageException {
        this.checkForDupeCID(part);
        XQPartImpl ourPart = this.convertToXQPartImpl(part);
        try {
            this.m_parts.add(index, ourPart);
        }
        catch (IndexOutOfBoundsException e) {
            throw new XQMessageException("Failed to add part. Index out of bounds");
        }
    }

    public boolean containsHeader(String name) throws XQMessageException {
        return this.m_headers.containsKey(name);
    }

    public XQPart createPart(Object content, String contentType) throws XQMessageException {
        return new XQPartImpl(content, contentType);
    }

    public XQPart createPart() throws XQMessageException {
        return new XQPartImpl();
    }

    public boolean doesPartExist(String cid) {
        if (cid == null) {
            return false;
        }
        for (XQPartImpl part : this.m_parts) {
            if (!cid.equals(part.getContentId())) continue;
            return true;
        }
        return false;
    }

    public boolean getBooleanHeader(String name) throws XQMessageException {
        Object property = this.getHeaderValue(name);
        if (property == null) {
            return false;
        }
        if (property instanceof Boolean) {
            return (Boolean)property;
        }
        if (property instanceof String) {
            return Boolean.parseBoolean((String)property);
        }
        throw new XQMessageException("Cannot convert header " + name + " to a boolean.");
    }

    public byte getByteHeader(String name) throws XQMessageException {
        Object property = this.getHeaderValue(name);
        try {
            if (property != null) {
                if (property instanceof Byte) {
                    return (Byte)property;
                }
                if (property instanceof String) {
                    return Byte.parseByte((String)property);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new XQMessageException("Cannot convert header " + name + " to a byte.");
    }

    public String getCorrelationId() throws XQMessageException {
        return this.getStringHeader(HEADER_JMS_CORRELATION_ID);
    }

    public double getDoubleHeader(String name) throws XQMessageException {
        Object property = this.getHeaderValue(name);
        try {
            if (property != null) {
                if (property instanceof Double || property instanceof Float) {
                    return ((Number)property).doubleValue();
                }
                if (property instanceof String) {
                    return Double.parseDouble((String)property);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new XQMessageException("Cannot convert header " + name + " to a double.");
    }

    public float getFloatHeader(String name) throws XQMessageException {
        Object property = this.getHeaderValue(name);
        try {
            if (property != null) {
                if (property instanceof Float) {
                    return ((Number)property).floatValue();
                }
                if (property instanceof String) {
                    return Float.parseFloat((String)property);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new XQMessageException("Cannot convert header " + name + " to a float.");
    }

    public Iterator<String> getHeaderNames() throws XQMessageException {
        ArrayList<String> names = new ArrayList<String>(this.m_headers.keySet());
        return names.iterator();
    }

    public Object getHeaderValue(String name) throws XQMessageException {
        String tempName = name;
        if (ESB_CORR_ID.equals(name)) {
            return this.getCorrelationId();
        }
        if (ESB_REPLY_TO.equals(name)) {
            tempName = USE_NEW_REPLYTO ? ESB_REPLY_TO_NEW : ESB_REPLY_TO;
        }
        return this.m_headers.get(tempName);
    }

    public int getIntHeader(String name) throws XQMessageException {
        Object property = this.getHeaderValue(name);
        try {
            if (property != null) {
                if (property instanceof Integer || property instanceof Short || property instanceof Byte) {
                    return ((Number)property).intValue();
                }
                if (property instanceof String) {
                    return Integer.parseInt((String)property);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new XQMessageException("Cannot convert header " + name + " to a int.");
    }

    public long getLongHeader(String name) throws XQMessageException {
        Object property = this.getHeaderValue(name);
        try {
            if (property != null) {
                if (property instanceof Long || property instanceof Integer || property instanceof Short || property instanceof Byte) {
                    return ((Number)property).longValue();
                }
                if (property instanceof String) {
                    return Long.parseLong((String)property);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new XQMessageException("Cannot convert header " + name + " to a long.");
    }

    public XQPart getPart(int index) throws XQMessageException {
        try {
            return this.m_parts.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new XQMessageException("Failed to get part. " + e.getMessage());
        }
    }

    public XQPart getPart(String cid) throws XQMessageException {
        if (cid != null) {
            for (XQPartImpl part : this.m_parts) {
                if (!cid.equals(part.getContentId())) continue;
                return part;
            }
        }
        throw new XQMessageException("Failed to get part.  No part with content id " + cid);
    }

    public Document getPartAsDocument(String cid, boolean validate) throws XQMessageException {
        XQPartImpl part = (XQPartImpl)this.getPart(cid);
        return part.getAsDocument(validate);
    }

    public Document getPartAsDocument(int index, boolean validate) throws XQMessageException {
        XQPartImpl part = (XQPartImpl)this.getPart(index);
        return part.getAsDocument(validate);
    }

    public int getPartCount() throws XQMessageException {
        return this.m_parts.size();
    }

    public XQAddress getReplyTo() throws XQMessageException {
        return this.m_replyTo;
    }

    public short getShortHeader(String name) throws XQMessageException {
        Object property = this.getHeaderValue(name);
        try {
            if (property != null) {
                if (property instanceof Short || property instanceof Byte) {
                    return ((Number)property).shortValue();
                }
                if (property instanceof String) {
                    return Short.parseShort((String)property);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new XQMessageException("Cannot convert header " + name + " to a short.");
    }

    public String getStringHeader(String name) throws XQMessageException {
        Object property = this.getHeaderValue(name);
        if (property == null) {
            return null;
        }
        if (property instanceof String) {
            return (String)property;
        }
        if (property instanceof Boolean) {
            return ((Boolean)property).toString();
        }
        if (property instanceof Number) {
            return ((Number)property).toString();
        }
        throw new XQMessageException("Cannot convert header " + name + " to a string.");
    }

    public void removeAllParts() throws XQMessageException {
        this.m_parts.clear();
    }

    public Object removeHeader(String name) throws XQMessageException {
        return this.m_headers.remove(name);
    }

    public void removePart(int index) throws XQMessageException {
        try {
            this.m_parts.remove(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new XQMessageException("Failed to remove part. No part at index " + index);
        }
    }

    public void removePart(String cid) throws XQMessageException {
        if (cid != null) {
            Iterator<XQPartImpl> iter = this.m_parts.iterator();
            while (iter.hasNext()) {
                XQPartImpl part = iter.next();
                if (!cid.equals(part.getContentId())) continue;
                iter.remove();
                return;
            }
        }
        throw new XQMessageException("Failed to remove part.  No part with content id " + cid);
    }

    public void replacePart(XQPart part, int index) throws XQMessageException {
        try {
            this.checkForDupeCID(part, index);
            XQPartImpl xQPartImpl = this.m_parts.set(index, this.convertToXQPartImpl(part));
        }
        catch (IndexOutOfBoundsException e) {
            throw new XQMessageException("Failed to replace part. No part at index " + index);
        }
    }

    public void replacePart(XQPart part, String cid) throws XQMessageException {
        if (cid != null) {
            for (int i = 0; i < this.m_parts.size(); ++i) {
                XQPartImpl oldPart = this.m_parts.get(i);
                if (!cid.equals(oldPart.getContentId())) continue;
                XQPartImpl newPart = this.convertToXQPartImpl(part);
                if (null == newPart.getContentId()) {
                    newPart.setContentId(cid);
                }
                this.m_parts.set(i, newPart);
                return;
            }
        }
        throw new XQMessageException("Failed to replace part.  No part with content id " + cid);
    }

    public void setBooleanHeader(String name, boolean value) throws XQMessageException {
        this.setHeaderValue(name, value);
    }

    public void setByteHeader(String name, byte value) throws XQMessageException {
        this.setHeaderValue(name, value);
    }

    public void setCorrelationId(String id) throws XQMessageException {
        this.setStringHeader(HEADER_JMS_CORRELATION_ID, id);
    }

    public void setDoubleHeader(String name, double value) throws XQMessageException {
        this.setHeaderValue(name, value);
    }

    public void setFloatHeader(String name, float value) throws XQMessageException {
        this.setHeaderValue(name, Float.valueOf(value));
    }

    private void setESBReplyTo(String name, Object value) throws XQMessageException {
        if (value instanceof String) {
            XQAddress parsed = this.parseReplyToProperty((String)value);
            if (parsed != null) {
                this.setReplyTo(parsed);
            } else {
                this.m_headers.put(name, value);
            }
        } else if (value instanceof XQAddress) {
            this.setReplyTo((XQAddress)value);
        } else {
            return;
        }
    }

    public void setHeaderValue(String name, Object value) throws XQMessageException {
        if (name.charAt(0) == '{') {
            if (ESB_CORR_ID.equals(name)) {
                this.setCorrelationId((String)value);
                return;
            }
            if (ESB_REPLY_TO.equals(name)) {
                String headerName = USE_NEW_REPLYTO ? ESB_REPLY_TO_NEW : ESB_REPLY_TO;
                this.setESBReplyTo(headerName, value);
                return;
            }
        } else if (HEADER_JMS_REPLY_TO.equals(name)) {
            if (value instanceof String) {
                this.replyToDestFromString(value.toString());
                return;
            }
        } else if (ESB_REPLY_TO_NEW.equals(name)) {
            this.setESBReplyTo(name, value);
            return;
        }
        if (value instanceof Boolean) {
            this.m_headers.put(name, value);
        } else if (value instanceof Number) {
            if (HEADER_JMS_PRIORITY.equals(name)) {
                this.addSidebandProperty(INCOMING_JMS_PRIORITY_PROPERTY, value);
            }
            this.m_headers.put(name, value);
        } else if (value instanceof String) {
            this.addSidebandPropertyAndPopulateHeaders(name, value);
        } else if (value instanceof Destination) {
            if (!HEADER_JMS_DESTINATION.equals(name) && !HEADER_JMS_REPLY_TO.equals(name)) {
                throw new XQMessageException("Invalid header name for value of type javax.jms.Destination.");
            }
            this.m_headers.put(name, value);
        } else if (value == null) {
            this.m_headers.remove(name);
        } else {
            throw new XQMessageException("Invalid object type for header.");
        }
    }

    private void addSidebandPropertyAndPopulateHeaders(String name, Object value) {
        if (HEADER_JMS_PRIORITY.equals(name) && ((String)value).matches("\\d")) {
            this.addSidebandProperty(INCOMING_JMS_PRIORITY_PROPERTY, Integer.parseInt((String)value));
        }
        this.m_headers.put(name, value);
    }

    private Destination getDestinationFromString(XQEndpointConfig configParam, String endpointName) throws XQEndpointCreationException, JMSException {
        XQEndpointConfig config = configParam;
        Object jmsDestination = null;
        if (config == null) {
            XQEndpoint endpoint = this.m_endpointRegistry.getEndpoint(endpointName);
            config = this.m_endpointHelper.getConfig(endpoint);
        }
        if (config != null && (jmsDestination = (Destination)config.getParameters().getParameterObject("destinationObject", 3)) == null) {
            String destName = config.getParameters().getParameter("destination", 1);
            String destType = config.getParameters().getParameter("type", 1);
            if (destName != null && destType != null) {
                jmsDestination = "QUEUE".equalsIgnoreCase(destType) ? new progress.message.jclient.Queue(destName) : new progress.message.jclient.Topic(destName);
            }
        }
        return jmsDestination;
    }

    private void replyToDestFromString(String value) {
        try {
            if (value != null && value.startsWith("queue://")) {
                this.m_headers.put(HEADER_JMS_REPLY_TO, value);
            } else {
                Destination jmsDestination = this.getDestinationFromString(null, value);
                if (jmsDestination != null) {
                    this.m_headers.put(HEADER_JMS_REPLY_TO, jmsDestination);
                }
            }
        }
        catch (Exception e) {
            this.m_headers.put(HEADER_JMS_REPLY_TO, value);
            systemLog.logWarning(e.toString());
            systemLog.logDebug((Throwable)e);
        }
    }

    public void setHeaderValues(Map<String, Object> headers) throws XQMessageException {
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            this.setHeaderValue(entry.getKey(), entry.getValue());
        }
    }

    public void setIntHeader(String name, int value) throws XQMessageException {
        this.setHeaderValue(name, value);
    }

    public void setLongHeader(String name, long value) throws XQMessageException {
        this.setHeaderValue(name, value);
    }

    public void setPartFromDocument(String cid, Document doc) throws XQMessageException {
        StringWriter writer = new StringWriter();
        DOMUtils.serializeNodeToWriter((Node)doc, (Writer)writer);
        XQPartImpl part = new XQPartImpl(writer.toString(), "text/xml");
        part.setContentId(cid);
        this.addPart(part);
    }

    public void setPartFromDocument(int index, Document doc) throws XQMessageException {
        StringWriter writer = new StringWriter();
        DOMUtils.serializeNodeToWriter((Node)doc, (Writer)writer);
        XQPartImpl part = new XQPartImpl(writer.toString(), "text/xml");
        this.addPartAt(part, index);
    }

    public void setReplyTo(XQAddress replyTo) throws XQMessageException {
        this.m_replyTo = replyTo;
        this.setReplyToProperty(replyTo);
        this.setJMSReplyTo(replyTo);
    }

    private void setReplyToProperty(XQAddress replyTo) {
        String stepName;
        String headerName = USE_NEW_REPLYTO ? ESB_REPLY_TO_NEW : ESB_REPLY_TO;
        StringBuilder propertyValue = null;
        if (replyTo != null) {
            propertyValue = new StringBuilder().append(((IXQAddressImpl)replyTo).getTypeAsString()).append(':').append(((IXQAddressImpl)replyTo).getReplyToName());
        }
        if (replyTo != null && this.isStepAddress(replyTo) && (stepName = ((XQProcessAddress)replyTo).getStepName()) != null) {
            this.m_headers.put(headerName, propertyValue.append(":" + stepName).toString());
            return;
        }
        if (propertyValue != null) {
            this.m_headers.put(headerName, propertyValue.toString());
        } else {
            this.m_headers.remove(headerName);
        }
    }

    private boolean isStepAddress(XQAddress address) {
        if (!(address instanceof XQProcessAddressImpl)) {
            return false;
        }
        String step = ((XQProcessAddress)address).getStepName();
        return step != null && step.trim().length() != 0;
    }

    private void setJMSReplyTo(XQAddress replyTo) {
        String endpointName = null;
        try {
            if (replyTo == null || this.isStepAddress(replyTo) || replyTo instanceof XQURLAddressImpl) {
                this.setHeaderValue(HEADER_JMS_REPLY_TO, null);
                return;
            }
            XQConfigManager configManager = XQConfigManager.getInstance(null);
            String addressName = replyTo.getName();
            switch (replyTo.getType()) {
                case 1: {
                    XQServiceConfig serviceConfig = configManager.lookupServiceConfig(addressName);
                    endpointName = serviceConfig.getEntryEndpoint();
                    break;
                }
                case 2: {
                    XQProcessConfig processConfig = configManager.lookupProcessConfig(addressName);
                    endpointName = processConfig.getEntryEndpoint();
                    break;
                }
                case 0: {
                    endpointName = addressName;
                    break;
                }
            }
            if (endpointName != null) {
                XQEndpointConfig config = (XQEndpointConfig)((IXQAddressImpl)replyTo).getConfig();
                Destination jmsDestination = this.getDestinationFromString(config, endpointName);
                if (jmsDestination != null) {
                    this.m_headers.put(HEADER_JMS_REPLY_TO, jmsDestination);
                } else {
                    this.m_headers.remove(HEADER_JMS_REPLY_TO);
                }
            } else {
                this.m_headers.remove(HEADER_JMS_REPLY_TO);
            }
        }
        catch (Exception e) {
            systemLog.logWarning(e.toString());
            systemLog.logDebug((Throwable)e);
        }
    }

    public void setShortHeader(String name, short value) throws XQMessageException {
        this.setHeaderValue(name, value);
    }

    public void setStringHeader(String name, String value) throws XQMessageException {
        this.setHeaderValue(name, value);
    }

    public String toString() {
        return "XQMessage [headers=" + this.m_headers + ", parts(count=" + this.m_parts.size() + ")=" + this.m_parts + ", replyTo=" + this.m_replyTo + ", source endpoint=" + this.m_source + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream oos) throws IOException {
        Destination jmsDestination = (Destination)this.m_headers.remove(HEADER_JMS_DESTINATION);
        Destination jmsReplyTo = (Destination)this.m_headers.remove(HEADER_JMS_REPLY_TO);
        try {
            oos.defaultWriteObject();
            this.serializeJmsDestination(oos, jmsDestination);
            this.serializeJmsDestination(oos, jmsReplyTo);
            oos.writeBoolean(this.isEndpointManager(this.m_endpointRegistry));
        }
        finally {
            if (jmsDestination != null) {
                this.m_headers.put(HEADER_JMS_DESTINATION, jmsDestination);
            }
            if (jmsReplyTo != null) {
                this.m_headers.put(HEADER_JMS_REPLY_TO, jmsReplyTo);
            }
        }
    }

    private void serializeJmsDestination(ObjectOutputStream oos, Destination jmsDestination) throws IOException {
        try {
            if (jmsDestination instanceof Topic) {
                oos.writeByte(1);
                oos.writeUTF(((Topic)jmsDestination).getTopicName());
            } else if (jmsDestination instanceof Queue) {
                oos.writeByte(2);
                oos.writeUTF(((Queue)jmsDestination).getQueueName());
            } else {
                oos.write(0);
            }
        }
        catch (JMSException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        boolean epmi;
        Destination jmsReplyTo;
        ois.defaultReadObject();
        Destination jmsDestination = this.deserializeJmsDestination(ois);
        if (jmsDestination != null) {
            this.m_headers.put(HEADER_JMS_DESTINATION, jmsDestination);
        }
        if ((jmsReplyTo = this.deserializeJmsDestination(ois)) != null) {
            this.m_headers.put(HEADER_JMS_REPLY_TO, jmsReplyTo);
        }
        if (this.m_endpointHelper == null) {
            IEndpointHelper iEndpointHelper = this.m_endpointHelper = XQMessageImpl.inContainer() ? new XQContainerEndpointHelper() : new StandaloneEndpointHelper();
        }
        if (epmi = ois.readBoolean()) {
            this.m_endpointRegistry = this.m_endpointHelper.getEndpointManagerInstance();
        } else {
            this.m_endpointRegistry = this.m_endpointHelper.getInvocationEndpointRegistry();
            if (this.m_endpointRegistry == null) {
                this.m_endpointRegistry = this.m_endpointHelper.getEndpointManagerInstance();
            }
        }
    }

    private static boolean inContainer() {
        try {
            Class<?> clz = Class.forName("com.sonicsw.xqimpl.service.XQContainer");
            Method getContainerName = clz.getMethod("getContainerName", new Class[0]);
            Object o = getContainerName.invoke(null, new Object[0]);
            String sresult = (String)o;
            return sresult != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private Destination deserializeJmsDestination(ObjectInputStream ois) throws IOException {
        try {
            byte jmsType = ois.readByte();
            switch (jmsType) {
                case 0: {
                    return null;
                }
                case 1: {
                    String topicName = ois.readUTF();
                    return DestinationFactory.createTopic((String)topicName);
                }
                case 2: {
                    String queueName = ois.readUTF();
                    return DestinationFactory.createQueue((String)queueName);
                }
            }
            return null;
        }
        catch (JMSException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    private boolean isEndpointManager(Object o) {
        return "com.sonicsw.xqimpl.endpoint.container.EndpointManager".equals(o.getClass().getName());
    }

    private void checkForDupeCID(XQPart part) throws XQMessageException {
        String contentId = part.getContentId();
        if (contentId != null) {
            for (XQPart xQPart : this.m_parts) {
                if (!contentId.equals(xQPart.getContentId())) continue;
                throw new XQMessageException("Cannot add part `" + contentId + "` as a part with same cid already exists");
            }
        }
    }

    private void checkForDupeCID(XQPart part, int index) throws XQMessageException {
        String contentId = part.getContentId();
        if (contentId != null) {
            int count = 0;
            for (XQPart xQPart : this.m_parts) {
                if (count++ == index || !contentId.equals(xQPart.getContentId())) continue;
                throw new XQMessageException("Failed to replace part [" + index + "] with cid `" + contentId + "` as another part with same cid already exists at index " + (count - 1));
            }
        }
    }
}

