/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.tools.install.config;

import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.mf.mgmtapi.config.IContainerBean;
import com.sonicsw.mx.config.ConfigServerUtility;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.xqimpl.mgmtapi.config.IXQContainerBean;
import com.sonicsw.xqimpl.mgmtapi.config.XQMgmtBeanFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class ContainerConfig {
    private static final String USAGE = "java com.sonicsw.xqimpl.tools.install.config.ContainerConfig <-containers name1,name2,etc> <-url brokerUrl> <-domain name> <-installpath esbhome> [<-user username> <-password password> <-mgmtnode managementnode> <-cp classpath>]";
    private String[] m_containers;
    private String m_domain;
    private String m_url;
    private String m_user;
    private String m_password;
    private String m_managementnode;
    private String m_sonicEsbHome;
    private String m_classPath;
    private String m_nativeLibPath;
    private Map m_deploymentParams = new HashMap();
    private String m_jvmArgs;
    private String m_connectionURLs;
    private String m_defaultUser;
    private String m_defaultPassword;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainerConfig(String[] args) {
        try {
            this.parseArgs(args);
            if (!this.validateArgs()) {
                System.out.println("*Error*: Invalid args. Usage: java com.sonicsw.xqimpl.tools.install.config.ContainerConfig <-containers name1,name2,etc> <-url brokerUrl> <-domain name> <-installpath esbhome> [<-user username> <-password password> <-mgmtnode managementnode> <-cp classpath>]");
                System.exit(-1);
            }
        }
        catch (Exception e) {
            System.out.println("*Error*: Invalid args. Usage: java com.sonicsw.xqimpl.tools.install.config.ContainerConfig <-containers name1,name2,etc> <-url brokerUrl> <-domain name> <-installpath esbhome> [<-user username> <-password password> <-mgmtnode managementnode> <-cp classpath>]");
            System.exit(-1);
        }
        ConfigServerUtility csu = new ConfigServerUtility();
        try {
            csu.connect(this.m_domain, this.m_url, this.m_user, this.m_password, true);
            XQMgmtBeanFactory domain = new XQMgmtBeanFactory();
            domain.connect(csu.getDirectoryService());
            for (int i = 0; i < this.m_containers.length; ++i) {
                this.addXQContainerToMFContainer(domain, this.m_containers[i]);
                System.out.println("Successfully configured MF container for ESB container " + this.m_containers[i]);
            }
        }
        catch (Exception e) {
            System.out.println("*Error*: " + e.getMessage());
            e.printStackTrace();
            System.exit(-2);
        }
        finally {
            try {
                csu.disconnect();
            }
            catch (ConfigServiceException e) {
                System.out.println("*Warning*: Problem during disconnection from the domain due to " + e.getMessage());
            }
        }
        System.out.println("*Success*");
    }

    private void addXQContainerToMFContainer(XQMgmtBeanFactory domain, String containerName) throws Exception {
        String useContainerName = containerName;
        String componentName = containerName;
        int index = containerName.indexOf(58);
        if (index != -1) {
            useContainerName = containerName.substring(0, index);
            componentName = containerName.substring(index + 1);
        }
        String mfContainerViewName = "/Containers/" + useContainerName;
        String XQContainerViewName = "/ESB Containers/" + useContainerName;
        IXQContainerBean xqContainerBean = domain.getXQContainerBean(XQContainerViewName);
        if (xqContainerBean == null) {
            System.out.println("*Warning*: Unable to find configuration in the directory for ESB container " + useContainerName + ".  Skipping mf configuration.");
            return;
        }
        this.updateEsbContainerClasspath(xqContainerBean);
        IContainerBean mfContainer = this.getOrCreateMfContainer(domain, mfContainerViewName);
        this.updateManagementConnection(mfContainer);
        this.updateNativeLibraryPath(mfContainer);
        this.updateJvmArguments(mfContainer);
        this.addAsComponentToMfContainer(mfContainer, componentName, xqContainerBean);
        this.setupDeploymentParameters(mfContainer, componentName);
        domain.saveBean((IMgmtBeanBase)mfContainer);
        domain.commit();
    }

    private void updateJvmArguments(IContainerBean mfContainer) throws MgmtException {
        if (this.m_jvmArgs != null && this.m_jvmArgs.length() > 0) {
            String jvmArgs = null;
            try {
                jvmArgs = mfContainer.getJvmArguments();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (jvmArgs != null && !"".equals(jvmArgs)) {
                if (!jvmArgs.endsWith(" ")) {
                    jvmArgs = jvmArgs + " ";
                }
                jvmArgs = jvmArgs + this.m_jvmArgs;
            } else {
                jvmArgs = this.m_jvmArgs;
            }
            mfContainer.setJvmArguments(jvmArgs);
        }
    }

    private void updateNativeLibraryPath(IContainerBean mfContainer) throws MgmtException {
        if (this.m_nativeLibPath != null) {
            mfContainer.setContainerNativeLibraryPath(this.m_nativeLibPath);
        }
    }

    private void updateManagementConnection(IContainerBean mfContainer) throws MgmtException {
        IContainerBean.IConnectionType connection = mfContainer.getConnection();
        connection.setDefaultUser(this.m_defaultUser);
        connection.setDefaultPassword(this.m_defaultPassword);
        connection.setConnectionURLs(this.m_connectionURLs);
        if (this.m_managementnode != null) {
            connection.setManagementNode(this.m_managementnode);
        }
    }

    private IContainerBean getOrCreateMfContainer(XQMgmtBeanFactory domain, String mfContainerViewName) throws MgmtException {
        IContainerBean mfContainer = null;
        try {
            mfContainer = domain.getContainerBean(mfContainerViewName);
        }
        catch (Exception e) {
            mfContainer = null;
        }
        if (mfContainer == null) {
            mfContainer = domain.createContainerBean(mfContainerViewName);
        }
        return mfContainer;
    }

    private void addAsComponentToMfContainer(IContainerBean mfContainer, String componentName, IXQContainerBean xqContainerBean) throws MgmtException {
        IContainerBean.IComponentsType components = mfContainer.getComponents();
        boolean found = false;
        try {
            if (components.getEntry(componentName) != null) {
                found = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!found) {
            IContainerBean.IStartupParams startupParams = components.createEntry();
            startupParams.setAutoStart(true);
            startupParams.setConfigRef((IMgmtBeanBase)xqContainerBean);
            components.addEntry(componentName, startupParams);
        }
    }

    private void updateEsbContainerClasspath(IXQContainerBean xqContainerBean) throws MgmtException {
        if (this.m_classPath != null && !"".equals(this.m_classPath)) {
            String classpath = null;
            try {
                classpath = xqContainerBean.getClasspath();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (classpath != null && !"".equals(classpath)) {
                this.m_classPath = this.m_classPath + ";";
                this.m_classPath = this.m_classPath + classpath;
            }
            xqContainerBean.setClasspath(this.m_classPath);
        }
    }

    private void setupDeploymentParameters(IContainerBean mfContainer, String containerName) throws MgmtException {
        if (this.m_deploymentParams != null && this.m_deploymentParams.size() > 0) {
            boolean found = false;
            IContainerBean.IComponentsType type = mfContainer.getComponents();
            IContainerBean.IStartupParams startupParams = type.getEntry(containerName);
            IContainerBean.IDeploymentParametersSet parameterSet = null;
            try {
                parameterSet = startupParams.getDeploymentParameters();
                found = true;
            }
            catch (Exception e) {
                parameterSet = startupParams.createDeploymentParameters();
            }
            for (String name : this.m_deploymentParams.keySet()) {
                String value = (String)this.m_deploymentParams.get(name);
                IContainerBean.IDeploymentParameterType deploymentParameter = parameterSet.createEntry();
                deploymentParameter.setValue(value);
                parameterSet.addEntry(name, deploymentParameter);
            }
            if (!found) {
                startupParams.setDeploymentParameters(parameterSet);
            }
        }
    }

    private void parseArgs(String[] args) throws Exception {
        String containersArg = null;
        String deploymentParams = null;
        for (int i = 0; i < args.length; ++i) {
            if ("-containers".equals(args[i])) {
                containersArg = args[++i];
                continue;
            }
            if ("-url".equals(args[i])) {
                this.m_url = args[++i];
                continue;
            }
            if ("-user".equals(args[i])) {
                this.m_user = args[++i];
                continue;
            }
            if ("-password".equals(args[i])) {
                this.m_password = args[++i];
                continue;
            }
            if ("-connectionURLs".equals(args[i])) {
                this.m_connectionURLs = args[++i];
                continue;
            }
            if ("-defaultUser".equals(args[i])) {
                this.m_defaultUser = args[++i];
                continue;
            }
            if ("-defaultPassword".equals(args[i])) {
                this.m_defaultPassword = args[++i];
                continue;
            }
            if ("-domain".equals(args[i])) {
                this.m_domain = args[++i];
                continue;
            }
            if ("-installpath".equals(args[i])) {
                this.m_sonicEsbHome = args[++i];
                continue;
            }
            if ("-cp".equals(args[i])) {
                this.m_classPath = args[++i];
                continue;
            }
            if ("-deploymentParams".equals(args[i])) {
                if (!"not_set".equals(deploymentParams = args[++i])) continue;
                deploymentParams = null;
                continue;
            }
            if ("-nativeLibPath".equals(args[i])) {
                this.m_nativeLibPath = args[++i];
                if (!"not_set".equals(this.m_nativeLibPath)) continue;
                this.m_nativeLibPath = null;
                continue;
            }
            if ("-mgmtnode".equals(args[i])) {
                this.m_managementnode = args[++i];
                if (!"not_set".equals(this.m_managementnode)) continue;
                this.m_managementnode = null;
                continue;
            }
            if (!"-jvmArgs".equals(args[i])) continue;
            this.m_jvmArgs = args[++i];
            if (!"not_set".equals(this.m_jvmArgs)) continue;
            this.m_jvmArgs = null;
        }
        this.parseContainers(containersArg);
        this.parseDeploymentParams(deploymentParams);
        if (null == this.m_connectionURLs && this.m_url.endsWith("ds.xml")) {
            throw new IllegalArgumentException("You must specify a container connection URL different than the offline URL to connect to the DS.");
        }
        if (null == this.m_connectionURLs) {
            this.m_connectionURLs = this.m_url;
        }
        if (null == this.m_defaultUser) {
            this.m_defaultUser = this.m_user;
        }
        if (null == this.m_defaultPassword) {
            this.m_defaultPassword = this.m_password;
        }
    }

    private void parseContainers(String containersArg) {
        Vector<String> containers = new Vector<String>();
        StringTokenizer st = new StringTokenizer(containersArg, ",");
        while (st.hasMoreElements()) {
            String container = (String)st.nextElement();
            containers.addElement(container);
        }
        this.m_containers = new String[containers.size()];
        containers.copyInto(this.m_containers);
    }

    private void parseDeploymentParams(String deploymentParams) {
        if (deploymentParams != null && deploymentParams.length() > 0) {
            StringTokenizer st = new StringTokenizer(deploymentParams, ",");
            while (st.hasMoreTokens()) {
                String nameValue = (String)st.nextElement();
                String name = null;
                String value = null;
                StringTokenizer paramTokenizer = new StringTokenizer(nameValue, "=");
                if (paramTokenizer.hasMoreTokens()) {
                    name = paramTokenizer.nextToken();
                    if (paramTokenizer.hasMoreTokens()) {
                        value = paramTokenizer.nextToken();
                    }
                }
                if (name == null || value == null) {
                    System.out.println("Unable to parse name/value pair: " + nameValue);
                }
                this.m_deploymentParams.put(name, value);
            }
        }
    }

    private boolean validateArgs() {
        return this.m_containers != null && this.m_containers.length != 0 && this.m_domain != null && this.m_url != null && this.m_sonicEsbHome != null;
    }

    public static void main(String[] args) {
        ContainerConfig config = new ContainerConfig(args);
        System.exit(0);
    }
}

