/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.artifact;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.artifact.AbstractArtifact;
import java.util.Arrays;

public final class ESBArtifact
extends AbstractArtifact {
    public static final String TYPE = "ESB";
    public static final IArtifact ROOT = new ESBArtifact("/");
    public static final IArtifact CONTAINER = new ESBArtifact("/Containers/");
    public static final IArtifact PROCESS = new ESBArtifact("/Processes/");
    public static final IArtifact SERVICE = new ESBArtifact("/Services/");
    public static final IArtifact SERVICE_TYPE = new ESBArtifact("/ServiceTypes/");
    public static final IArtifact ENDPOINT = new ESBArtifact("/Endpoints/");
    public static final IArtifact ENDPOINT_TYPE = new ESBArtifact("/EndpointTypes/");
    public static final IArtifact CONNECTION = new ESBArtifact("/Connections/");
    public static final IArtifact CONNECTION_TYPE = new ESBArtifact("/ConnectionTypes/");
    private static final IArtifact[] S_ARTIFACTS = new IArtifact[]{CONTAINER, PROCESS, SERVICE, SERVICE_TYPE, ENDPOINT, ENDPOINT_TYPE, CONNECTION, CONNECTION_TYPE};

    public ESBArtifact(String path) {
        super(TYPE, path);
    }

    public ESBArtifact(IArtifact base, String name) {
        this((base.getPath().endsWith("/") ? base.getPath() : base.getPath() + "/") + name);
    }

    public static IArtifact[] getValidTypes() {
        return Arrays.copyOf(S_ARTIFACTS, S_ARTIFACTS.length);
    }

    @Override
    public boolean isValidArtifact() {
        if (this.isRootPath()) {
            return false;
        }
        for (int i = 0; i < S_ARTIFACTS.length; ++i) {
            if (!S_ARTIFACTS[i].getRootDirectory().equals(this.getRootDirectory())) continue;
            return true;
        }
        return false;
    }
}

