/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.storage;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactTraversalContext;
import com.sonicsw.deploy.artifact.ConfigBeanArtifact;
import com.sonicsw.deploy.artifact.ESBArtifact;
import com.sonicsw.deploy.artifact.SonicFSArtifact;
import com.sonicsw.deploy.artifact.SystemArtifact;
import com.sonicsw.deploy.artifact.ZipContentArtifact;
import com.sonicsw.deploy.artifact.ZipFileArtifact;
import com.sonicsw.deploy.storage.AbstractArtifactStorage;
import com.sonicsw.deploy.traversal.ZipContentTraverser;
import com.sonicsw.deploy.util.FileUtils;
import com.sonicsw.xqimpl.util.DOMUtils;
import java.io.File;
import org.w3c.dom.Document;

public class FileArtifactStorage
extends AbstractArtifactStorage {
    private File m_root;

    public FileArtifactStorage() {
        this.setStoreName("Storage[File]");
    }

    public String toString() {
        String canonicalPath = null;
        if (this.m_root != null) {
            try {
                canonicalPath = this.m_root.getCanonicalPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getStoreName() + (canonicalPath != null ? " with root \"" + canonicalPath + "\"" : "");
    }

    public void setRoot(String root) throws Exception {
        File file = new File(root);
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new Exception("'" + root + "' is not a directory");
            }
        } else {
            file.mkdirs();
        }
        this.m_root = file;
    }

    public File getRoot() {
        return this.m_root;
    }

    @Override
    public boolean exists(IArtifact artifact) throws Exception {
        if (!artifact.isValidArtifact()) {
            throw new Exception("Failed to check if exists for '" + artifact + "' - invalid artifact");
        }
        File file = new File(this.m_root, FileArtifactStorage.getFilename(artifact));
        return file.exists() && file.isFile();
    }

    @Override
    public Document getContentsAsDom(IArtifact artifact) throws Exception {
        return DOMUtils.getDocument((byte[])this.getContentsAsBytes(artifact));
    }

    @Override
    public String getContentsAsString(IArtifact artifact) throws Exception {
        byte[] bytes = this.getContentsAsBytes(artifact);
        String charsetName = FileArtifactStorage.getEncoding(artifact, bytes);
        if (charsetName == null) {
            return new String(bytes);
        }
        return new String(bytes, charsetName);
    }

    @Override
    public byte[] getContentsAsBytes(IArtifact artifact) throws Exception {
        if (!artifact.isValidArtifact()) {
            throw new Exception("Failed to get byte[] content of '" + artifact + "' - invalid artifact");
        }
        byte[] ret = null;
        if (artifact instanceof ZipContentArtifact) {
            ZipContentArtifact zipContentArtifact = (ZipContentArtifact)artifact;
            ZipFileArtifact zipFile = zipContentArtifact.getZipFileArtifact();
            ret = zipFile.getZipStorage().readContent(zipContentArtifact);
        } else {
            File file = new File(this.m_root, FileArtifactStorage.getFilename(artifact));
            this.checkValidFile(file);
            ret = FileUtils.readFile(file);
        }
        return ret;
    }

    @Override
    public void deleteAll() throws Exception {
        this._notifyMessage(2, "Delete all artifacts from store");
        if (this.m_root != null) {
            this._deleteDir(this.m_root);
        }
    }

    @Override
    public void store(IArtifact artifact, Object content) throws Exception {
        if ((artifact instanceof ESBArtifact || artifact instanceof ConfigBeanArtifact) && !(content instanceof String)) {
            throw new Exception("Failed to store '" + artifact + "' - only supports String content");
        }
        if (artifact instanceof ZipContentArtifact) {
            ZipContentArtifact zipContentArtifact = (ZipContentArtifact)artifact;
            ZipFileArtifact zipFile = zipContentArtifact.getZipFileArtifact();
            zipFile.markDirty();
            super.store(artifact, content, zipFile.getLocalArchive().getAbsoluteFile());
        } else {
            super.store(artifact, content, this.m_root);
        }
    }

    protected void checkConnected() throws Exception {
        if (this.m_root == null) {
            throw new Exception("Root is not defined");
        }
    }

    @Override
    protected void _listESBArtifacts(IArtifact parent, IArtifactTraversalContext context) throws Exception {
        File dir = new File(this.m_root, FileArtifactStorage.getFilename(parent));
        if (!dir.exists()) {
            return;
        }
        this.checkValidDirectory(dir);
        File[] list = dir.listFiles();
        for (int i = 0; i < list.length; ++i) {
            String name;
            if (!list[i].isFile() || !(name = list[i].getName()).endsWith(".xml")) continue;
            context.addTraversed(new ESBArtifact(parent, this.stripExtension(name)));
        }
    }

    private String stripExtension(String name) {
        if (name.endsWith(".xml")) {
            return name.substring(0, name.length() - ".xml".length());
        }
        return name;
    }

    @Override
    protected void _listSonicFSArtifacts(IArtifact parent, IArtifactTraversalContext context) throws Exception {
        File dir = new File(this.m_root, FileArtifactStorage.getFilename(parent));
        if (!dir.exists()) {
            return;
        }
        this.checkValidDirectory(dir);
        File[] list = dir.listFiles();
        File current = null;
        for (int i = 0; i < list.length; ++i) {
            current = list[i];
            if (current.isDirectory()) {
                this._list(new SonicFSArtifact(parent, list[i].getName() + "/"), context);
                continue;
            }
            if (ZipFileArtifact.isArchiveFile(current.getName())) {
                ZipFileArtifact zipArtifact = new ZipFileArtifact(parent, current.getName(), null);
                new ZipContentTraverser(zipArtifact).traverse(context);
                continue;
            }
            context.addTraversed(new SonicFSArtifact(parent, list[i].getName()));
        }
    }

    @Override
    protected void _listConfigBeanArtifacts(IArtifact parent, IArtifactTraversalContext context) throws Exception {
        File dir = new File(this.m_root, FileArtifactStorage.getFilename(parent));
        if (!dir.exists()) {
            return;
        }
        this.checkValidDirectory(dir);
        File[] list = dir.listFiles();
        for (int i = 0; i < list.length; ++i) {
            if (list[i].isDirectory()) {
                this._list(new ConfigBeanArtifact(parent, list[i].getName() + "/"), context);
                continue;
            }
            context.addTraversed(new ConfigBeanArtifact(parent, list[i].getName()));
        }
    }

    @Override
    protected void _listSystemArtifacts(IArtifactTraversalContext context) throws Exception {
        File[] list = this.m_root.listFiles();
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].isFile()) continue;
            context.addTraversed(new SystemArtifact(list[i].getName()));
        }
    }

    protected void checkValidFile(File file) throws Exception {
        if (!file.exists()) {
            throw new Exception("'" + file + "' does not exist");
        }
        if (!file.isFile()) {
            throw new Exception("'" + file + "' is not a valid file");
        }
    }

    protected void checkValidDirectory(File dir) throws Exception {
        if (!dir.exists()) {
            throw new Exception("'" + dir + "' does not exist");
        }
        if (!dir.isDirectory()) {
            throw new Exception("'" + dir + "' is not a valid directory");
        }
    }

    public String getFileExtension(IArtifact artifact) {
        String name = FileArtifactStorage.getFilename(artifact);
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return name.substring(index + 1);
    }

    protected void _deleteDir(File dir) {
        if (!dir.exists()) {
            return;
        }
        File[] list = dir.listFiles();
        for (int i = 0; i < list.length; ++i) {
            if (list[i].isFile()) {
                list[i].delete();
                continue;
            }
            if (!list[i].isDirectory()) continue;
            this._deleteDir(list[i]);
            list[i].delete();
        }
    }
}

