/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.traversal;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.IArtifactTraversalContext;
import com.sonicsw.deploy.IArtifactTraverser;
import com.sonicsw.deploy.artifact.ESBArtifact;
import com.sonicsw.deploy.artifact.SonicFSArtifact;
import com.sonicsw.deploy.artifact.ZipFileArtifact;
import com.sonicsw.deploy.storage.AbstractArtifactStorage;
import com.sonicsw.deploy.traversal.ESBTraverserFactory;
import com.sonicsw.deploy.traversal.SonicFSTraverser;
import com.sonicsw.deploy.util.RegExIterator;
import com.sonicsw.deploy.util.VariableConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class AbstractTraverser
implements IArtifactTraverser {
    public static final String SONICFS_PREFIX = "sonicfs://";
    public static final String SONIC_PREFIX = "sonic://";
    public static final String SONICESB_PREFIX = "sonicesb://";
    public static final String VARIABLE_PREFIX = "${property:";
    protected IArtifact m_artifact;

    public AbstractTraverser(IArtifact artifact) {
        this.m_artifact = artifact;
    }

    @Override
    public void traverse(IArtifactTraversalContext context) throws Exception {
        if (this.m_artifact == null) {
            return;
        }
        if (!context.addTraversed(this.m_artifact)) {
            return;
        }
        this._traverse(context);
    }

    public void _traverse(IArtifactTraversalContext context) {
        AbstractArtifactStorage store = (AbstractArtifactStorage)context.getStorage();
        store._notifyMessage(2, "Traversing '" + this.m_artifact + "'");
        try {
            this.doTraversal(context);
        }
        catch (Exception e) {
            context.addErrored(this.m_artifact);
            store._notifyErrorMessage("Error traversing '" + this.m_artifact + "' : " + e.getMessage(), e);
        }
    }

    protected abstract void doTraversal(IArtifactTraversalContext var1) throws Exception;

    protected void traverseAttributes(NamedNodeMap attribs, IArtifactTraversalContext context) throws Exception {
        for (int j = 0; j < attribs.getLength(); ++j) {
            this.traverseURLRefs(attribs.item(j).getNodeValue(), context);
        }
    }

    protected void traverseChildNodes(NodeList children, IArtifactTraversalContext context) throws Exception {
        block4: for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            switch (child.getNodeType()) {
                case 1: {
                    this.traverseAttributes(child.getAttributes(), context);
                    this.traverseChildNodes(child.getChildNodes(), context);
                    continue block4;
                }
                case 3: {
                    this.traverseURLRefs(((Text)child).getData(), context);
                }
            }
        }
    }

    protected boolean traverseURLRefs(String val, IArtifactTraversalContext context) throws Exception {
        return this.traverseURLRefs(val, context, false);
    }

    protected boolean traverseURLRefs(String val, IArtifactTraversalContext context, boolean variableSubs) throws Exception {
        IArtifact[] artifacts = this.convertURLStringToArtifacts(val, context, variableSubs);
        boolean ret = false;
        if (artifacts != null && artifacts.length > 0) {
            for (int i = 0; i < artifacts.length; ++i) {
                if (artifacts[i] instanceof SonicFSArtifact) {
                    new SonicFSTraverser(artifacts[i]).traverse(context);
                    continue;
                }
                if (!(artifacts[i] instanceof ESBArtifact)) continue;
                ESBTraverserFactory.createTraverser(artifacts[i]).traverse(context);
            }
            ret = true;
        }
        return ret;
    }

    private IArtifact[] convertURLStringToArtifacts(String urls, IArtifactTraversalContext context, boolean variableSubs) throws Exception {
        String urlLowerCase = urls.toLowerCase();
        if (urlLowerCase.indexOf(SONICFS_PREFIX) == -1 && urlLowerCase.indexOf(SONIC_PREFIX) == -1 && urlLowerCase.indexOf(SONICESB_PREFIX) == -1) {
            return new IArtifact[0];
        }
        ArrayList<IArtifact> list = new ArrayList<IArtifact>();
        if (variableSubs) {
            RegExIterator iter = new RegExIterator(VariableConstants.VARIABLE_PATTERN, urls, true);
            while (iter.hasNext()) {
                String token = (String)iter.next();
                if (iter.wasLastTokenVariable()) {
                    if (!token.startsWith(VARIABLE_PREFIX)) continue;
                    list.add(this.createArtifactForURL(token.substring(2, token.length() - 1), context));
                    continue;
                }
                this.tokenizeURLToArtifacts(token, context, list);
            }
        } else {
            this.tokenizeURLToArtifacts(urls, context, list);
        }
        return list.toArray(new IArtifact[0]);
    }

    private void tokenizeURLToArtifacts(String urls, IArtifactTraversalContext context, List list) throws Exception {
        StringTokenizer st = new StringTokenizer(urls, ";");
        while (st.hasMoreTokens()) {
            IArtifact artifact = this.createArtifactForURL(st.nextToken(), context);
            if (artifact == null) continue;
            list.add(artifact);
        }
    }

    private IArtifact createArtifactForURL(String urlParam, IArtifactTraversalContext context) throws Exception {
        String url = urlParam;
        if (url == null) {
            return null;
        }
        if ((url = url.trim()).length() == 0) {
            return null;
        }
        String check = url.toLowerCase();
        int start = check.indexOf(SONICFS_PREFIX);
        if (start != -1) {
            return this.createArtifactForSonicfsURL(url.substring(start), context);
        }
        start = check.indexOf(SONIC_PREFIX);
        if (start != -1) {
            return this.createArtifactForSonicURL(url.substring(start), context);
        }
        start = check.indexOf(SONICESB_PREFIX);
        if (start != -1) {
            return this.createArtifactForSonicESBURL(url.substring(start), context);
        }
        return null;
    }

    protected IArtifact createArtifactForSonicfsURL(String sonicfsURL, IArtifactTraversalContext context) throws Exception {
        int index;
        String name = sonicfsURL.substring(SONICFS_PREFIX.length());
        if (!name.startsWith("/") && (index = name.indexOf(47)) != -1) {
            name = name.substring(index);
        }
        if ((index = name.lastIndexOf(35)) != -1) {
            name = name.substring(0, index);
        }
        if ((index = name.indexOf(39)) != -1) {
            name = name.substring(0, index);
        }
        if ((index = name.indexOf(34)) != -1) {
            name = name.substring(0, index);
        }
        if (ZipFileArtifact.isArchiveFile(name)) {
            return new ZipFileArtifact(name);
        }
        return new SonicFSArtifact(name);
    }

    protected IArtifact createArtifactForSonicURL(String url, IArtifactTraversalContext context) throws Exception {
        int index = url.lastIndexOf(47);
        if (index != -1) {
            ESBArtifact testArtifact;
            String esbName = url.substring(index + 1);
            IArtifactStorage storage = context.getStorage();
            boolean exists = storage.exists(testArtifact = new ESBArtifact(ESBArtifact.SERVICE, esbName));
            if (exists) {
                return testArtifact;
            }
            testArtifact = new ESBArtifact(ESBArtifact.PROCESS, esbName);
            exists = storage.exists(testArtifact);
            if (exists) {
                return testArtifact;
            }
            ((AbstractArtifactStorage)storage)._notifyMessage(4, "Error: Unable to locate artifact for url '" + url + "'");
            context.addErrored(testArtifact);
        }
        return null;
    }

    protected IArtifact createArtifactForSonicESBURL(String url, IArtifactTraversalContext context) throws Exception {
        ESBArtifact artifact = null;
        String name = url.substring(SONICESB_PREFIX.length());
        int index = name.indexOf(47);
        String type = name.substring(0, index);
        int queryIdx = name.indexOf(63);
        name = queryIdx != -1 ? name.substring(index + 1, queryIdx) : name.substring(index + 1);
        if ("service".equalsIgnoreCase(type)) {
            artifact = new ESBArtifact(ESBArtifact.SERVICE, name);
        } else if ("process".equalsIgnoreCase(type)) {
            artifact = new ESBArtifact(ESBArtifact.PROCESS, name);
        } else if ("endpoint".equalsIgnoreCase(type)) {
            artifact = new ESBArtifact(ESBArtifact.ENDPOINT, name);
        } else {
            ((AbstractArtifactStorage)context.getStorage())._notifyMessage(4, "Error: Unable to locate artifact for url '" + url + "'");
        }
        return artifact;
    }
}

