/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.traversal;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactTraverser;
import com.sonicsw.deploy.artifact.ESBArtifact;
import com.sonicsw.deploy.traversal.ESBConnectionTraverser;
import com.sonicsw.deploy.traversal.ESBConnectionTypeTraverser;
import com.sonicsw.deploy.traversal.ESBContainerTraverser;
import com.sonicsw.deploy.traversal.ESBEndpointTraverser;
import com.sonicsw.deploy.traversal.ESBEndpointTypeTraverser;
import com.sonicsw.deploy.traversal.ESBListTraverser;
import com.sonicsw.deploy.traversal.ESBProcessTraverser;
import com.sonicsw.deploy.traversal.ESBServiceTraverser;
import com.sonicsw.deploy.traversal.ESBServiceTypeTraverser;

public class ESBTraverserFactory {
    public static IArtifactTraverser createTraverser(IArtifact artifact) throws Exception {
        if (!(artifact instanceof ESBArtifact)) {
            throw new Exception("Invalid artifact type for traverser");
        }
        if (artifact.isRootPath() || artifact.isDirectory()) {
            return new ESBListTraverser(artifact);
        }
        String root = artifact.getRootDirectory();
        if (root.equals(ESBArtifact.PROCESS.getRootDirectory())) {
            return new ESBProcessTraverser(artifact);
        }
        if (root.equals(ESBArtifact.ENDPOINT.getRootDirectory())) {
            return new ESBEndpointTraverser(artifact);
        }
        if (root.equals(ESBArtifact.SERVICE.getRootDirectory())) {
            return new ESBServiceTraverser(artifact);
        }
        if (root.equals(ESBArtifact.CONTAINER.getRootDirectory())) {
            return new ESBContainerTraverser(artifact);
        }
        if (root.equals(ESBArtifact.CONNECTION.getRootDirectory())) {
            return new ESBConnectionTraverser(artifact);
        }
        if (root.equals(ESBArtifact.CONNECTION_TYPE.getRootDirectory())) {
            return new ESBConnectionTypeTraverser(artifact);
        }
        if (root.equals(ESBArtifact.ENDPOINT_TYPE.getRootDirectory())) {
            return new ESBEndpointTypeTraverser(artifact);
        }
        if (root.equals(ESBArtifact.SERVICE_TYPE.getRootDirectory())) {
            return new ESBServiceTypeTraverser(artifact);
        }
        throw new Exception("Failed to create ESB traverser for " + artifact.getPath());
    }

    public static IArtifactTraverser createProcessTraverser(String name) throws Exception {
        return new ESBProcessTraverser(new ESBArtifact(ESBArtifact.PROCESS, name));
    }

    public static IArtifactTraverser createServiceTraverser(String name) throws Exception {
        return new ESBServiceTraverser(new ESBArtifact(ESBArtifact.SERVICE, name));
    }

    public static IArtifactTraverser createEndpointTraverser(String name) throws Exception {
        return new ESBEndpointTraverser(new ESBArtifact(ESBArtifact.ENDPOINT, name));
    }

    public static IArtifactTraverser createConnectionTraverser(String name) throws Exception {
        return new ESBConnectionTraverser(new ESBArtifact(ESBArtifact.CONNECTION, name));
    }

    public static IArtifactTraverser createContainerTraverser(String name) throws Exception {
        return new ESBContainerTraverser(new ESBArtifact(ESBArtifact.CONTAINER, name));
    }

    public static IArtifactTraverser createConnectionTypeTraverser(String name) throws Exception {
        return new ESBConnectionTypeTraverser(new ESBArtifact(ESBArtifact.CONNECTION_TYPE, name));
    }

    public static IArtifactTraverser createEndpointTypeTraverser(String name) throws Exception {
        return new ESBEndpointTypeTraverser(new ESBArtifact(ESBArtifact.ENDPOINT_TYPE, name));
    }

    public static IArtifactTraverser createServiceTypeTraverser(String name) throws Exception {
        return new ESBServiceTypeTraverser(new ESBArtifact(ESBArtifact.SERVICE_TYPE, name));
    }
}

