/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.traversal;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactTraversalContext;
import com.sonicsw.deploy.IArtifactTraverser;
import com.sonicsw.deploy.artifact.SonicFSArtifact;
import com.sonicsw.deploy.artifact.ZipFileArtifact;
import com.sonicsw.deploy.traversal.BPELProcessTraverser;
import com.sonicsw.deploy.traversal.ExtnPropertiesTraverser;
import com.sonicsw.deploy.traversal.ExtnXMLTraverser;
import com.sonicsw.deploy.traversal.ExtnXPRJTraverser;
import com.sonicsw.deploy.traversal.ProcessSetTraverser;
import com.sonicsw.deploy.traversal.ZipContentTraverser;

public class ExtnTraverserFactory {
    public static IArtifactTraverser createTraverser(IArtifact artifact, IArtifactTraversalContext context) throws Exception {
        if (!(artifact instanceof SonicFSArtifact)) {
            throw new Exception("Invalid artifact type for traverser");
        }
        String extension = artifact.getExtension();
        if (extension == null) {
            return null;
        }
        if (ExtnXPRJTraverser.isValidExtension(extension)) {
            return new ExtnXPRJTraverser(artifact);
        }
        if (ZipFileArtifact.isArchiveExtension(extension)) {
            return new ZipContentTraverser(artifact);
        }
        if (BPELProcessTraverser.isValidExtension(extension)) {
            return new BPELProcessTraverser(artifact);
        }
        if (ProcessSetTraverser.isProcessSet(artifact.getName())) {
            return new ProcessSetTraverser(artifact);
        }
        if (ExtnXMLTraverser.isValidExtension(extension)) {
            return new ExtnXMLTraverser(artifact);
        }
        if (ExtnPropertiesTraverser.isValidExtension(extension)) {
            return new ExtnPropertiesTraverser(artifact);
        }
        return null;
    }
}

