/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.traversal;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactTraversalContext;
import com.sonicsw.deploy.traversal.AbstractExtnTraverser;
import com.sonicsw.deploy.util.PropertyUtils;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExtnXMLTraverser
extends AbstractExtnTraverser {
    private static final String TRAVERSAL_XML_ENABLED = "traversal.xml.enabled";
    private static final String TRAVERSAL_XML_EXTENSIONS = "traversal.xml.extensions";
    private static final String DEFAULT_EXTENSIONS = "xsl,xslt,xml,xsd,wsdl,esbws,esbdx,esbdb,xaction,cbr,bpdd";
    private static boolean s_enabled;
    private static List s_extensions;

    public ExtnXMLTraverser(IArtifact artifact) {
        super(artifact);
    }

    public static boolean isValidExtension(String extension) {
        if (!s_enabled) {
            return false;
        }
        return s_extensions.contains(extension.toLowerCase());
    }

    @Override
    public void doTraversal(IArtifactTraversalContext context) throws Exception {
        Document doc = context.getStorage().getContentsAsDom(this.m_artifact);
        doc.normalize();
        Element element = doc.getDocumentElement();
        this.traverseAttributes(element.getAttributes(), context);
        this.traverseChildNodes(element.getChildNodes(), context);
    }

    static {
        PropertyUtils prop = PropertyUtils.getInstance();
        s_enabled = prop.getBooleanProperty(TRAVERSAL_XML_ENABLED, true);
        if (s_enabled) {
            s_extensions = prop.tokenizeToLower(prop.getProperty(TRAVERSAL_XML_EXTENSIONS, DEFAULT_EXTENSIONS));
        }
    }
}

