/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.util;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.action.SearchAction;
import com.sonicsw.deploy.storage.FileArtifactStorage;
import com.sonicsw.deploy.tools.common.ExportPropertiesArtifact;
import com.sonicsw.deploy.traversal.TraverserFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;

public class FileSystemScanner {
    private IArtifact[] m_readOnlyArtifacts = new IArtifact[0];
    private IArtifact[] m_readOnlyChangedArtifacts = new IArtifact[0];
    private IArtifact[] m_newArtifacts = new IArtifact[0];
    private IArtifact[] m_changedArtifacts = new IArtifact[0];
    private IArtifact[] m_unchangedArtifacts = new IArtifact[0];

    public boolean hasChanged() {
        return this.m_changedArtifacts.length > 0;
    }

    public boolean hasUnchanged() {
        return this.m_unchangedArtifacts.length > 0;
    }

    public boolean hasNew() {
        return this.m_newArtifacts.length > 0;
    }

    public boolean hasReadOnly() {
        return this.m_readOnlyArtifacts.length > 0;
    }

    public boolean hasReadOnlyChanged() {
        return this.m_readOnlyChangedArtifacts.length > 0;
    }

    public IArtifact[] getChanged() {
        return this.m_changedArtifacts;
    }

    public IArtifact[] getUnchanged() {
        return this.m_unchangedArtifacts;
    }

    public IArtifact[] getNew() {
        return this.m_newArtifacts;
    }

    public IArtifact[] getReadOnly() {
        return this.m_readOnlyArtifacts;
    }

    public IArtifact[] getReadOnlyChanged() {
        return this.m_readOnlyChangedArtifacts;
    }

    public void scanFileSystemForReadOnly(String fileSystemRoot) throws Exception {
        FileArtifactStorage store = new FileArtifactStorage();
        store.setRoot(fileSystemRoot);
        IArtifact[] artifacts = SearchAction.search((IArtifactStorage)store, null, TraverserFactory.createListAllTraverser());
        ArrayList<IArtifact> readOnlyList = new ArrayList<IArtifact>();
        for (int i = 0; i < artifacts.length; ++i) {
            File file = new File(fileSystemRoot + FileArtifactStorage.getFilename(artifacts[i]));
            if (file == null || file.canWrite()) continue;
            readOnlyList.add(artifacts[i]);
        }
        this.m_readOnlyArtifacts = readOnlyList.toArray(new IArtifact[0]);
    }

    public void scanFileSystemForOverwrite(String fileSystemRoot, IArtifactStorage sourceStore, IArtifact[] artifacts) throws FileNotFoundException, IOException, Exception {
        File targetDir = new File(fileSystemRoot);
        if (!targetDir.exists()) {
            throw new Exception("Target directory: " + fileSystemRoot + " does not exist");
        }
        ArrayList<IArtifact> changedList = new ArrayList<IArtifact>();
        ArrayList<IArtifact> unchangedList = new ArrayList<IArtifact>();
        ArrayList<IArtifact> newList = new ArrayList<IArtifact>();
        ArrayList<IArtifact> readOnlyChangedList = new ArrayList<IArtifact>();
        for (int i = 0; i < artifacts.length; ++i) {
            String artifactPath;
            File file;
            if (artifacts[i] instanceof ExportPropertiesArtifact || (file = new File(artifactPath = fileSystemRoot + FileArtifactStorage.getFilename(artifacts[i]))) == null) continue;
            if (file.exists()) {
                if (!file.isFile()) continue;
                if (this.isChanged(file, sourceStore, artifacts[i])) {
                    changedList.add(artifacts[i]);
                    if (file.canWrite()) continue;
                    readOnlyChangedList.add(artifacts[i]);
                    continue;
                }
                unchangedList.add(artifacts[i]);
                continue;
            }
            newList.add(artifacts[i]);
        }
        this.m_unchangedArtifacts = unchangedList.toArray(new IArtifact[0]);
        this.m_changedArtifacts = changedList.toArray(new IArtifact[0]);
        this.m_newArtifacts = newList.toArray(new IArtifact[0]);
        this.m_readOnlyChangedArtifacts = readOnlyChangedList.toArray(new IArtifact[0]);
    }

    private boolean isChanged(File targetFile, IArtifactStorage sourceStore, IArtifact artifact) throws FileNotFoundException, IOException, Exception {
        FileInputStream fileStream = new FileInputStream(targetFile);
        int fileLength = (int)targetFile.length();
        byte[] fileBytes = new byte[fileLength];
        for (int bytesReadTotal = 0; bytesReadTotal < fileLength; bytesReadTotal += fileStream.read(fileBytes, bytesReadTotal, fileLength - bytesReadTotal)) {
        }
        byte[] storeBytes = sourceStore.getContentsAsBytes(artifact);
        boolean changed = false;
        if (fileBytes.length != storeBytes.length) {
            changed = true;
        } else {
            for (int j = 0; j < fileBytes.length; ++j) {
                if (fileBytes[j] == storeBytes[j]) continue;
                changed = true;
                break;
            }
        }
        return changed;
    }
}

