/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.util;

import com.sonicsw.sonicxq.AdditionalStringParam;
import com.sonicsw.sonicxq.AdditionalXmlParam;
import com.sonicsw.sonicxq.ArtifactWarningType;
import com.sonicsw.sonicxq.ArtifactWarningsType;
import com.sonicsw.sonicxq.ArtifactsNotFoundType;
import com.sonicsw.sonicxq.ArtifactsNotInArchiveType;
import com.sonicsw.sonicxq.ArtifactsNotInMapType;
import com.sonicsw.sonicxq.ParamsMapType;
import com.sonicsw.sonicxq.ParamsType;
import com.sonicsw.sonicxq.TailoringList;
import com.sonicsw.sonicxq.TailoringLogDocument;
import com.sonicsw.sonicxq.UpdatedArtifactType;
import com.sonicsw.sonicxq.UpdatedArtifactsType;
import com.sonicsw.sonicxq.UpdatedStringParam;
import com.sonicsw.sonicxq.UpdatedXmlParam;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;

public class MapLog {
    private TailoringLogDocument m_logfileDoc;
    private TailoringList m_logRecord;
    private File m_outFile;
    private List m_updatedArtifactList = new Vector();
    private UpdatedArtifactType m_currentArtifact = null;
    private List m_updatedStringParams = new Vector();
    private List m_updatedXmlParams = new Vector();
    private List m_additionalStringParams = new Vector();
    private List m_additionalXmlParams = new Vector();
    private Map m_missingFromXarList = new HashMap();
    private Map m_missingFromMapList = new HashMap();
    private XmlOptions m_opts = new XmlOptions();

    public MapLog(File outFile) {
        this.m_opts.setSavePrettyPrint();
        this.m_opts.setSavePrettyPrintIndent(4);
        this.m_logfileDoc = TailoringLogDocument.Factory.newInstance();
        this.m_logRecord = TailoringList.Factory.newInstance();
        this.m_outFile = outFile;
    }

    public void write() throws IOException, XmlException {
        ArtifactsNotFoundType[] missingFromMapList;
        ArtifactsNotFoundType[] missingFromXarList;
        this.storeParamsForItem();
        if (this.m_updatedArtifactList.size() > 0) {
            UpdatedArtifactsType updatedArtifacts = UpdatedArtifactsType.Factory.newInstance();
            UpdatedArtifactType[] updatedParamList = new UpdatedArtifactType[this.m_updatedArtifactList.size()];
            for (int i = 0; i < this.m_updatedArtifactList.size(); ++i) {
                updatedParamList[i] = (UpdatedArtifactType)((Vector)this.m_updatedArtifactList).elementAt(i);
            }
            updatedArtifacts.setUpdatedArtifactArray(updatedParamList);
            this.m_logRecord.setUpdatedArtifacts(updatedArtifacts);
        }
        if ((missingFromXarList = this.writeMissingArtifactEntries(this.m_missingFromXarList)) != null) {
            ArtifactsNotInArchiveType missingXarEntries = ArtifactsNotInArchiveType.Factory.newInstance();
            missingXarEntries.setArtifactNotInArchiveArray(missingFromXarList);
            this.m_logRecord.setArtifactsNotInArchive(missingXarEntries);
        }
        if ((missingFromMapList = this.writeMissingArtifactEntries(this.m_missingFromMapList)) != null) {
            ArtifactsNotInMapType missingMapEntries = ArtifactsNotInMapType.Factory.newInstance();
            missingMapEntries.setArtifactNotInMapArray(missingFromMapList);
            this.m_logRecord.setArtifactsNotInMap(missingMapEntries);
        }
        this.m_opts.setUseDefaultNamespace();
        this.m_logfileDoc.setTailoringLog(this.m_logRecord);
        this.m_logfileDoc.save(this.m_outFile, this.m_opts);
    }

    public ArtifactsNotFoundType[] writeMissingArtifactEntries(Map missingMap) {
        ArtifactsNotFoundType[] missingFromList = null;
        if (missingMap.size() > 0) {
            Set keys = missingMap.keySet();
            Iterator keyIter = keys.iterator();
            missingFromList = new ArtifactsNotFoundType[missingMap.size()];
            for (int i = 0; i < keys.size(); ++i) {
                String key = (String)keyIter.next();
                MissingArtifactEntries missingList = (MissingArtifactEntries)missingMap.get(key);
                String[] missingNames = new String[missingList.entryNames.size()];
                for (int j = 0; j < missingList.entryNames.size(); ++j) {
                    missingNames[j] = (String)((Vector)missingList.entryNames).elementAt(j);
                }
                ArtifactsNotFoundType missingFromEntry = ArtifactsNotFoundType.Factory.newInstance();
                missingFromEntry.setType(missingList.entryType);
                missingFromEntry.setNameArray(missingNames);
                missingFromList[i] = missingFromEntry;
            }
        }
        return missingFromList;
    }

    public void checkForNewArtifact(String objectType, String objectName) {
        boolean newArtifact = false;
        if (this.m_currentArtifact == null) {
            newArtifact = true;
        } else if (!this.m_currentArtifact.getName().equals(objectName) || !this.m_currentArtifact.getType().equals(objectType)) {
            this.storeParamsForItem();
            newArtifact = true;
        }
        if (newArtifact) {
            this.m_currentArtifact = UpdatedArtifactType.Factory.newInstance();
            this.m_currentArtifact.setName(objectName);
            this.m_currentArtifact.setType(objectType);
        }
    }

    public void logUpdate(String objectType, String objectName, String paramName, String oldValue, String newValue) {
        if (oldValue == null || newValue == null) {
            return;
        }
        if (oldValue.equals(newValue)) {
            return;
        }
        this.checkForNewArtifact(objectType, objectName);
        UpdatedStringParam param = UpdatedStringParam.Factory.newInstance();
        param.setParamName(paramName);
        param.setOldValue(oldValue);
        param.setNewValue(newValue);
        this.m_updatedStringParams.add(param);
    }

    public void logUpdate(String objectType, String objectName, String paramName, ParamsType.XmlParam oldValue, ParamsMapType.XmlParam newValue) {
        XmlCursor targetParamCursor;
        if (oldValue == null || newValue == null) {
            return;
        }
        if (oldValue.equals(newValue)) {
            return;
        }
        this.checkForNewArtifact(objectType, objectName);
        UpdatedXmlParam param = UpdatedXmlParam.Factory.newInstance();
        param.setParamName(paramName);
        XmlCursor sourceParamCursor = oldValue.newCursor();
        if (sourceParamCursor.toFirstChild()) {
            UpdatedXmlParam.OldValue oldParam = UpdatedXmlParam.OldValue.Factory.newInstance();
            targetParamCursor = oldParam.newCursor();
            targetParamCursor.toFirstContentToken();
            sourceParamCursor.copyXml(targetParamCursor);
            param.setOldValue(oldParam);
        }
        if ((sourceParamCursor = newValue.newCursor()).toFirstChild()) {
            UpdatedXmlParam.NewValue newParam = UpdatedXmlParam.NewValue.Factory.newInstance();
            targetParamCursor = newParam.newCursor();
            targetParamCursor.toFirstContentToken();
            sourceParamCursor.copyXml(targetParamCursor);
            param.setNewValue(newParam);
        }
        this.m_updatedXmlParams.add(param);
    }

    public void logAdditional(String objectType, String objectName, String paramName, String newValue) {
        this.checkForNewArtifact(objectType, objectName);
        AdditionalStringParam param = AdditionalStringParam.Factory.newInstance();
        param.setParamName(paramName);
        param.setNewValue(newValue);
        this.m_additionalStringParams.add(param);
    }

    public void logAdditional(String objectType, String objectName, String paramName, ParamsMapType.XmlParam newValue) {
        this.checkForNewArtifact(objectType, objectName);
        AdditionalXmlParam param = AdditionalXmlParam.Factory.newInstance();
        param.setParamName(paramName);
        XmlCursor sourceParamCursor = newValue.newCursor();
        if (sourceParamCursor.toFirstChild()) {
            AdditionalXmlParam.NewValue newParam = AdditionalXmlParam.NewValue.Factory.newInstance();
            XmlCursor targetParamCursor = newParam.newCursor();
            targetParamCursor.toFirstContentToken();
            sourceParamCursor.copyXml(targetParamCursor);
            param.setNewValue(newParam);
        }
        this.m_additionalXmlParams.add(param);
    }

    private void storeParamsForItem() {
        Object[] additionalParamList;
        int i;
        Object[] updatedParamList;
        if (this.m_updatedStringParams.size() == 0 && this.m_additionalStringParams.size() == 0 && this.m_updatedXmlParams.size() == 0 && this.m_additionalXmlParams.size() == 0) {
            return;
        }
        if (this.m_updatedStringParams.size() > 0) {
            updatedParamList = new UpdatedStringParam[this.m_updatedStringParams.size()];
            for (i = 0; i < this.m_updatedStringParams.size(); ++i) {
                updatedParamList[i] = (UpdatedStringParam)((Vector)this.m_updatedStringParams).elementAt(i);
            }
            this.m_currentArtifact.setUpdatedStringArray((UpdatedStringParam[])updatedParamList);
        }
        this.m_updatedStringParams.clear();
        if (this.m_additionalStringParams.size() > 0) {
            additionalParamList = new AdditionalStringParam[this.m_additionalStringParams.size()];
            for (i = 0; i < this.m_additionalStringParams.size(); ++i) {
                additionalParamList[i] = (AdditionalStringParam)((Vector)this.m_additionalStringParams).elementAt(i);
            }
            this.m_currentArtifact.setAdditionalStringArray((AdditionalStringParam[])additionalParamList);
        }
        this.m_additionalStringParams.clear();
        if (this.m_updatedXmlParams.size() > 0) {
            updatedParamList = new UpdatedXmlParam[this.m_updatedXmlParams.size()];
            for (i = 0; i < this.m_updatedXmlParams.size(); ++i) {
                updatedParamList[i] = (UpdatedXmlParam)((Vector)this.m_updatedXmlParams).elementAt(i);
            }
            this.m_currentArtifact.setUpdatedXmlArray((UpdatedXmlParam[])updatedParamList);
        }
        this.m_updatedXmlParams.clear();
        if (this.m_additionalXmlParams.size() > 0) {
            additionalParamList = new AdditionalXmlParam[this.m_additionalXmlParams.size()];
            for (i = 0; i < this.m_additionalXmlParams.size(); ++i) {
                additionalParamList[i] = (AdditionalXmlParam)((Vector)this.m_additionalXmlParams).elementAt(i);
            }
            this.m_currentArtifact.setAdditionalXmlArray((AdditionalXmlParam[])additionalParamList);
        }
        this.m_additionalXmlParams.clear();
        this.m_updatedArtifactList.add(this.m_currentArtifact);
    }

    public void missingFromMap(String objectType, String objectName) {
        this.populateMapEntry(this.m_missingFromMapList, objectType, objectName);
    }

    public void addMapEntry(String objectType, String objectName) {
        this.populateMapEntry(this.m_missingFromXarList, objectType, objectName);
    }

    private void populateMapEntry(Map m_missingFromXarList, String objectType, String objectName) {
        MissingArtifactEntries missingEntryList = (MissingArtifactEntries)m_missingFromXarList.get(objectType);
        if (missingEntryList == null) {
            missingEntryList = new MissingArtifactEntries();
            missingEntryList.entryType = objectType;
            missingEntryList.entryNames = new Vector();
            m_missingFromXarList.put(objectType, missingEntryList);
        }
        missingEntryList.entryNames.add(objectName);
    }

    public void foundXarArtifact(String objectType, String objectName) throws Exception {
        MissingArtifactEntries missingEntryList = (MissingArtifactEntries)this.m_missingFromXarList.get(objectType);
        if (missingEntryList == null) {
            String errorMsg = new String("MapLog: expected item list not found: ");
            errorMsg = errorMsg + objectType;
            throw new Exception(errorMsg);
        }
        missingEntryList.entryNames.remove(objectName);
        if (missingEntryList.entryNames.size() == 0) {
            this.m_missingFromXarList.remove(objectType);
        }
    }

    public void addWarnings(List warningArrayList) {
        ArtifactWarningsType warnings = ArtifactWarningsType.Factory.newInstance();
        ArtifactWarningType[] warningArray = warningArrayList.toArray(new ArtifactWarningType[0]);
        warnings.setArtifactWarningArray(warningArray);
        this.m_logRecord.setArtifactWarnings(warnings);
    }

    private class MissingArtifactEntries {
        public String entryType;
        public List entryNames;

        private MissingArtifactEntries() {
        }
    }
}

