/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.tools.common;

import com.sonicsw.xqimpl.tools.common.DSConnectionDetails;
import com.sonicsw.xqimpl.tools.common.IESBContainerInfo;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ESBContainerInfo
implements IESBContainerInfo {
    private static final String CONTAINERS_DEFAULT_LOCATION = "/Containers/";
    private static final String MF_CONTAINER_PATH_PATTERN = ".+/(.+)$";
    private String mfContainerName;
    private String esbContainerName;
    private DSConnectionDetails conxDetails;
    private String mfContainerCanonicalName;
    private String mfContainerLocaltion;

    public ESBContainerInfo(String mfContainerName, String esbContainerName, DSConnectionDetails conxDetails) throws Exception {
        this.esbContainerName = esbContainerName;
        this.conxDetails = conxDetails;
        this.mfContainerName = mfContainerName;
        this.init();
    }

    private void init() throws IllegalArgumentException {
        if (this.esbContainerName != null) {
            String domainNamePrefix;
            if (this.mfContainerName == null) {
                this.mfContainerName = this.esbContainerName;
            }
            if (this.mfContainerName.startsWith(domainNamePrefix = this.conxDetails.getDomainName() + ".")) {
                this.mfContainerCanonicalName = this.mfContainerName;
                this.mfContainerName = this.mfContainerName.substring(domainNamePrefix.length());
            } else {
                this.mfContainerCanonicalName = domainNamePrefix + this.mfContainerName;
            }
        } else {
            throw new IllegalArgumentException("Invalid ESB Container Name (Empty)");
        }
    }

    @Override
    public String getESBContainerName() {
        return this.esbContainerName;
    }

    @Override
    public String getMFContainerName() {
        return this.mfContainerName;
    }

    @Override
    public String getMFContainerCanonicalName() {
        return this.mfContainerCanonicalName;
    }

    @Override
    public String getMFContainerLocation() {
        return this.mfContainerLocaltion;
    }

    @Override
    public void setMFContainerLocation(String mfContainerLocation) throws IllegalArgumentException {
        Pattern pattern = Pattern.compile(MF_CONTAINER_PATH_PATTERN);
        Matcher matcher = pattern.matcher(mfContainerLocation);
        if (matcher.matches()) {
            this.mfContainerLocaltion = mfContainerLocation;
            this.mfContainerName = matcher.group(1);
            this.init();
        } else {
            this.mfContainerLocaltion = CONTAINERS_DEFAULT_LOCATION + mfContainerLocation;
        }
    }
}

