/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.compare;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactComparison;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.compare.AbstractComparator;
import com.sonicsw.deploy.compare.ComparisonResult;
import com.sonicsw.deploy.util.PropertyUtils;
import java.util.List;

public abstract class AbstractFileComparator
extends AbstractComparator {
    private static final String COMPARISON_XML_EXTENSIONS = "comparison.xml.extensions";
    private static final String DEFAULT_XML_EXTENSIONS = "amap,bp,bpdd,bpel,cbr,esbp,esbws,esbdx,esbdb,drop,pickup,prj,wsdl,xaction,xcbr,xml,xprj,xsd,xsl,xslt";
    private static final String COMPARISON_TEXT_EXTENSIONS = "comparison.text.extensions";
    private static final String DEFAULT_TEXT_EXTENSIONS = "css,html,js,properties,props,xquery,txt,sh,bat";
    private static final String COMPARISON_BIN_EXTENSIONS = "comparison.bin.extensions";
    private static final String DEFAULT_BIN_EXTENSIONS = "bpar,bpv,csar,gif,jar,jpg,xar,jks";
    private static List<String> s_xmlExtensions;
    private static List<String> s_textExtensions;
    private static List<String> s_binExtensions;

    public AbstractFileComparator(IArtifact artifact) {
        super(artifact);
    }

    public static boolean isXMLExtension(String extension) {
        if (extension == null) {
            return false;
        }
        return s_xmlExtensions.contains(extension.toLowerCase());
    }

    public static boolean isTextExtension(String extension) {
        if (extension == null) {
            return false;
        }
        return s_textExtensions.contains(extension.toLowerCase());
    }

    public static boolean isBinExtension(String extension) {
        if (extension == null) {
            return false;
        }
        return s_binExtensions.contains(extension.toLowerCase());
    }

    @Override
    public IArtifactComparison compare(IArtifactStorage source, IArtifactStorage destination) {
        String extension = this.getArtifact().getExtension();
        try {
            if (extension == null) {
                return this.compareAsBytes(source.getContentsAsBytes(this.getArtifact()), destination.getContentsAsBytes(this.getArtifact()));
            }
            if (AbstractFileComparator.isXMLExtension(extension)) {
                return this.compareAsXML(source.getContentsAsString(this.getArtifact()), destination.getContentsAsString(this.getArtifact()));
            }
            if (AbstractFileComparator.isTextExtension(extension)) {
                return this.compareAsString(source.getContentsAsString(this.getArtifact()), destination.getContentsAsString(this.getArtifact()));
            }
            return this.compareAsBytes(source.getContentsAsBytes(this.getArtifact()), destination.getContentsAsBytes(this.getArtifact()));
        }
        catch (Exception e) {
            ComparisonResult result = new ComparisonResult(this.getArtifact());
            result.setEqual(false);
            result.setEquivalent(false);
            result.setMessage("Exception occurred during artifact comparison: " + e.getMessage());
            return result;
        }
    }

    static {
        int index;
        int i;
        PropertyUtils prop = PropertyUtils.getInstance();
        s_xmlExtensions = prop.tokenizeToLower(prop.getProperty(COMPARISON_XML_EXTENSIONS, DEFAULT_XML_EXTENSIONS));
        s_textExtensions = prop.tokenizeToLower(prop.getProperty(COMPARISON_TEXT_EXTENSIONS, DEFAULT_TEXT_EXTENSIONS));
        s_binExtensions = prop.tokenizeToLower(prop.getProperty(COMPARISON_BIN_EXTENSIONS, DEFAULT_BIN_EXTENSIONS));
        for (i = 0; i < s_textExtensions.size(); ++i) {
            index = s_binExtensions.indexOf(s_xmlExtensions.get(i));
            if (index == -1) continue;
            s_binExtensions.remove(index);
        }
        for (i = 0; i < s_xmlExtensions.size(); ++i) {
            index = s_textExtensions.indexOf(s_xmlExtensions.get(i));
            if (index != -1) {
                s_textExtensions.remove(index);
            }
            if ((index = s_binExtensions.indexOf(s_xmlExtensions.get(i))) == -1) continue;
            s_binExtensions.remove(index);
        }
    }
}

